/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebSocketExtensionUtil {
    private static final String EXTENSION_SEPARATOR = ",";
    private static final String PARAMETER_SEPARATOR = ";";
    private static final char PARAMETER_EQUAL = '=';
    private static final Pattern PARAMETER = Pattern.compile("^([^=]+)(=[\\\"]?([^\\\"]+)[\\\"]?)?$");

    static boolean isWebsocketUpgrade(HttpHeaders headers) {
        HttpHeaders httpHeaders;
        return headers.contains((CharSequence)HttpHeaderNames.UPGRADE) && headers.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && httpHeaders.contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    /*
     * WARNING - void declaration
     */
    public static List<WebSocketExtensionData> extractExtensions(String extensionHeader) {
        String[] rawExtensions = extensionHeader.split(EXTENSION_SEPARATOR);
        if (rawExtensions.length > 0) {
            void var1_1;
            String[] stringArray;
            ArrayList<WebSocketExtensionData> extensions = new ArrayList<WebSocketExtensionData>(rawExtensions.length);
            for (String string : stringArray) {
                Map<String, String> parameters;
                String[] extensionParameters = string.split(PARAMETER_SEPARATOR);
                String name = extensionParameters[0].trim();
                if (extensionParameters.length > 1) {
                    parameters = new HashMap(extensionParameters.length - 1);
                    for (int i = 1; i < extensionParameters.length; ++i) {
                        String parameter = extensionParameters[i].trim();
                        Matcher parameterMatcher = PARAMETER.matcher(parameter);
                        if (!parameterMatcher.matches() || parameterMatcher.group(1) == null) continue;
                        parameters.put(parameterMatcher.group(1), parameterMatcher.group(3));
                    }
                } else {
                    parameters = Collections.emptyMap();
                }
                extensions.add(new WebSocketExtensionData(name, parameters));
            }
            return var1_1;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    static String computeMergeExtensionsHeaderValue(String userDefinedHeaderValue, List<WebSocketExtensionData> extraExtensions) {
        CharSequence charSequence;
        void var1_1;
        userDefinedHeaderValue = userDefinedHeaderValue != null ? WebSocketExtensionUtil.extractExtensions((String)((Object)userDefinedHeaderValue)) : Collections.emptyList();
        userDefinedHeaderValue = userDefinedHeaderValue.iterator();
        while (userDefinedHeaderValue.hasNext()) {
            Iterator<WebSocketExtensionData> iterator;
            int i;
            WebSocketExtensionData userDefined = (WebSocketExtensionData)userDefinedHeaderValue.next();
            WebSocketExtensionData matchingExtra = null;
            for (i = 0; i < extraExtensions.size(); ++i) {
                WebSocketExtensionData extra = extraExtensions.get(i);
                if (!extra.name().equals(userDefined.name())) continue;
                matchingExtra = extra;
                break;
            }
            if (matchingExtra == null) {
                extraExtensions.add(userDefined);
                continue;
            }
            HashMap<String, String> mergedParameters = new HashMap<String, String>(matchingExtra.parameters());
            mergedParameters.putAll(((WebSocketExtensionData)((Object)iterator)).parameters());
            extraExtensions.set(i, new WebSocketExtensionData(matchingExtra.name(), mergedParameters));
        }
        CharSequence sb = new StringBuilder(150);
        for (WebSocketExtensionData data : extraExtensions) {
            void var3_3;
            ((StringBuilder)sb).append(data.name());
            for (Map.Entry<String, String> parameter : var3_3.parameters().entrySet()) {
                ((StringBuilder)sb).append(PARAMETER_SEPARATOR);
                ((StringBuilder)sb).append(parameter.getKey());
                if (parameter.getValue() == null) continue;
                ((StringBuilder)sb).append('=');
                ((StringBuilder)sb).append(parameter.getValue());
            }
            ((StringBuilder)sb).append(EXTENSION_SEPARATOR);
        }
        if (!var1_1.isEmpty()) {
            CharSequence charSequence2 = sb;
            ((StringBuilder)charSequence2).setLength(((StringBuilder)charSequence2).length() - 1);
        }
        return ((StringBuilder)charSequence).toString();
    }

    private WebSocketExtensionUtil() {
    }
}

