/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WebSocketClientExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketClientExtensionHandshaker> extensionHandshakers;

    /*
     * WARNING - void declaration
     */
    public WebSocketClientExtensionHandler(WebSocketClientExtensionHandshaker ... extensionHandshakers) {
        void var1_1;
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty((Object[])var1_1, (String)"extensionHandshakers"));
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (msg instanceof HttpRequest && WebSocketExtensionUtil.isWebsocketUpgrade(((HttpRequest)msg).headers())) {
            HttpRequest request = (HttpRequest)msg;
            String headerValue = request.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
            for (WebSocketClientExtensionHandshaker extensionHandshaker : this.extensionHandshakers) {
                extraExtensions.add(extensionHandshaker.newRequestData());
            }
            String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
            request.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
        }
        super.write((ChannelHandlerContext)var1_1, (Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        HttpResponse response;
        if (msg instanceof HttpResponse && WebSocketExtensionUtil.isWebsocketUpgrade((response = (HttpResponse)msg).headers())) {
            String extensionsHeader = response.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (extensionsHeader != null) {
                List<WebSocketExtensionData> extensions = WebSocketExtensionUtil.extractExtensions(extensionsHeader);
                ArrayList<Object> validExtensions = new ArrayList<Object>(extensions.size());
                int rsv = 0;
                for (WebSocketExtensionData webSocketExtensionData : extensions) {
                    void var3_3;
                    Object validExtension;
                    Iterator<WebSocketClientExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                    for (validExtension = null; validExtension == null && extensionHandshakersIterator.hasNext(); validExtension = validExtension.handshakeExtension(webSocketExtensionData)) {
                        validExtension = extensionHandshakersIterator.next();
                    }
                    if (validExtension != null && (validExtension.rsv() & rsv) == 0) {
                        rsv |= validExtension.rsv();
                        validExtensions.add(validExtension);
                        continue;
                    }
                    throw new CodecException("invalid WebSocket Extension handshake for \"" + (String)var3_3 + '\"');
                }
                for (WebSocketClientExtension webSocketClientExtension : validExtensions) {
                    WebSocketExtensionDecoder decoder = webSocketClientExtension.newExtensionDecoder();
                    WebSocketExtensionEncoder encoder = webSocketClientExtension.newExtensionEncoder();
                    ctx.pipeline().addAfter(ctx.name(), ((Object)((Object)decoder)).getClass().getName(), (ChannelHandler)decoder);
                    ctx.pipeline().addAfter(ctx.name(), ((Object)((Object)encoder)).getClass().getName(), (ChannelHandler)encoder);
                }
            }
            ctx.pipeline().remove(ctx.name());
        }
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }
}

