/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class WebSocketUtil {
    private static final FastThreadLocal<MessageDigest> MD5 = new FastThreadLocal<MessageDigest>(){

        protected final MessageDigest initialValue() throws Exception {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("MD5 not supported on this platform - Outdated?");
            }
        }
    };
    private static final FastThreadLocal<MessageDigest> SHA1 = new FastThreadLocal<MessageDigest>(){

        protected final MessageDigest initialValue() throws Exception {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("SHA-1 not supported on this platform - Outdated?");
            }
        }
    };

    static byte[] md5(byte[] data) {
        byte[] byArray;
        return WebSocketUtil.digest(MD5, byArray);
    }

    static byte[] sha1(byte[] data) {
        byte[] byArray;
        return WebSocketUtil.digest(SHA1, byArray);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] digest(FastThreadLocal<MessageDigest> digestFastThreadLocal, byte[] data) {
        void var1_1;
        MessageDigest messageDigest;
        MessageDigest digest = (MessageDigest)digestFastThreadLocal.get();
        digest.reset();
        return messageDigest.digest((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Guarded with java version check")
    static String base64(byte[] data) {
        Object object;
        if (PlatformDependent.javaVersion() >= 8) {
            return java.util.Base64.getEncoder().encodeToString(data);
        }
        ByteBuf encodedData = Unpooled.wrappedBuffer((byte[])data);
        try {
            ByteBuf encoded = Base64.encode((ByteBuf)encodedData);
            try {
                Object encodedString = encoded.toString(CharsetUtil.UTF_8);
            }
            catch (Throwable encodedString) {
                void var2_4;
                var2_4.release();
                throw encodedString;
            }
            encoded.release();
        }
        catch (Throwable encodedString) {
            void var1_3;
            var1_3.release();
            throw encodedString;
        }
        encodedData.release();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] randomBytes(int size) {
        void var0_1;
        byte[] bytes = new byte[size];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    static int randomNumber(int minimum, int maximum) {
        int n;
        void var1_1;
        void var2_2;
        assert (minimum < maximum);
        double fraction = PlatformDependent.threadLocalRandom().nextDouble();
        return (int)((double)minimum + var2_2 * (double)(var1_1 - n));
    }

    /*
     * WARNING - void declaration
     */
    static int byteAtIndex(int mask, int index) {
        void var1_1;
        return mask >> 8 * (3 - var1_1) & 0xFF;
    }

    private WebSocketUtil() {
    }
}

