/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketServerProtocolConfig serverConfig;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;
    private boolean isWebSocketPath;

    /*
     * WARNING - void declaration
     */
    WebSocketServerProtocolHandshakeHandler(WebSocketServerProtocolConfig serverConfig) {
        void var1_1;
        this.serverConfig = (WebSocketServerProtocolConfig)ObjectUtil.checkNotNull((Object)var1_1, (String)"serverConfig");
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) {
        void var1_1;
        this.ctx = ctx;
        this.handshakePromise = var1_1.newPromise();
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx2, Object msg) throws Exception {
        block7: {
            void var2_3;
            block6: {
                HttpRequest req;
                block5: {
                    HttpObject httpObject = (HttpObject)msg;
                    if (!(httpObject instanceof HttpRequest)) break block6;
                    req = (HttpRequest)httpObject;
                    this.isWebSocketPath = this.isWebSocketPath(req);
                    if (!this.isWebSocketPath) {
                        ctx2.fireChannelRead(msg);
                        return;
                    }
                    try {
                        msg = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(ctx2.pipeline(), req, this.serverConfig.websocketPath()), this.serverConfig.subprotocols(), this.serverConfig.decoderConfig());
                        WebSocketServerHandshaker handshaker = ((WebSocketServerHandshakerFactory)msg).newHandshaker(req);
                        ChannelPromise localHandshakePromise = this.handshakePromise;
                        if (handshaker == null) {
                            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx2.channel());
                            break block5;
                        }
                        WebSocketServerProtocolHandler.setHandshaker(ctx2.channel(), handshaker);
                        ctx2.pipeline().remove((ChannelHandler)this);
                        ChannelFuture channelFuture = handshaker.handshake(ctx2.channel(), req);
                        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(this, localHandshakePromise, ctx2, req, (WebSocketServerHandshaker)var2_3){
                            final /* synthetic */ ChannelPromise val$localHandshakePromise;
                            final /* synthetic */ ChannelHandlerContext val$ctx;
                            final /* synthetic */ HttpRequest val$req;
                            final /* synthetic */ WebSocketServerHandshaker val$handshaker;
                            final /* synthetic */ WebSocketServerProtocolHandshakeHandler this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                                this.val$localHandshakePromise = channelPromise;
                                this.val$ctx = channelHandlerContext;
                                this.val$req = httpRequest;
                                this.val$handshaker = webSocketServerHandshaker;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void operationComplete(ChannelFuture future) {
                                if (!future.isSuccess()) {
                                    void var1_1;
                                    this.val$localHandshakePromise.tryFailure(future.cause());
                                    this.val$ctx.fireExceptionCaught(var1_1.cause());
                                    return;
                                }
                                this.val$localHandshakePromise.trySuccess();
                                this.val$ctx.fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE);
                                this.val$ctx.fireUserEventTriggered((Object)new WebSocketServerProtocolHandler.HandshakeComplete(this.val$req.uri(), this.val$req.headers(), this.val$handshaker.selectedSubprotocol()));
                            }
                        });
                        this.applyHandshakeTimeout();
                    }
                    catch (Throwable ctx2) {
                        void var3_4;
                        ReferenceCountUtil.release((Object)var3_4);
                        throw ctx2;
                    }
                }
                ReferenceCountUtil.release((Object)req);
                break block7;
            }
            if (!this.isWebSocketPath) {
                void var1_1;
                var1_1.fireChannelRead((Object)var2_3);
                return;
            }
            ReferenceCountUtil.release((Object)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isWebSocketPath(HttpRequest req) {
        void var2_2;
        void var1_1;
        String websocketPath = this.serverConfig.websocketPath();
        String uri = req.uri();
        if (this.serverConfig.checkStartsWith()) {
            return uri.startsWith(websocketPath) && ("/".equals(websocketPath) || this.checkNextUri(uri, websocketPath));
        }
        return var1_1.equals(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkNextUri(String uri, String websocketPath) {
        int len = websocketPath.length();
        if (uri.length() > len) {
            void var1_2;
            void var2_4;
            char nextUri = uri.charAt((int)var2_4);
            return nextUri == '/' || var1_2 == 63;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        void var2_2;
        void var1_1;
        ChannelHandlerContext f = ctx.writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)var1_1) || var2_2.status().code() != 200) {
            ChannelHandlerContext channelHandlerContext;
            channelHandlerContext.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getWebSocketLocation(ChannelPipeline cp, HttpRequest req, String path) {
        void var2_2;
        Object object;
        void var3_3;
        void var1_1;
        String protocol = "ws";
        if (cp.get(SslHandler.class) != null) {
            protocol = "wss";
        }
        Object host = var1_1.headers().get((CharSequence)HttpHeaderNames.HOST);
        return (String)var3_3 + "://" + (String)object + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void applyHandshakeTimeout() {
        void var2_3;
        void var1_1;
        ChannelPromise localHandshakePromise = this.handshakePromise;
        long handshakeTimeoutMillis = this.serverConfig.handshakeTimeoutMillis();
        if (handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        ScheduledFuture timeoutFuture = this.ctx.executor().schedule(new Runnable(this, localHandshakePromise){
            final /* synthetic */ ChannelPromise val$localHandshakePromise;
            final /* synthetic */ WebSocketServerProtocolHandshakeHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$localHandshakePromise = channelPromise;
            }

            @Override
            public void run() {
                if (!this.val$localHandshakePromise.isDone() && this.val$localHandshakePromise.tryFailure((Throwable)new WebSocketServerHandshakeException("handshake timed out"))) {
                    this.this$0.ctx.flush().fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT).close();
                }
            }
        }, handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        var1_1.addListener((GenericFutureListener)new FutureListener<Void>(this, (Future)var2_3){
            final /* synthetic */ Future val$timeoutFuture;
            final /* synthetic */ WebSocketServerProtocolHandshakeHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$timeoutFuture = future;
            }

            public void operationComplete(Future<Void> f) {
                this.val$timeoutFuture.cancel(false);
            }
        });
    }
}

