/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class WebSocketServerProtocolHandler
extends WebSocketProtocolHandler {
    private static final AttributeKey<WebSocketServerHandshaker> HANDSHAKER_ATTR_KEY = AttributeKey.valueOf(WebSocketServerHandshaker.class, (String)"HANDSHAKER");
    private final WebSocketServerProtocolConfig serverConfig;

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(WebSocketServerProtocolConfig serverConfig) {
        super(((WebSocketServerProtocolConfig)ObjectUtil.checkNotNull((Object)serverConfig, (String)"serverConfig")).dropPongFrames(), serverConfig.sendCloseFrame(), serverConfig.forceCloseTimeoutMillis());
        void var1_1;
        this.serverConfig = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath) {
        this((String)var1_1, 10000L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, long handshakeTimeoutMillis) {
        this((String)var1_1, false, (long)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, boolean checkStartsWith) {
        this((String)var1_1, (boolean)var2_2, 10000L);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, boolean checkStartsWith, long handshakeTimeoutMillis) {
        this((String)var1_1, null, false, 65536, false, (boolean)var2_2, (long)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols) {
        this((String)var1_1, (String)var2_2, 10000L);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, long handshakeTimeoutMillis) {
        this((String)var1_1, (String)var2_2, false, (long)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, long handshakeTimeoutMillis) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, 65536, handshakeTimeoutMillis);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, maxFrameSize, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize, long handshakeTimeoutMillis) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, maxFrameSize, false, handshakeTimeoutMillis);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize, boolean allowMaskMismatch) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, maxFrameSize, allowMaskMismatch, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize, boolean allowMaskMismatch, long handshakeTimeoutMillis) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, maxFrameSize, allowMaskMismatch, false, handshakeTimeoutMillis);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize, boolean allowMaskMismatch, boolean checkStartsWith) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, maxFrameSize, allowMaskMismatch, checkStartsWith, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize, boolean allowMaskMismatch, boolean checkStartsWith, long handshakeTimeoutMillis) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, maxFrameSize, allowMaskMismatch, checkStartsWith, true, handshakeTimeoutMillis);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize, boolean allowMaskMismatch, boolean checkStartsWith, boolean dropPongFrames) {
        this((String)var1_1, (String)var2_2, (boolean)var3_3, maxFrameSize, allowMaskMismatch, checkStartsWith, dropPongFrames, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize, boolean allowMaskMismatch, boolean checkStartsWith, boolean dropPongFrames, long handshakeTimeoutMillis) {
        this((String)var1_1, (String)var2_2, checkStartsWith, dropPongFrames, handshakeTimeoutMillis, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(maxFrameSize).allowMaskMismatch(allowMaskMismatch).allowExtensions((boolean)var3_3).build());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketServerProtocolHandler(String websocketPath, String subprotocols, boolean checkStartsWith, boolean dropPongFrames, long handshakeTimeoutMillis, WebSocketDecoderConfig decoderConfig) {
        this(WebSocketServerProtocolConfig.newBuilder().websocketPath((String)var1_1).subprotocols((String)var2_2).checkStartsWith((boolean)var3_3).handshakeTimeoutMillis(handshakeTimeoutMillis).dropPongFrames(dropPongFrames).decoderConfig(decoderConfig).build());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelPipeline cp = ctx.pipeline();
        if (cp.get(WebSocketServerProtocolHandshakeHandler.class) == null) {
            cp.addBefore(ctx.name(), WebSocketServerProtocolHandshakeHandler.class.getName(), (ChannelHandler)new WebSocketServerProtocolHandshakeHandler(this.serverConfig));
        }
        if (this.serverConfig.decoderConfig().withUTF8Validator() && cp.get(Utf8FrameValidator.class) == null) {
            void var1_1;
            void var2_2;
            var2_2.addBefore(var1_1.name(), Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator(this.serverConfig.decoderConfig().closeOnProtocolViolation()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        void var2_2;
        void var1_1;
        void var3_3;
        if (this.serverConfig.handleCloseFrames() && frame instanceof CloseWebSocketFrame) {
            WebSocketServerHandshaker handshaker = WebSocketServerProtocolHandler.getHandshaker(ctx.channel());
            if (handshaker != null) {
                frame.retain();
                ChannelPromise promise = ctx.newPromise();
                this.closeSent(promise);
                var3_3.close(ctx, (CloseWebSocketFrame)frame, promise);
                return;
            }
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        super.decode((ChannelHandlerContext)var1_1, (WebSocketFrame)var2_2, (List<Object>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected WebSocketServerHandshakeException buildHandshakeException(String message) {
        void var1_1;
        return new WebSocketServerHandshakeException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var1_1;
        void var2_2;
        if (cause instanceof WebSocketHandshakeException) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])cause.getMessage().getBytes()));
            ctx.channel().writeAndFlush((Object)var2_2).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.fireExceptionCaught((Throwable)var2_2);
        var1_1.close();
    }

    static WebSocketServerHandshaker getHandshaker(Channel channel) {
        return (WebSocketServerHandshaker)channel.attr(HANDSHAKER_ATTR_KEY).get();
    }

    /*
     * WARNING - void declaration
     */
    static void setHandshaker(Channel channel, WebSocketServerHandshaker handshaker) {
        void var1_1;
        channel.attr(HANDSHAKER_ATTR_KEY).set((Object)var1_1);
    }

    public static final class HandshakeComplete {
        private final String requestUri;
        private final HttpHeaders requestHeaders;
        private final String selectedSubprotocol;

        /*
         * WARNING - void declaration
         */
        public HandshakeComplete(String requestUri, HttpHeaders requestHeaders, String selectedSubprotocol) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.requestUri = var1_1;
            this.requestHeaders = var2_2;
            this.selectedSubprotocol = var3_3;
        }

        public final String requestUri() {
            return this.requestUri;
        }

        public final HttpHeaders requestHeaders() {
            return this.requestHeaders;
        }

        public final String selectedSubprotocol() {
            return this.selectedSubprotocol;
        }
    }

    public static enum ServerHandshakeStateEvent {
        HANDSHAKE_COMPLETE,
        HANDSHAKE_TIMEOUT;

    }
}

