/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.util.internal.ObjectUtil;

public final class WebSocketServerProtocolConfig {
    static final long DEFAULT_HANDSHAKE_TIMEOUT_MILLIS = 10000L;
    private final String websocketPath;
    private final String subprotocols;
    private final boolean checkStartsWith;
    private final long handshakeTimeoutMillis;
    private final long forceCloseTimeoutMillis;
    private final boolean handleCloseFrames;
    private final WebSocketCloseStatus sendCloseFrame;
    private final boolean dropPongFrames;
    private final WebSocketDecoderConfig decoderConfig;

    /*
     * WARNING - void declaration
     */
    private WebSocketServerProtocolConfig(String websocketPath, String subprotocols, boolean checkStartsWith, long handshakeTimeoutMillis, long forceCloseTimeoutMillis, boolean handleCloseFrames, WebSocketCloseStatus sendCloseFrame, boolean dropPongFrames, WebSocketDecoderConfig decoderConfig) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.websocketPath = var1_1;
        this.subprotocols = var2_2;
        this.checkStartsWith = var3_3;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive((long)handshakeTimeoutMillis, (String)"handshakeTimeoutMillis");
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
        this.handleCloseFrames = handleCloseFrames;
        this.sendCloseFrame = sendCloseFrame;
        this.dropPongFrames = dropPongFrames;
        this.decoderConfig = decoderConfig == null ? WebSocketDecoderConfig.DEFAULT : decoderConfig;
    }

    public final String websocketPath() {
        return this.websocketPath;
    }

    public final String subprotocols() {
        return this.subprotocols;
    }

    public final boolean checkStartsWith() {
        return this.checkStartsWith;
    }

    public final long handshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public final long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    public final boolean handleCloseFrames() {
        return this.handleCloseFrames;
    }

    public final WebSocketCloseStatus sendCloseFrame() {
        return this.sendCloseFrame;
    }

    public final boolean dropPongFrames() {
        return this.dropPongFrames;
    }

    public final WebSocketDecoderConfig decoderConfig() {
        return this.decoderConfig;
    }

    public final String toString() {
        return "WebSocketServerProtocolConfig {websocketPath=" + this.websocketPath + ", subprotocols=" + this.subprotocols + ", checkStartsWith=" + this.checkStartsWith + ", handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", forceCloseTimeoutMillis=" + this.forceCloseTimeoutMillis + ", handleCloseFrames=" + this.handleCloseFrames + ", sendCloseFrame=" + this.sendCloseFrame + ", dropPongFrames=" + this.dropPongFrames + ", decoderConfig=" + this.decoderConfig + "}";
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder("/", null, false, 10000L, 0L, true, WebSocketCloseStatus.NORMAL_CLOSURE, true, WebSocketDecoderConfig.DEFAULT);
    }

    public static final class Builder {
        private String websocketPath;
        private String subprotocols;
        private boolean checkStartsWith;
        private long handshakeTimeoutMillis;
        private long forceCloseTimeoutMillis;
        private boolean handleCloseFrames;
        private WebSocketCloseStatus sendCloseFrame;
        private boolean dropPongFrames;
        private WebSocketDecoderConfig decoderConfig;
        private WebSocketDecoderConfig.Builder decoderConfigBuilder;

        /*
         * WARNING - void declaration
         */
        private Builder(WebSocketServerProtocolConfig serverConfig) {
            this(((WebSocketServerProtocolConfig)ObjectUtil.checkNotNull((Object)serverConfig, (String)"serverConfig")).websocketPath(), serverConfig.subprotocols(), serverConfig.checkStartsWith(), serverConfig.handshakeTimeoutMillis(), serverConfig.forceCloseTimeoutMillis(), serverConfig.handleCloseFrames(), serverConfig.sendCloseFrame(), serverConfig.dropPongFrames(), var1_1.decoderConfig());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Builder(String websocketPath, String subprotocols, boolean checkStartsWith, long handshakeTimeoutMillis, long forceCloseTimeoutMillis, boolean handleCloseFrames, WebSocketCloseStatus sendCloseFrame, boolean dropPongFrames, WebSocketDecoderConfig decoderConfig) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.websocketPath = var1_1;
            this.subprotocols = var2_2;
            this.checkStartsWith = var3_3;
            this.handshakeTimeoutMillis = handshakeTimeoutMillis;
            this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
            this.handleCloseFrames = handleCloseFrames;
            this.sendCloseFrame = sendCloseFrame;
            this.dropPongFrames = dropPongFrames;
            this.decoderConfig = decoderConfig;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder websocketPath(String websocketPath) {
            void var1_1;
            this.websocketPath = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder subprotocols(String subprotocols) {
            void var1_1;
            this.subprotocols = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder checkStartsWith(boolean checkStartsWith) {
            void var1_1;
            this.checkStartsWith = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            void var1_1;
            this.handshakeTimeoutMillis = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder forceCloseTimeoutMillis(long forceCloseTimeoutMillis) {
            void var1_1;
            this.forceCloseTimeoutMillis = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder handleCloseFrames(boolean handleCloseFrames) {
            void var1_1;
            this.handleCloseFrames = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder sendCloseFrame(WebSocketCloseStatus sendCloseFrame) {
            void var1_1;
            this.sendCloseFrame = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder dropPongFrames(boolean dropPongFrames) {
            void var1_1;
            this.dropPongFrames = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder decoderConfig(WebSocketDecoderConfig decoderConfig) {
            void var1_1;
            this.decoderConfig = decoderConfig == null ? WebSocketDecoderConfig.DEFAULT : var1_1;
            this.decoderConfigBuilder = null;
            return this;
        }

        private WebSocketDecoderConfig.Builder decoderConfigBuilder() {
            if (this.decoderConfigBuilder == null) {
                this.decoderConfigBuilder = this.decoderConfig.toBuilder();
            }
            return this.decoderConfigBuilder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxFramePayloadLength(int maxFramePayloadLength) {
            void var1_1;
            this.decoderConfigBuilder().maxFramePayloadLength((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder expectMaskedFrames(boolean expectMaskedFrames) {
            void var1_1;
            this.decoderConfigBuilder().expectMaskedFrames((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder allowMaskMismatch(boolean allowMaskMismatch) {
            void var1_1;
            this.decoderConfigBuilder().allowMaskMismatch((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder allowExtensions(boolean allowExtensions) {
            void var1_1;
            this.decoderConfigBuilder().allowExtensions((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder closeOnProtocolViolation(boolean closeOnProtocolViolation) {
            void var1_1;
            this.decoderConfigBuilder().closeOnProtocolViolation((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withUTF8Validator(boolean withUTF8Validator) {
            void var1_1;
            this.decoderConfigBuilder().withUTF8Validator((boolean)var1_1);
            return this;
        }

        public final WebSocketServerProtocolConfig build() {
            return new WebSocketServerProtocolConfig(this.websocketPath, this.subprotocols, this.checkStartsWith, this.handshakeTimeoutMillis, this.forceCloseTimeoutMillis, this.handleCloseFrames, this.sendCloseFrame, this.dropPongFrames, this.decoderConfigBuilder == null ? this.decoderConfig : this.decoderConfigBuilder.build());
        }
    }
}

