/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class WebSocketServerHandshaker {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker.class);
    private final String uri;
    private final String[] subprotocols;
    private final WebSocketVersion version;
    private final WebSocketDecoderConfig decoderConfig;
    private String selectedSubprotocol;
    public static final String SUB_PROTOCOL_WILDCARD = "*";

    /*
     * WARNING - void declaration
     */
    protected WebSocketServerHandshaker(WebSocketVersion version, String uri, String subprotocols, int maxFramePayloadLength) {
        this((WebSocketVersion)var1_1, (String)var2_2, (String)var3_3, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(maxFramePayloadLength).build());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected WebSocketServerHandshaker(WebSocketVersion version, String uri, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        this.version = version;
        this.uri = uri;
        if (subprotocols != null) {
            void var1_1;
            void var3_4;
            String[] subprotocolArray = var3_4.split(",");
            for (int i = 0; i < subprotocolArray.length; ++i) {
                subprotocolArray[i] = subprotocolArray[i].trim();
            }
            this.subprotocols = var1_1;
        } else {
            this.subprotocols = EmptyArrays.EMPTY_STRINGS;
        }
        this.decoderConfig = (WebSocketDecoderConfig)ObjectUtil.checkNotNull((Object)decoderConfig, (String)"decoderConfig");
    }

    public String uri() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> subprotocols() {
        void var1_1;
        LinkedHashSet ret = new LinkedHashSet();
        Collections.addAll(ret, this.subprotocols);
        return var1_1;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.decoderConfig.maxFramePayloadLength();
    }

    public WebSocketDecoderConfig decoderConfig() {
        return this.decoderConfig;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture handshake(Channel channel, FullHttpRequest req) {
        void var1_1;
        void var2_2;
        return this.handshake(channel, (FullHttpRequest)var2_2, null, var1_1.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture handshake(Channel channel, FullHttpRequest req, HttpHeaders responseHeaders, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        String encoderName;
        ChannelHandlerContext ctx;
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        FullHttpResponse response = this.newHandshakeResponse(req, responseHeaders);
        ChannelPipeline p = channel.pipeline();
        if (p.get(HttpObjectAggregator.class) != null) {
            p.remove(HttpObjectAggregator.class);
        }
        if (p.get(HttpContentCompressor.class) != null) {
            p.remove(HttpContentCompressor.class);
        }
        if ((ctx = p.context(HttpRequestDecoder.class)) == null) {
            ctx = p.context(HttpServerCodec.class);
            if (ctx == null) {
                promise.setFailure((Throwable)new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
                response.release();
                return promise;
            }
            p.addBefore(ctx.name(), "wsencoder", (ChannelHandler)this.newWebSocketEncoder());
            p.addBefore(ctx.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            encoderName = ctx.name();
        } else {
            void var3_3;
            p.replace(encoderName.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            encoderName = p.context(HttpResponseEncoder.class).name();
            var3_3.addBefore(encoderName, "wsencoder", (ChannelHandler)this.newWebSocketEncoder());
        }
        var1_1.writeAndFlush((Object)var2_2).addListener((GenericFutureListener)new ChannelFutureListener(this, encoderName, promise){
            final /* synthetic */ String val$encoderName;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ WebSocketServerHandshaker this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$encoderName = string;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                void var1_1;
                if (future.isSuccess()) {
                    future = future.channel().pipeline();
                    future.remove(this.val$encoderName);
                    this.val$promise.setSuccess();
                    return;
                }
                this.val$promise.setFailure(var1_1.cause());
            }
        });
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        void var1_1;
        void var2_2;
        return this.handshake(channel, (HttpRequest)var2_2, null, var1_1.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture handshake(Channel channel, HttpRequest req, HttpHeaders responseHeaders, ChannelPromise promise) {
        void var3_4;
        ChannelPipeline p;
        ChannelHandlerContext ctx;
        if (req instanceof FullHttpRequest) {
            return this.handshake(channel, (FullHttpRequest)req, responseHeaders, promise);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        if ((ctx = (p = channel.pipeline()).context(HttpRequestDecoder.class)) == null && (ctx = p.context(HttpServerCodec.class)) == null) {
            promise.setFailure((Throwable)new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
            return promise;
        }
        String aggregatorCtx = ctx.name();
        if (HttpUtil.isContentLengthSet(req) || HttpUtil.isTransferEncodingChunked(req) || this.version == WebSocketVersion.V00) {
            aggregatorCtx = "httpAggregator";
            p.addAfter(ctx.name(), aggregatorCtx, (ChannelHandler)new HttpObjectAggregator(8192));
        }
        p.addAfter(aggregatorCtx, "handshaker", (ChannelHandler)new ChannelInboundHandlerAdapter(this, promise, channel, (HttpHeaders)var3_4){
            private FullHttpRequest fullHttpRequest;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ HttpHeaders val$responseHeaders;
            final /* synthetic */ WebSocketServerHandshaker this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = channelPromise;
                this.val$channel = channel;
                this.val$responseHeaders = httpHeaders;
            }

            /*
             * WARNING - void declaration
             */
            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof HttpObject) {
                    try {
                        this.handleHandshakeRequest(ctx, (HttpObject)msg);
                    }
                    finally {
                        ReferenceCountUtil.release((Object)msg);
                    }
                } else {
                    void var2_3;
                    void var1_1;
                    super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_3);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                void var2_2;
                void var1_1;
                ctx.pipeline().remove((ChannelHandler)this);
                this.val$promise.tryFailure(cause);
                var1_1.fireExceptionCaught((Throwable)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                try {
                    void var1_1;
                    if (!this.val$promise.isDone()) {
                        this.val$promise.tryFailure((Throwable)new ClosedChannelException());
                    }
                    var1_1.fireChannelInactive();
                    return;
                }
                finally {
                    this.releaseFullHttpRequest();
                }
            }

            public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                this.releaseFullHttpRequest();
            }

            /*
             * WARNING - void declaration
             */
            private void handleHandshakeRequest(ChannelHandlerContext ctx, HttpObject httpObject) {
                FullHttpRequest handshakeRequest;
                if (httpObject instanceof FullHttpRequest) {
                    ctx.pipeline().remove((ChannelHandler)this);
                    this.this$0.handshake(this.val$channel, (FullHttpRequest)httpObject, this.val$responseHeaders, this.val$promise);
                    return;
                }
                if (httpObject instanceof LastHttpContent) {
                    assert (this.fullHttpRequest != null);
                    handshakeRequest = this.fullHttpRequest;
                    this.fullHttpRequest = null;
                    try {
                        void var1_1;
                        var1_1.pipeline().remove((ChannelHandler)this);
                        this.this$0.handshake(this.val$channel, handshakeRequest, this.val$responseHeaders, this.val$promise);
                        return;
                    }
                    finally {
                        handshakeRequest.release();
                    }
                }
                if (handshakeRequest instanceof HttpRequest) {
                    HttpRequest httpRequest = handshakeRequest;
                    this.fullHttpRequest = new DefaultFullHttpRequest(httpRequest.protocolVersion(), httpRequest.method(), httpRequest.uri(), Unpooled.EMPTY_BUFFER, httpRequest.headers(), EmptyHttpHeaders.INSTANCE);
                    if (httpRequest.decoderResult().isFailure()) {
                        void var2_3;
                        this.fullHttpRequest.setDecoderResult(var2_3.decoderResult());
                    }
                }
            }

            private void releaseFullHttpRequest() {
                if (this.fullHttpRequest != null) {
                    this.fullHttpRequest.release();
                    this.fullHttpRequest = null;
                }
            }
        });
        try {
            void var2_3;
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)var2_3));
        }
        catch (Throwable cause) {
            void var1_2;
            promise.setFailure((Throwable)var1_2);
        }
        return promise;
    }

    protected abstract FullHttpResponse newHandshakeResponse(FullHttpRequest var1, HttpHeaders var2);

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        return this.close(channel, (CloseWebSocketFrame)var2_2, var1_1.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.close0((ChannelOutboundInvoker)var1_1, (CloseWebSocketFrame)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)ctx, (String)"ctx");
        return this.close(ctx, (CloseWebSocketFrame)var2_2, var1_1.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(ChannelHandlerContext ctx, CloseWebSocketFrame frame, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)ctx, (String)"ctx");
        return this.close0((ChannelOutboundInvoker)var1_1, (CloseWebSocketFrame)var2_2, (ChannelPromise)var3_3).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture close0(ChannelOutboundInvoker invoker, CloseWebSocketFrame frame, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        return invoker.writeAndFlush((Object)var2_2, (ChannelPromise)var3_3).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected String selectSubprotocol(String requestedSubprotocols) {
        String[] stringArray;
        if (requestedSubprotocols == null || this.subprotocols.length == 0) {
            return null;
        }
        String[] stringArray2 = stringArray.split(",");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String requestedSubprotocol = string.trim();
            String[] stringArray3 = this.subprotocols;
            int n2 = this.subprotocols.length;
            for (int j = 0; j < n2; ++j) {
                String supportedSubprotocol = stringArray3[j];
                if (!SUB_PROTOCOL_WILDCARD.equals(supportedSubprotocol) && !requestedSubprotocol.equals(supportedSubprotocol)) continue;
                this.selectedSubprotocol = requestedSubprotocol;
                return requestedSubprotocol;
            }
        }
        return null;
    }

    public String selectedSubprotocol() {
        return this.selectedSubprotocol;
    }

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();
}

