/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame>
implements ChannelOutboundHandler {
    private final boolean dropPongFrames;
    private final WebSocketCloseStatus closeStatus;
    private final long forceCloseTimeoutMillis;
    private ChannelPromise closeSent;

    WebSocketProtocolHandler() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    WebSocketProtocolHandler(boolean dropPongFrames) {
        this((boolean)var1_1, null, 0L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    WebSocketProtocolHandler(boolean dropPongFrames, WebSocketCloseStatus closeStatus, long forceCloseTimeoutMillis) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.dropPongFrames = var1_1;
        this.closeStatus = var2_2;
        this.forceCloseTimeoutMillis = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        void var2_2;
        void var3_3;
        if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
            WebSocketProtocolHandler.readIfNeeded(ctx);
            return;
        }
        if (frame instanceof PongWebSocketFrame && this.dropPongFrames) {
            void var1_1;
            WebSocketProtocolHandler.readIfNeeded((ChannelHandlerContext)var1_1);
            return;
        }
        var3_3.add(var2_2.retain());
    }

    private static void readIfNeeded(ChannelHandlerContext ctx) {
        if (!ctx.channel().config().isAutoRead()) {
            ChannelHandlerContext channelHandlerContext;
            channelHandlerContext.read();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        if (this.closeStatus == null || !ctx.channel().isActive()) {
            ctx.close(promise);
            return;
        }
        if (this.closeSent == null) {
            this.write(ctx, (Object)new CloseWebSocketFrame(this.closeStatus), ctx.newPromise());
        }
        this.flush(ctx);
        this.applyCloseSentTimeout(ctx);
        this.closeSent.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var1_1, (ChannelPromise)var2_2){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ WebSocketProtocolHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
                this.val$promise = channelPromise;
            }

            public void operationComplete(ChannelFuture future) {
                this.val$ctx.close(this.val$promise);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.closeSent != null) {
            ReferenceCountUtil.release((Object)msg);
            promise.setFailure((Throwable)new ClosedChannelException());
            return;
        }
        if (msg instanceof CloseWebSocketFrame) {
            this.closeSent(promise.unvoid());
            ctx.write(msg).addListener((GenericFutureListener)new PromiseNotifier(false, new Promise[]{this.closeSent}));
            return;
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    void closeSent(ChannelPromise promise) {
        void var1_1;
        this.closeSent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void applyCloseSentTimeout(ChannelHandlerContext ctx) {
        void var1_1;
        if (this.closeSent.isDone() || this.forceCloseTimeoutMillis < 0L) {
            return;
        }
        ScheduledFuture timeoutTask = ctx.executor().schedule(new Runnable(this){
            final /* synthetic */ WebSocketProtocolHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                if (!this.this$0.closeSent.isDone()) {
                    this.this$0.closeSent.tryFailure((Throwable)this.this$0.buildHandshakeException("send close frame timed out"));
                }
            }
        }, this.forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
        this.closeSent.addListener((GenericFutureListener)new ChannelFutureListener(this, (Future)var1_1){
            final /* synthetic */ Future val$timeoutTask;
            final /* synthetic */ WebSocketProtocolHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$timeoutTask = future;
            }

            public void operationComplete(ChannelFuture future) {
                this.val$timeoutTask.cancel(false);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected WebSocketHandshakeException buildHandshakeException(String message) {
        void var1_1;
        return new WebSocketHandshakeException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.deregister((ChannelPromise)var2_2);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var1_1;
        void var2_2;
        ctx.fireExceptionCaught((Throwable)var2_2);
        var1_1.close();
    }
}

