/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

public class WebSocketFrameAggregator
extends MessageAggregator<WebSocketFrame, WebSocketFrame, ContinuationWebSocketFrame, WebSocketFrame> {
    /*
     * WARNING - void declaration
     */
    public WebSocketFrameAggregator(int maxContentLength) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isStartMessage(WebSocketFrame msg) throws Exception {
        void var1_1;
        return msg instanceof TextWebSocketFrame || var1_1 instanceof BinaryWebSocketFrame;
    }

    protected boolean isContentMessage(WebSocketFrame msg) throws Exception {
        return msg instanceof ContinuationWebSocketFrame;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isLastContentMessage(ContinuationWebSocketFrame msg) throws Exception {
        void var1_1;
        return this.isContentMessage(msg) && var1_1.isFinalFragment();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAggregated(WebSocketFrame msg) throws Exception {
        void var1_1;
        if (msg.isFinalFragment()) {
            return !this.isContentMessage(msg);
        }
        return !this.isStartMessage(msg) && !this.isContentMessage((WebSocketFrame)var1_1);
    }

    protected boolean isContentLengthInvalid(WebSocketFrame start, int maxContentLength) {
        return false;
    }

    protected Object newContinueResponse(WebSocketFrame start, int maxContentLength, ChannelPipeline pipeline) {
        return null;
    }

    protected boolean closeAfterContinueResponse(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected boolean ignoreContentAfterContinueResponse(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    protected WebSocketFrame beginAggregation(WebSocketFrame start, ByteBuf content) throws Exception {
        if (start instanceof TextWebSocketFrame) {
            return new TextWebSocketFrame(true, start.rsv(), content);
        }
        if (start instanceof BinaryWebSocketFrame) {
            void var2_2;
            void var1_1;
            return new BinaryWebSocketFrame(true, var1_1.rsv(), (ByteBuf)var2_2);
        }
        throw new Error();
    }
}

