/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.util.internal.ObjectUtil;

public final class WebSocketDecoderConfig {
    static final WebSocketDecoderConfig DEFAULT = new WebSocketDecoderConfig(65536, true, false, false, true, true);
    private final int maxFramePayloadLength;
    private final boolean expectMaskedFrames;
    private final boolean allowMaskMismatch;
    private final boolean allowExtensions;
    private final boolean closeOnProtocolViolation;
    private final boolean withUTF8Validator;

    /*
     * WARNING - void declaration
     */
    private WebSocketDecoderConfig(int maxFramePayloadLength, boolean expectMaskedFrames, boolean allowMaskMismatch, boolean allowExtensions, boolean closeOnProtocolViolation, boolean withUTF8Validator) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.maxFramePayloadLength = var1_1;
        this.expectMaskedFrames = var2_2;
        this.allowMaskMismatch = var3_3;
        this.allowExtensions = allowExtensions;
        this.closeOnProtocolViolation = closeOnProtocolViolation;
        this.withUTF8Validator = withUTF8Validator;
    }

    public final int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public final boolean expectMaskedFrames() {
        return this.expectMaskedFrames;
    }

    public final boolean allowMaskMismatch() {
        return this.allowMaskMismatch;
    }

    public final boolean allowExtensions() {
        return this.allowExtensions;
    }

    public final boolean closeOnProtocolViolation() {
        return this.closeOnProtocolViolation;
    }

    public final boolean withUTF8Validator() {
        return this.withUTF8Validator;
    }

    public final String toString() {
        return "WebSocketDecoderConfig [maxFramePayloadLength=" + this.maxFramePayloadLength + ", expectMaskedFrames=" + this.expectMaskedFrames + ", allowMaskMismatch=" + this.allowMaskMismatch + ", allowExtensions=" + this.allowExtensions + ", closeOnProtocolViolation=" + this.closeOnProtocolViolation + ", withUTF8Validator=" + this.withUTF8Validator + "]";
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder(DEFAULT);
    }

    public static final class Builder {
        private int maxFramePayloadLength;
        private boolean expectMaskedFrames;
        private boolean allowMaskMismatch;
        private boolean allowExtensions;
        private boolean closeOnProtocolViolation;
        private boolean withUTF8Validator;

        /*
         * WARNING - void declaration
         */
        private Builder(WebSocketDecoderConfig decoderConfig) {
            void var1_1;
            ObjectUtil.checkNotNull((Object)decoderConfig, (String)"decoderConfig");
            this.maxFramePayloadLength = decoderConfig.maxFramePayloadLength();
            this.expectMaskedFrames = decoderConfig.expectMaskedFrames();
            this.allowMaskMismatch = decoderConfig.allowMaskMismatch();
            this.allowExtensions = decoderConfig.allowExtensions();
            this.closeOnProtocolViolation = decoderConfig.closeOnProtocolViolation();
            this.withUTF8Validator = var1_1.withUTF8Validator();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxFramePayloadLength(int maxFramePayloadLength) {
            void var1_1;
            this.maxFramePayloadLength = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder expectMaskedFrames(boolean expectMaskedFrames) {
            void var1_1;
            this.expectMaskedFrames = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder allowMaskMismatch(boolean allowMaskMismatch) {
            void var1_1;
            this.allowMaskMismatch = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder allowExtensions(boolean allowExtensions) {
            void var1_1;
            this.allowExtensions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder closeOnProtocolViolation(boolean closeOnProtocolViolation) {
            void var1_1;
            this.closeOnProtocolViolation = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withUTF8Validator(boolean withUTF8Validator) {
            void var1_1;
            this.withUTF8Validator = var1_1;
            return this;
        }

        public final WebSocketDecoderConfig build() {
            return new WebSocketDecoderConfig(this.maxFramePayloadLength, this.expectMaskedFrames, this.allowMaskMismatch, this.allowExtensions, this.closeOnProtocolViolation, this.withUTF8Validator);
        }
    }
}

