/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

class WebSocketClientProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final long DEFAULT_HANDSHAKE_TIMEOUT_MS = 10000L;
    private final WebSocketClientHandshaker handshaker;
    private final long handshakeTimeoutMillis;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;

    /*
     * WARNING - void declaration
     */
    WebSocketClientProtocolHandshakeHandler(WebSocketClientHandshaker handshaker) {
        this((WebSocketClientHandshaker)var1_1, 10000L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    WebSocketClientProtocolHandshakeHandler(WebSocketClientHandshaker handshaker, long handshakeTimeoutMillis) {
        void var2_2;
        void var1_1;
        this.handshaker = var1_1;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive((long)var2_2, (String)"handshakeTimeoutMillis");
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = ctx;
        this.handshakePromise = var1_1.newPromise();
    }

    /*
     * WARNING - void declaration
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        super.channelActive(ctx);
        this.handshaker.handshake(ctx.channel()).addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var1_1){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ WebSocketClientProtocolHandshakeHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    void var1_1;
                    this.this$0.handshakePromise.tryFailure(future.cause());
                    this.val$ctx.fireExceptionCaught(var1_1.cause());
                    return;
                }
                this.val$ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_ISSUED);
            }
        });
        this.applyHandshakeTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (!this.handshakePromise.isDone()) {
            this.handshakePromise.tryFailure((Throwable)new WebSocketClientHandshakeException("channel closed with handshake in progress"));
        }
        super.channelInactive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block4: {
            if (!(msg instanceof FullHttpResponse)) {
                ctx.fireChannelRead(msg);
                return;
            }
            FullHttpResponse response = (FullHttpResponse)msg;
            try {
                void var1_1;
                if (this.handshaker.isHandshakeComplete()) break block4;
                this.handshaker.finishHandshake(ctx.channel(), response);
                this.handshakePromise.trySuccess();
                ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE);
                var1_1.pipeline().remove((ChannelHandler)this);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.release();
                throw throwable;
            }
            response.release();
            return;
        }
        throw new IllegalStateException("WebSocketClientHandshaker should have been non finished yet");
    }

    /*
     * WARNING - void declaration
     */
    private void applyHandshakeTimeout() {
        void var2_2;
        void var1_1;
        ChannelPromise localHandshakePromise = this.handshakePromise;
        if (this.handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        ScheduledFuture timeoutFuture = this.ctx.executor().schedule(new Runnable(this, localHandshakePromise){
            final /* synthetic */ ChannelPromise val$localHandshakePromise;
            final /* synthetic */ WebSocketClientProtocolHandshakeHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$localHandshakePromise = channelPromise;
            }

            @Override
            public void run() {
                if (this.val$localHandshakePromise.isDone()) {
                    return;
                }
                if (this.val$localHandshakePromise.tryFailure((Throwable)new WebSocketClientHandshakeException("handshake timed out"))) {
                    this.this$0.ctx.flush().fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT).close();
                }
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        var1_1.addListener((GenericFutureListener)new FutureListener<Void>(this, (Future)var2_2){
            final /* synthetic */ Future val$timeoutFuture;
            final /* synthetic */ WebSocketClientProtocolHandshakeHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$timeoutFuture = future;
            }

            public void operationComplete(Future<Void> f) throws Exception {
                this.val$timeoutFuture.cancel(false);
            }
        });
    }

    ChannelFuture getHandshakeFuture() {
        return this.handshakePromise;
    }
}

