/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.internal.ObjectUtil;
import java.net.URI;
import java.util.List;

public class WebSocketClientProtocolHandler
extends WebSocketProtocolHandler {
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketClientProtocolConfig clientConfig;

    public WebSocketClientHandshaker handshaker() {
        return this.handshaker;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientProtocolConfig clientConfig) {
        super(((WebSocketClientProtocolConfig)ObjectUtil.checkNotNull((Object)clientConfig, (String)"clientConfig")).dropPongFrames(), clientConfig.sendCloseFrame(), clientConfig.forceCloseTimeoutMillis());
        void var1_1;
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(clientConfig.webSocketUri(), clientConfig.version(), clientConfig.subprotocol(), clientConfig.allowExtensions(), clientConfig.customHeaders(), clientConfig.maxFramePayloadLength(), clientConfig.performMasking(), clientConfig.allowMaskMismatch(), clientConfig.forceCloseTimeoutMillis(), clientConfig.absoluteUpgradeUrl(), clientConfig.generateOriginHeader());
        this.clientConfig = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, WebSocketClientProtocolConfig clientConfig) {
        super(((WebSocketClientProtocolConfig)ObjectUtil.checkNotNull((Object)clientConfig, (String)"clientConfig")).dropPongFrames(), clientConfig.sendCloseFrame(), clientConfig.forceCloseTimeoutMillis());
        void var2_2;
        void var1_1;
        this.handshaker = var1_1;
        this.clientConfig = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames, boolean performMasking, boolean allowMaskMismatch) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, allowExtensions, customHeaders, maxFramePayloadLength, handleCloseFrames, performMasking, allowMaskMismatch, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames, boolean performMasking, boolean allowMaskMismatch, long handshakeTimeoutMillis) {
        this(WebSocketClientHandshakerFactory.newHandshaker((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch), handleCloseFrames, handshakeTimeoutMillis);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, allowExtensions, customHeaders, maxFramePayloadLength, handleCloseFrames, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean handleCloseFrames, long handshakeTimeoutMillis) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, allowExtensions, customHeaders, maxFramePayloadLength, handleCloseFrames, true, false, handshakeTimeoutMillis);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, allowExtensions, customHeaders, maxFramePayloadLength, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, long handshakeTimeoutMillis) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, allowExtensions, customHeaders, maxFramePayloadLength, true, handshakeTimeoutMillis);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames) {
        this((WebSocketClientHandshaker)var1_1, (boolean)var2_2, 10000L);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames, long handshakeTimeoutMillis) {
        this((WebSocketClientHandshaker)var1_1, (boolean)var2_2, true, (long)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames, boolean dropPongFrames) {
        this((WebSocketClientHandshaker)var1_1, (boolean)var2_2, (boolean)var3_3, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames, boolean dropPongFrames, long handshakeTimeoutMillis) {
        this((WebSocketClientHandshaker)var1_1, (boolean)var2_2, (boolean)var3_3, handshakeTimeoutMillis, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, boolean handleCloseFrames, boolean dropPongFrames, long handshakeTimeoutMillis, boolean withUTF8Validator) {
        super((boolean)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.handshaker = var1_1;
        this.clientConfig = WebSocketClientProtocolConfig.newBuilder().handleCloseFrames((boolean)var2_2).handshakeTimeoutMillis(handshakeTimeoutMillis).withUTF8Validator(withUTF8Validator).build();
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker) {
        this((WebSocketClientHandshaker)var1_1, 10000L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientProtocolHandler(WebSocketClientHandshaker handshaker, long handshakeTimeoutMillis) {
        this((WebSocketClientHandshaker)var1_1, true, (long)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.clientConfig.handleCloseFrames() && frame instanceof CloseWebSocketFrame) {
            ctx.close();
            return;
        }
        super.decode((ChannelHandlerContext)var1_1, (WebSocketFrame)var2_2, (List<Object>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected WebSocketClientHandshakeException buildHandshakeException(String message) {
        void var1_1;
        return new WebSocketClientHandshakeException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) {
        void var2_2;
        ChannelPipeline cp = ctx.pipeline();
        if (cp.get(WebSocketClientProtocolHandshakeHandler.class) == null) {
            ctx.pipeline().addBefore(ctx.name(), WebSocketClientProtocolHandshakeHandler.class.getName(), (ChannelHandler)new WebSocketClientProtocolHandshakeHandler(this.handshaker, this.clientConfig.handshakeTimeoutMillis()));
        }
        if (this.clientConfig.withUTF8Validator() && var2_2.get(Utf8FrameValidator.class) == null) {
            void var1_1;
            ctx.pipeline().addBefore(var1_1.name(), Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator());
        }
    }

    public static enum ClientHandshakeStateEvent {
        HANDSHAKE_TIMEOUT,
        HANDSHAKE_ISSUED,
        HANDSHAKE_COMPLETE;

    }
}

