/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.internal.ObjectUtil;
import java.net.URI;

public final class WebSocketClientProtocolConfig {
    static final boolean DEFAULT_PERFORM_MASKING = true;
    static final boolean DEFAULT_ALLOW_MASK_MISMATCH = false;
    static final boolean DEFAULT_HANDLE_CLOSE_FRAMES = true;
    static final boolean DEFAULT_DROP_PONG_FRAMES = true;
    static final boolean DEFAULT_GENERATE_ORIGIN_HEADER = true;
    static final boolean DEFAULT_WITH_UTF8_VALIDATOR = true;
    private final URI webSocketUri;
    private final String subprotocol;
    private final WebSocketVersion version;
    private final boolean allowExtensions;
    private final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;
    private final boolean handleCloseFrames;
    private final WebSocketCloseStatus sendCloseFrame;
    private final boolean dropPongFrames;
    private final long handshakeTimeoutMillis;
    private final long forceCloseTimeoutMillis;
    private final boolean absoluteUpgradeUrl;
    private final boolean generateOriginHeader;
    private final boolean withUTF8Validator;

    /*
     * WARNING - void declaration
     */
    private WebSocketClientProtocolConfig(URI webSocketUri, String subprotocol, WebSocketVersion version, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, boolean handleCloseFrames, WebSocketCloseStatus sendCloseFrame, boolean dropPongFrames, long handshakeTimeoutMillis, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl, boolean generateOriginHeader, boolean withUTF8Validator) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.webSocketUri = var1_1;
        this.subprotocol = var2_2;
        this.version = var3_3;
        this.allowExtensions = allowExtensions;
        this.customHeaders = customHeaders;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.performMasking = performMasking;
        this.allowMaskMismatch = allowMaskMismatch;
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
        this.handleCloseFrames = handleCloseFrames;
        this.sendCloseFrame = sendCloseFrame;
        this.dropPongFrames = dropPongFrames;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive((long)handshakeTimeoutMillis, (String)"handshakeTimeoutMillis");
        this.absoluteUpgradeUrl = absoluteUpgradeUrl;
        this.generateOriginHeader = generateOriginHeader;
        this.withUTF8Validator = withUTF8Validator;
    }

    public final URI webSocketUri() {
        return this.webSocketUri;
    }

    public final String subprotocol() {
        return this.subprotocol;
    }

    public final WebSocketVersion version() {
        return this.version;
    }

    public final boolean allowExtensions() {
        return this.allowExtensions;
    }

    public final HttpHeaders customHeaders() {
        return this.customHeaders;
    }

    public final int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public final boolean performMasking() {
        return this.performMasking;
    }

    public final boolean allowMaskMismatch() {
        return this.allowMaskMismatch;
    }

    public final boolean handleCloseFrames() {
        return this.handleCloseFrames;
    }

    public final WebSocketCloseStatus sendCloseFrame() {
        return this.sendCloseFrame;
    }

    public final boolean dropPongFrames() {
        return this.dropPongFrames;
    }

    public final long handshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public final long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    public final boolean absoluteUpgradeUrl() {
        return this.absoluteUpgradeUrl;
    }

    public final boolean generateOriginHeader() {
        return this.generateOriginHeader;
    }

    public final boolean withUTF8Validator() {
        return this.withUTF8Validator;
    }

    public final String toString() {
        return "WebSocketClientProtocolConfig {webSocketUri=" + this.webSocketUri + ", subprotocol=" + this.subprotocol + ", version=" + (Object)((Object)this.version) + ", allowExtensions=" + this.allowExtensions + ", customHeaders=" + this.customHeaders + ", maxFramePayloadLength=" + this.maxFramePayloadLength + ", performMasking=" + this.performMasking + ", allowMaskMismatch=" + this.allowMaskMismatch + ", handleCloseFrames=" + this.handleCloseFrames + ", sendCloseFrame=" + this.sendCloseFrame + ", dropPongFrames=" + this.dropPongFrames + ", handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", forceCloseTimeoutMillis=" + this.forceCloseTimeoutMillis + ", absoluteUpgradeUrl=" + this.absoluteUpgradeUrl + ", generateOriginHeader=" + this.generateOriginHeader + "}";
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder(URI.create("https://localhost/"), null, WebSocketVersion.V13, false, EmptyHttpHeaders.INSTANCE, 65536, true, false, true, WebSocketCloseStatus.NORMAL_CLOSURE, true, 10000L, -1L, false, true, true);
    }

    public static final class Builder {
        private URI webSocketUri;
        private String subprotocol;
        private WebSocketVersion version;
        private boolean allowExtensions;
        private HttpHeaders customHeaders;
        private int maxFramePayloadLength;
        private boolean performMasking;
        private boolean allowMaskMismatch;
        private boolean handleCloseFrames;
        private WebSocketCloseStatus sendCloseFrame;
        private boolean dropPongFrames;
        private long handshakeTimeoutMillis;
        private long forceCloseTimeoutMillis;
        private boolean absoluteUpgradeUrl;
        private boolean generateOriginHeader;
        private boolean withUTF8Validator;

        /*
         * WARNING - void declaration
         */
        private Builder(WebSocketClientProtocolConfig clientConfig) {
            this(((WebSocketClientProtocolConfig)ObjectUtil.checkNotNull((Object)clientConfig, (String)"clientConfig")).webSocketUri(), clientConfig.subprotocol(), clientConfig.version(), clientConfig.allowExtensions(), clientConfig.customHeaders(), clientConfig.maxFramePayloadLength(), clientConfig.performMasking(), clientConfig.allowMaskMismatch(), clientConfig.handleCloseFrames(), clientConfig.sendCloseFrame(), clientConfig.dropPongFrames(), clientConfig.handshakeTimeoutMillis(), clientConfig.forceCloseTimeoutMillis(), clientConfig.absoluteUpgradeUrl(), clientConfig.generateOriginHeader(), var1_1.withUTF8Validator());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Builder(URI webSocketUri, String subprotocol, WebSocketVersion version, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, boolean handleCloseFrames, WebSocketCloseStatus sendCloseFrame, boolean dropPongFrames, long handshakeTimeoutMillis, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl, boolean generateOriginHeader, boolean withUTF8Validator) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.webSocketUri = var1_1;
            this.subprotocol = var2_2;
            this.version = var3_3;
            this.allowExtensions = allowExtensions;
            this.customHeaders = customHeaders;
            this.maxFramePayloadLength = maxFramePayloadLength;
            this.performMasking = performMasking;
            this.allowMaskMismatch = allowMaskMismatch;
            this.handleCloseFrames = handleCloseFrames;
            this.sendCloseFrame = sendCloseFrame;
            this.dropPongFrames = dropPongFrames;
            this.handshakeTimeoutMillis = handshakeTimeoutMillis;
            this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
            this.absoluteUpgradeUrl = absoluteUpgradeUrl;
            this.generateOriginHeader = generateOriginHeader;
            this.withUTF8Validator = withUTF8Validator;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder webSocketUri(String webSocketUri) {
            void var1_1;
            return this.webSocketUri(URI.create((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder webSocketUri(URI webSocketUri) {
            void var1_1;
            this.webSocketUri = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder subprotocol(String subprotocol) {
            void var1_1;
            this.subprotocol = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder version(WebSocketVersion version) {
            void var1_1;
            this.version = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder allowExtensions(boolean allowExtensions) {
            void var1_1;
            this.allowExtensions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder customHeaders(HttpHeaders customHeaders) {
            void var1_1;
            this.customHeaders = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxFramePayloadLength(int maxFramePayloadLength) {
            void var1_1;
            this.maxFramePayloadLength = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder performMasking(boolean performMasking) {
            void var1_1;
            this.performMasking = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder allowMaskMismatch(boolean allowMaskMismatch) {
            void var1_1;
            this.allowMaskMismatch = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder handleCloseFrames(boolean handleCloseFrames) {
            void var1_1;
            this.handleCloseFrames = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder sendCloseFrame(WebSocketCloseStatus sendCloseFrame) {
            void var1_1;
            this.sendCloseFrame = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder dropPongFrames(boolean dropPongFrames) {
            void var1_1;
            this.dropPongFrames = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            void var1_1;
            this.handshakeTimeoutMillis = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder forceCloseTimeoutMillis(long forceCloseTimeoutMillis) {
            void var1_1;
            this.forceCloseTimeoutMillis = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder absoluteUpgradeUrl(boolean absoluteUpgradeUrl) {
            void var1_1;
            this.absoluteUpgradeUrl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder generateOriginHeader(boolean generateOriginHeader) {
            void var1_1;
            this.generateOriginHeader = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withUTF8Validator(boolean withUTF8Validator) {
            void var1_1;
            this.withUTF8Validator = var1_1;
            return this;
        }

        public final WebSocketClientProtocolConfig build() {
            return new WebSocketClientProtocolConfig(this.webSocketUri, this.subprotocol, this.version, this.allowExtensions, this.customHeaders, this.maxFramePayloadLength, this.performMasking, this.allowMaskMismatch, this.handleCloseFrames, this.sendCloseFrame, this.dropPongFrames, this.handshakeTimeoutMillis, this.forceCloseTimeoutMillis, this.absoluteUpgradeUrl, this.generateOriginHeader, this.withUTF8Validator);
        }
    }
}

