/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;

public final class WebSocketClientHandshakerFactory {
    private WebSocketClientHandshakerFactory() {
    }

    /*
     * WARNING - void declaration
     */
    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders) {
        void var3_3;
        void var2_2;
        void var1_1;
        return WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, (WebSocketVersion)var1_1, (String)var2_2, (boolean)var3_3, customHeaders, 65536);
    }

    /*
     * WARNING - void declaration
     */
    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        return WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, (WebSocketVersion)var1_1, (String)var2_2, (boolean)var3_3, customHeaders, maxFramePayloadLength, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch) {
        void var3_3;
        void var2_2;
        void var1_1;
        return WebSocketClientHandshakerFactory.newHandshaker(webSocketURL, (WebSocketVersion)var1_1, (String)var2_2, (boolean)var3_3, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis) {
        void var1_1;
        if (version == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis);
        }
        if (version == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis);
        }
        if (version == WebSocketVersion.V07) {
            void var3_3;
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, (boolean)var3_3, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis);
        }
        if (version == WebSocketVersion.V00) {
            void var2_2;
            URI uRI;
            return new WebSocketClientHandshaker00(uRI, WebSocketVersion.V00, (String)var2_2, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis);
        }
        throw new WebSocketClientHandshakeException("Protocol version " + var1_1 + " not supported.");
    }

    /*
     * WARNING - void declaration
     */
    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl) {
        void var1_1;
        if (version == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl);
        }
        if (version == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl);
        }
        if (version == WebSocketVersion.V07) {
            void var3_3;
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, (boolean)var3_3, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl);
        }
        if (version == WebSocketVersion.V00) {
            void var2_2;
            URI uRI;
            return new WebSocketClientHandshaker00(uRI, WebSocketVersion.V00, (String)var2_2, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, absoluteUpgradeUrl);
        }
        throw new WebSocketClientHandshakeException("Protocol version " + var1_1 + " not supported.");
    }

    /*
     * WARNING - void declaration
     */
    public static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl, boolean generateOriginHeader) {
        void var1_1;
        if (version == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl, generateOriginHeader);
        }
        if (version == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl, generateOriginHeader);
        }
        if (version == WebSocketVersion.V07) {
            void var3_3;
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, (boolean)var3_3, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl, generateOriginHeader);
        }
        if (version == WebSocketVersion.V00) {
            void var2_2;
            URI uRI;
            return new WebSocketClientHandshaker00(uRI, WebSocketVersion.V00, (String)var2_2, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, absoluteUpgradeUrl, generateOriginHeader);
        }
        throw new WebSocketClientHandshakeException("Protocol version " + var1_1 + " not supported.");
    }
}

