/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class WebSocketClientHandshaker {
    private static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
    private static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
    protected static final int DEFAULT_FORCE_CLOSE_TIMEOUT_MILLIS = 10000;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private volatile long forceCloseTimeoutMillis = 10000L;
    private volatile int forceCloseInit;
    private static final AtomicIntegerFieldUpdater<WebSocketClientHandshaker> FORCE_CLOSE_INIT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WebSocketClientHandshaker.class, "forceCloseInit");
    private volatile boolean forceCloseComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean absoluteUpgradeUrl;
    protected final boolean generateOriginHeader;

    /*
     * WARNING - void declaration
     */
    protected WebSocketClientHandshaker(URI uri, WebSocketVersion version, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, customHeaders, maxFramePayloadLength, 10000L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected WebSocketClientHandshaker(URI uri, WebSocketVersion version, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength, long forceCloseTimeoutMillis) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected WebSocketClientHandshaker(URI uri, WebSocketVersion version, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl) {
        this((URI)var1_1, (WebSocketVersion)var2_2, (String)var3_3, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, absoluteUpgradeUrl, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected WebSocketClientHandshaker(URI uri, WebSocketVersion version, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl, boolean generateOriginHeader) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.uri = var1_1;
        this.version = var2_2;
        this.expectedSubprotocol = var3_3;
        this.customHeaders = customHeaders;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
        this.absoluteUpgradeUrl = absoluteUpgradeUrl;
        this.generateOriginHeader = generateOriginHeader;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    /*
     * WARNING - void declaration
     */
    private void setActualSubprotocol(String actualSubprotocol) {
        void var1_1;
        this.actualSubprotocol = var1_1;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    protected boolean isForceCloseComplete() {
        return this.forceCloseComplete;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketClientHandshaker setForceCloseTimeoutMillis(long forceCloseTimeoutMillis) {
        void var1_1;
        this.forceCloseTimeoutMillis = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture handshake(Channel channel) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        void v0 = var1_1;
        return this.handshake((Channel)v0, v0.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture handshake(Channel channel, ChannelPromise promise) {
        void var2_2;
        void var3_3;
        void var1_1;
        Object pipeline = channel.pipeline();
        HttpResponseDecoder httpResponseDecoder = (HttpResponseDecoder)pipeline.get(HttpResponseDecoder.class);
        if (httpResponseDecoder == null && (pipeline = (HttpClientCodec)pipeline.get(HttpClientCodec.class)) == null) {
            promise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            return promise;
        }
        if (this.uri.getHost() == null) {
            if (this.customHeaders == null || !this.customHeaders.contains((CharSequence)HttpHeaderNames.HOST)) {
                promise.setFailure((Throwable)new IllegalArgumentException("Cannot generate the 'host' header value, webSocketURI should contain host or passed through customHeaders"));
                return promise;
            }
            if (this.generateOriginHeader && !this.customHeaders.contains((CharSequence)HttpHeaderNames.ORIGIN)) {
                String originName = this.version == WebSocketVersion.V07 || this.version == WebSocketVersion.V08 ? HttpHeaderNames.SEC_WEBSOCKET_ORIGIN.toString() : HttpHeaderNames.ORIGIN.toString();
                promise.setFailure((Throwable)new IllegalArgumentException("Cannot generate the '" + originName + "' header value, webSocketURI should contain host or disable generateOriginHeader or pass value through customHeaders"));
                return promise;
            }
        }
        FullHttpRequest request = this.newHandshakeRequest();
        var1_1.writeAndFlush((Object)var3_3).addListener((GenericFutureListener)new ChannelFutureListener(this, promise){
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ WebSocketClientHandshaker this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) {
                void var1_1;
                if (future.isSuccess()) {
                    void var2_2;
                    ChannelPipeline p = future.channel().pipeline();
                    ChannelHandlerContext ctx = p.context(HttpRequestEncoder.class);
                    if (ctx == null) {
                        ctx = p.context(HttpClientCodec.class);
                    }
                    if (ctx == null) {
                        this.val$promise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec"));
                        return;
                    }
                    var1_1.addAfter(var2_2.name(), "ws-encoder", (ChannelHandler)this.this$0.newWebSocketEncoder());
                    this.val$promise.setSuccess();
                    return;
                }
                this.val$promise.setFailure(var1_1.cause());
            }
        });
        return var2_2;
    }

    protected abstract FullHttpRequest newHandshakeRequest();

    /*
     * WARNING - void declaration
     */
    public final void finishHandshake(Channel channel, FullHttpResponse response) {
        void var2_2;
        void var1_1;
        ChannelHandlerContext ctx;
        HttpObjectAggregator aggregator;
        this.verify(response);
        String receivedProtocol = response.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        receivedProtocol = receivedProtocol != null ? receivedProtocol.trim() : null;
        String[] expectedProtocol = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean protocolValid = false;
        if (expectedProtocol.isEmpty() && receivedProtocol == null) {
            protocolValid = true;
            WebSocketClientHandshaker webSocketClientHandshaker = this;
            webSocketClientHandshaker.setActualSubprotocol(webSocketClientHandshaker.expectedSubprotocol);
        } else if (!expectedProtocol.isEmpty() && receivedProtocol != null && !receivedProtocol.isEmpty()) {
            for (String string : expectedProtocol.split(",")) {
                if (!string.trim().equals(receivedProtocol)) continue;
                protocolValid = true;
                this.setActualSubprotocol(receivedProtocol);
                break;
            }
        }
        if (!protocolValid) {
            void var3_3;
            throw new WebSocketClientHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", var3_3, this.expectedSubprotocol), response);
        }
        this.setHandshakeComplete();
        ChannelPipeline p = channel.pipeline();
        HttpContentDecompressor decompressor = (HttpContentDecompressor)p.get(HttpContentDecompressor.class);
        if (decompressor != null) {
            p.remove((ChannelHandler)decompressor);
        }
        if ((aggregator = (HttpObjectAggregator)p.get(HttpObjectAggregator.class)) != null) {
            p.remove((ChannelHandler)aggregator);
        }
        if ((ctx = p.context(HttpResponseDecoder.class)) == null) {
            ctx = p.context(HttpClientCodec.class);
            if (ctx == null) {
                throw new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec");
            }
            HttpClientCodec codec = (HttpClientCodec)ctx.handler();
            codec.removeOutboundHandler();
            p.addAfter(ctx.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable(this, p, codec){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ HttpClientCodec val$codec;
                final /* synthetic */ WebSocketClientHandshaker this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$p = channelPipeline;
                    this.val$codec = httpClientCodec;
                }

                @Override
                public void run() {
                    this.val$p.remove((ChannelHandler)this.val$codec);
                }
            });
            return;
        }
        if (p.get(HttpRequestEncoder.class) != null) {
            p.remove(HttpRequestEncoder.class);
        }
        ChannelHandlerContext context = ctx;
        p.addAfter(context.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
        var1_1.eventLoop().execute(new Runnable(this, p, (ChannelHandlerContext)var2_2){
            final /* synthetic */ ChannelPipeline val$p;
            final /* synthetic */ ChannelHandlerContext val$context;
            final /* synthetic */ WebSocketClientHandshaker this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$p = channelPipeline;
                this.val$context = channelHandlerContext;
            }

            @Override
            public void run() {
                this.val$p.remove(this.val$context.handler());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture processHandshake(Channel channel, HttpResponse response) {
        void var1_1;
        void var2_2;
        return this.processHandshake(channel, (HttpResponse)var2_2, var1_1.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture processHandshake(Channel channel, HttpResponse response, ChannelPromise promise) {
        void var3_4;
        if (response instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)response);
                promise.setSuccess();
            }
            catch (Throwable cause) {
                promise.setFailure(cause);
            }
        } else {
            ChannelPipeline p = channel.pipeline();
            ChannelHandlerContext ctx = p.context(HttpResponseDecoder.class);
            if (ctx == null && (ctx = p.context(HttpClientCodec.class)) == null) {
                return promise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            }
            String aggregatorCtx = ctx.name();
            if (this.version == WebSocketVersion.V00) {
                aggregatorCtx = "httpAggregator";
                p.addAfter(ctx.name(), aggregatorCtx, (ChannelHandler)new HttpObjectAggregator(8192));
            }
            p.addAfter(aggregatorCtx, "handshaker", (ChannelHandler)new ChannelInboundHandlerAdapter(this, promise, channel){
                private FullHttpResponse fullHttpResponse;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ Channel val$channel;
                final /* synthetic */ WebSocketClientHandshaker this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                    this.val$channel = channel;
                }

                /*
                 * WARNING - void declaration
                 */
                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg instanceof HttpObject) {
                        try {
                            this.handleHandshakeResponse(ctx, (HttpObject)msg);
                        }
                        finally {
                            ReferenceCountUtil.release((Object)msg);
                        }
                    } else {
                        void var2_3;
                        void var1_1;
                        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_3);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    void var2_2;
                    ctx.pipeline().remove((ChannelHandler)this);
                    this.val$promise.setFailure((Throwable)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    try {
                        void var1_1;
                        if (!this.val$promise.isDone()) {
                            this.val$promise.tryFailure((Throwable)new ClosedChannelException());
                        }
                        var1_1.fireChannelInactive();
                        return;
                    }
                    finally {
                        this.releaseFullHttpResponse();
                    }
                }

                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                    this.releaseFullHttpResponse();
                }

                /*
                 * WARNING - void declaration
                 */
                private void handleHandshakeResponse(ChannelHandlerContext ctx, HttpObject response) {
                    FullHttpResponse handshakeResponse;
                    if (response instanceof FullHttpResponse) {
                        ctx.pipeline().remove((ChannelHandler)this);
                        this.tryFinishHandshake((FullHttpResponse)response);
                        return;
                    }
                    if (response instanceof LastHttpContent) {
                        assert (this.fullHttpResponse != null);
                        handshakeResponse = this.fullHttpResponse;
                        this.fullHttpResponse = null;
                        try {
                            void var1_1;
                            var1_1.pipeline().remove((ChannelHandler)this);
                            this.tryFinishHandshake(handshakeResponse);
                            return;
                        }
                        finally {
                            handshakeResponse.release();
                        }
                    }
                    if (handshakeResponse instanceof HttpResponse) {
                        HttpResponse httpResponse = handshakeResponse;
                        this.fullHttpResponse = new DefaultFullHttpResponse(httpResponse.protocolVersion(), httpResponse.status(), Unpooled.EMPTY_BUFFER, httpResponse.headers(), EmptyHttpHeaders.INSTANCE);
                        if (httpResponse.decoderResult().isFailure()) {
                            void var2_3;
                            this.fullHttpResponse.setDecoderResult(var2_3.decoderResult());
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private void tryFinishHandshake(FullHttpResponse fullHttpResponse) {
                    try {
                        this.this$0.finishHandshake(this.val$channel, fullHttpResponse);
                        this.val$promise.setSuccess();
                        return;
                    }
                    catch (Throwable cause) {
                        void var1_2;
                        this.val$promise.setFailure((Throwable)var1_2);
                        return;
                    }
                }

                private void releaseFullHttpResponse() {
                    if (this.fullHttpResponse != null) {
                        this.fullHttpResponse.release();
                        this.fullHttpResponse = null;
                    }
                }
            });
            try {
                void var2_3;
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)var2_3));
            }
            catch (Throwable cause) {
                void var1_2;
                promise.setFailure((Throwable)var1_2);
            }
        }
        return var3_4;
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        return this.close(channel, (CloseWebSocketFrame)var2_2, var1_1.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        void v0 = var1_1;
        return this.close0((ChannelOutboundInvoker)v0, (Channel)v0, (CloseWebSocketFrame)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)ctx, (String)"ctx");
        return this.close(ctx, (CloseWebSocketFrame)var2_2, var1_1.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(ChannelHandlerContext ctx, CloseWebSocketFrame frame, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)ctx, (String)"ctx");
        void v0 = var1_1;
        return this.close0((ChannelOutboundInvoker)v0, v0.channel(), (CloseWebSocketFrame)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture close0(ChannelOutboundInvoker invoker, Channel channel, CloseWebSocketFrame frame, ChannelPromise promise) {
        void var1_1;
        void var3_3;
        void var2_2;
        invoker.writeAndFlush((Object)frame, promise);
        long forceCloseTimeoutMillis = this.forceCloseTimeoutMillis;
        WebSocketClientHandshaker handshaker = this;
        if (forceCloseTimeoutMillis <= 0L || !channel.isActive() || this.forceCloseInit != 0) {
            return promise;
        }
        promise.addListener((GenericFutureListener)new ChannelFutureListener(this, (Channel)var2_2, (WebSocketClientHandshaker)var3_3, (ChannelOutboundInvoker)var1_1, forceCloseTimeoutMillis){
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ WebSocketClientHandshaker val$handshaker;
            final /* synthetic */ ChannelOutboundInvoker val$invoker;
            final /* synthetic */ long val$forceCloseTimeoutMillis;
            final /* synthetic */ WebSocketClientHandshaker this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$channel = channel;
                this.val$handshaker = webSocketClientHandshaker;
                this.val$invoker = channelOutboundInvoker;
                this.val$forceCloseTimeoutMillis = l;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess() && this.val$channel.isActive() && FORCE_CLOSE_INIT_UPDATER.compareAndSet(this.val$handshaker, 0, 1)) {
                    void var1_1;
                    ScheduledFuture forceCloseFuture = this.val$channel.eventLoop().schedule(new Runnable(this){
                        final /* synthetic */ 5 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void run() {
                            if (this.this$1.val$channel.isActive()) {
                                this.this$1.val$invoker.close();
                                WebSocketClientHandshaker.access$102(this.this$1.this$0, true);
                            }
                        }
                    }, this.val$forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
                    this.val$channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(this, (Future)var1_1){
                        final /* synthetic */ Future val$forceCloseFuture;
                        final /* synthetic */ 5 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                            this.val$forceCloseFuture = future;
                        }

                        public void operationComplete(ChannelFuture future) throws Exception {
                            this.val$forceCloseFuture.cancel(false);
                        }
                    });
                }
            }
        });
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    protected String upgradeUrl(URI wsURL) {
        void var2_2;
        if (this.absoluteUpgradeUrl) {
            return wsURL.toString();
        }
        String path = wsURL.getRawPath();
        path = path == null || path.isEmpty() ? "/" : path;
        String query = wsURL.getRawQuery();
        if (query != null && !query.isEmpty()) {
            void var1_1;
            return path + '?' + (String)var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static CharSequence websocketHostValue(URI wsURL) {
        void var1_1;
        void var2_2;
        int port = wsURL.getPort();
        if (port == -1) {
            return wsURL.getHost();
        }
        String host = wsURL.getHost();
        String scheme = wsURL.getScheme();
        if (port == HttpScheme.HTTP.port()) {
            if (HttpScheme.HTTP.name().contentEquals((CharSequence)scheme) || WebSocketScheme.WS.name().contentEquals((CharSequence)scheme)) {
                return host;
            }
            return NetUtil.toSocketAddressString((String)host, (int)port);
        }
        if (port == HttpScheme.HTTPS.port()) {
            String string;
            if (HttpScheme.HTTPS.name().contentEquals((CharSequence)scheme) || WebSocketScheme.WSS.name().contentEquals((CharSequence)string)) {
                return host;
            }
            return NetUtil.toSocketAddressString((String)host, (int)port);
        }
        return NetUtil.toSocketAddressString((String)var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static CharSequence websocketOriginValue(URI wsURL) {
        String string;
        void var1_1;
        void var3_3;
        int defaultPort;
        String schemePrefix;
        String scheme = wsURL.getScheme();
        int port = wsURL.getPort();
        if (WebSocketScheme.WSS.name().contentEquals((CharSequence)scheme) || HttpScheme.HTTPS.name().contentEquals((CharSequence)scheme) || scheme == null && port == WebSocketScheme.WSS.port()) {
            schemePrefix = HTTPS_SCHEME_PREFIX;
            defaultPort = WebSocketScheme.WSS.port();
        } else {
            schemePrefix = HTTP_SCHEME_PREFIX;
            defaultPort = WebSocketScheme.WS.port();
        }
        String host = wsURL.getHost().toLowerCase(Locale.US);
        if (port != var3_3 && port != -1) {
            void var2_2;
            return schemePrefix + NetUtil.toSocketAddressString((String)host, (int)var2_2);
        }
        return (String)var1_1 + (String)string;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(WebSocketClientHandshaker x0, boolean x1) {
        void var1_1;
        x0.forceCloseComplete = var1_1;
        return x0.forceCloseComplete;
    }
}

