/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class WebSocket00FrameDecoder
extends ReplayingDecoder<Void>
implements WebSocketFrameDecoder {
    static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384);
    }

    /*
     * WARNING - void declaration
     */
    public WebSocket00FrameDecoder(int maxFrameSize) {
        void var1_1;
        this.maxFrameSize = (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebSocket00FrameDecoder(WebSocketDecoderConfig decoderConfig) {
        void var1_1;
        this.maxFrameSize = ((WebSocketDecoderConfig)ObjectUtil.checkNotNull((Object)var1_1, (String)"decoderConfig")).maxFramePayloadLength();
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_2;
        WebSocketFrame frame;
        if (this.receivedClosingHandshake) {
            in.skipBytes(this.actualReadableBytes());
            return;
        }
        byte type = in.readByte();
        frame = (type & 0x80) == 128 ? this.decodeBinaryFrame(ctx, type, in) : this.decodeTextFrame((ChannelHandlerContext)frame, (ByteBuf)var2_2);
        if (frame != null) {
            void var1_1;
            void var3_3;
            var3_3.add(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private WebSocketFrame decodeBinaryFrame(ChannelHandlerContext ctx, byte type, ByteBuf buffer) {
        void var1_1;
        void var3_3;
        void var2_2;
        byte b;
        long frameSize = 0L;
        int lengthFieldSize = 0;
        do {
            b = buffer.readByte();
            frameSize <<= 7;
            if ((frameSize |= (long)(b & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++lengthFieldSize <= 8) continue;
            throw new TooLongFrameException();
        } while ((b & 0x80) == 128);
        if (var2_2 == -1 && frameSize == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame(true, 0, ctx.alloc().buffer(0));
        }
        ByteBuf payload = ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)var3_3, (int)((int)frameSize));
        return new BinaryWebSocketFrame((ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private WebSocketFrame decodeTextFrame(ChannelHandlerContext ctx, ByteBuf buffer) {
        void var1_1;
        void var2_2;
        void var3_4;
        int ridx = buffer.readerIndex();
        int rbytes = this.actualReadableBytes();
        int n = ridx;
        int delimPos = buffer.indexOf(n, n + rbytes, (byte)-1);
        if (delimPos == -1) {
            if ((long)rbytes > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        int frameSize = delimPos - ridx;
        if ((long)frameSize > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        ByteBuf binaryData = ByteBufUtil.readBytes((ByteBufAllocator)ctx.alloc(), (ByteBuf)buffer, (int)var3_4);
        var2_2.skipBytes(1);
        ByteBuf byteBuf = binaryData;
        int n2 = byteBuf.indexOf(byteBuf.readerIndex(), binaryData.writerIndex(), (byte)-1);
        if (n2 >= 0) {
            binaryData.release();
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame((ByteBuf)var1_1);
    }
}

