/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8Validator;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;

public class Utf8FrameValidator
extends ChannelInboundHandlerAdapter {
    private final boolean closeOnProtocolViolation;
    private int fragmentedFramesCount;
    private Utf8Validator utf8Validator;

    public Utf8FrameValidator() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public Utf8FrameValidator(boolean closeOnProtocolViolation) {
        void var1_1;
        this.closeOnProtocolViolation = var1_1;
    }

    private static boolean isControlFrame(WebSocketFrame frame) {
        WebSocketFrame webSocketFrame;
        return frame instanceof CloseWebSocketFrame || frame instanceof PingWebSocketFrame || webSocketFrame instanceof PongWebSocketFrame;
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)((Object)msg);
            try {
                if (frame.isFinalFragment()) {
                    if (!Utf8FrameValidator.isControlFrame(frame)) {
                        this.fragmentedFramesCount = 0;
                        if (frame instanceof TextWebSocketFrame || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                            this.checkUTF8String(frame.content());
                            this.utf8Validator.finish();
                        }
                    }
                } else {
                    if (this.fragmentedFramesCount == 0) {
                        if (frame instanceof TextWebSocketFrame) {
                            this.checkUTF8String(frame.content());
                        }
                    } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                        this.checkUTF8String(frame.content());
                    }
                    ++this.fragmentedFramesCount;
                }
            }
            catch (CorruptedWebSocketFrameException e) {
                void var3_3;
                this.protocolViolation(ctx, (WebSocketFrame)var3_3, e);
            }
        }
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void checkUTF8String(ByteBuf buffer) {
        void var1_1;
        if (this.utf8Validator == null) {
            this.utf8Validator = new Utf8Validator();
        }
        this.utf8Validator.check((ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void protocolViolation(ChannelHandlerContext ctx, WebSocketFrame frame, CorruptedWebSocketFrameException ex) {
        void var3_3;
        frame.release();
        if (this.closeOnProtocolViolation && ctx.channel().isOpen()) {
            void var2_2;
            void var1_1;
            WebSocketCloseStatus closeStatus = ex.closeStatus();
            String reasonText = ex.getMessage();
            if (reasonText == null) {
                reasonText = closeStatus.reasonText();
            }
            CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(closeStatus.code(), reasonText);
            var1_1.writeAndFlush((Object)var2_2).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        throw var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        super.exceptionCaught((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }
}

