/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame() {
        super(Unpooled.buffer((int)0));
    }

    /*
     * WARNING - void declaration
     */
    public CloseWebSocketFrame(WebSocketCloseStatus status) {
        this(CloseWebSocketFrame.requireValidStatusCode(status.code()), var1_1.reasonText());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CloseWebSocketFrame(WebSocketCloseStatus status, String reasonText) {
        this(CloseWebSocketFrame.requireValidStatusCode(var1_1.code()), (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CloseWebSocketFrame(int statusCode, String reasonText) {
        this(true, 0, CloseWebSocketFrame.requireValidStatusCode((int)var1_1), (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CloseWebSocketFrame(boolean finalFragment, int rsv) {
        this((boolean)var1_1, (int)var2_2, Unpooled.buffer((int)0));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CloseWebSocketFrame(boolean finalFragment, int rsv, int statusCode, String reasonText) {
        super((boolean)var1_1, (int)var2_2, CloseWebSocketFrame.newBinaryData(CloseWebSocketFrame.requireValidStatusCode((int)var3_3), reasonText));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf newBinaryData(int statusCode, String reasonText) {
        void var2_2;
        int n;
        if (reasonText == null) {
            reasonText = "";
        }
        ByteBuf binaryData = Unpooled.buffer((int)(2 + reasonText.length()));
        binaryData.writeShort(n);
        if (!reasonText.isEmpty()) {
            void var1_1;
            binaryData.writeCharSequence((CharSequence)var1_1, CharsetUtil.UTF_8);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CloseWebSocketFrame(boolean finalFragment, int rsv, ByteBuf binaryData) {
        super((boolean)var1_1, (int)var2_2, (ByteBuf)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int statusCode() {
        void var1_1;
        ByteBuf binaryData = this.content();
        if (binaryData == null || binaryData.readableBytes() < 2) {
            return -1;
        }
        void v0 = var1_1;
        return v0.getUnsignedShort(v0.readerIndex());
    }

    /*
     * WARNING - void declaration
     */
    public String reasonText() {
        void var1_1;
        ByteBuf binaryData = this.content();
        if (binaryData == null || binaryData.readableBytes() <= 2) {
            return "";
        }
        ByteBuf byteBuf = binaryData;
        return byteBuf.toString(byteBuf.readerIndex() + 2, var1_1.readableBytes() - 2, CharsetUtil.UTF_8);
    }

    @Override
    public CloseWebSocketFrame copy() {
        return (CloseWebSocketFrame)super.copy();
    }

    @Override
    public CloseWebSocketFrame duplicate() {
        return (CloseWebSocketFrame)super.duplicate();
    }

    @Override
    public CloseWebSocketFrame retainedDuplicate() {
        return (CloseWebSocketFrame)super.retainedDuplicate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseWebSocketFrame replace(ByteBuf content) {
        void var1_1;
        return new CloseWebSocketFrame(this.isFinalFragment(), this.rsv(), (ByteBuf)var1_1);
    }

    @Override
    public CloseWebSocketFrame retain() {
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseWebSocketFrame retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public CloseWebSocketFrame touch() {
        super.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseWebSocketFrame touch(Object hint) {
        void var1_1;
        super.touch(var1_1);
        return this;
    }

    static int requireValidStatusCode(int statusCode) {
        int n;
        if (WebSocketCloseStatus.isValidStatusCode(statusCode)) {
            return statusCode;
        }
        throw new IllegalArgumentException("WebSocket close status code does NOT comply with RFC-6455: " + n);
    }
}

