/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.AbstractMixedHttpData;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import java.io.IOException;
import java.nio.charset.Charset;

public class MixedAttribute
extends AbstractMixedHttpData<Attribute>
implements Attribute {
    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, long limitSize) {
        this((String)var1_1, (long)var2_2, HttpConstants.DEFAULT_CHARSET);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, long definedSize, long limitSize) {
        this((String)var1_1, (long)var2_2, limitSize, HttpConstants.DEFAULT_CHARSET);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, long limitSize, Charset charset) {
        this((String)var1_1, (long)var2_2, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        this((String)var1_1, 0L, (long)var2_2, charset, baseDir, deleteOnExit);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, long definedSize, long limitSize, Charset charset) {
        this((String)var1_1, (long)var2_2, limitSize, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, long definedSize, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        super(limitSize, baseDir, deleteOnExit, new MemoryAttribute((String)var1_1, (long)var2_2, charset));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, String value, long limitSize) {
        this((String)var1_1, (String)var2_2, (long)var3_3, HttpConstants.DEFAULT_CHARSET, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, String value, long limitSize, Charset charset) {
        this((String)var1_1, (String)var2_2, (long)var3_3, charset, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static Attribute makeInitialAttributeFromValue(String name, String value, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        if ((long)value.length() > limitSize) {
            try {
                return new DiskAttribute(name, value, charset, baseDir, deleteOnExit);
            }
            catch (IOException e) {
                try {
                    return new MemoryAttribute(name, value, charset);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        try {
            void var1_1;
            String string;
            return new MemoryAttribute(string, (String)var1_1, charset);
        }
        catch (IOException e) {
            void var2_4;
            throw new IllegalArgumentException((Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public MixedAttribute(String name, String value, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        super(limitSize, baseDir, deleteOnExit, MixedAttribute.makeInitialAttributeFromValue((String)var1_1, (String)var2_2, (long)var3_3, charset, baseDir, deleteOnExit));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public String getValue() throws IOException {
        return ((Attribute)this.wrapped).getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setValue(String value) throws IOException {
        void var1_1;
        ((Attribute)this.wrapped).setValue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Attribute makeDiskData() {
        void var1_1;
        DiskAttribute diskAttribute = new DiskAttribute(this.getName(), this.definedLength(), this.baseDir, this.deleteOnExit);
        diskAttribute.setMaxSize(this.getMaxSize());
        return var1_1;
    }

    @Override
    public Attribute copy() {
        return (Attribute)super.copy();
    }

    @Override
    public Attribute duplicate() {
        return (Attribute)super.duplicate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute replace(ByteBuf content) {
        void var1_1;
        return (Attribute)super.replace((ByteBuf)var1_1);
    }

    @Override
    public Attribute retain() {
        return (Attribute)super.retain();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute retain(int increment) {
        void var1_1;
        return (Attribute)super.retain((int)var1_1);
    }

    @Override
    public Attribute retainedDuplicate() {
        return (Attribute)super.retainedDuplicate();
    }

    @Override
    public Attribute touch() {
        return (Attribute)super.touch();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute touch(Object hint) {
        void var1_1;
        return (Attribute)super.touch(var1_1);
    }
}

