/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.FileUploadUtil;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;

public class MemoryFileUpload
extends AbstractMemoryHttpData
implements FileUpload {
    private String filename;
    private String contentType;
    private String contentTransferEncoding;

    /*
     * WARNING - void declaration
     */
    public MemoryFileUpload(String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        super((String)var1_1, charset, size);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setFilename((String)var2_2);
        this.setContentType((String)var3_3);
        this.setContentTransferEncoding(contentTransferEncoding);
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.FileUpload;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFilename(String filename) {
        void var1_1;
        this.filename = (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"filename");
    }

    public int hashCode() {
        return FileUploadUtil.hashCode(this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof FileUpload && FileUploadUtil.equals(this, (FileUpload)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(InterfaceHttpData o) {
        void var1_1;
        if (!(o instanceof FileUpload)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)o.getHttpDataType()));
        }
        return this.compareTo((FileUpload)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(FileUpload o) {
        void var1_1;
        return FileUploadUtil.compareTo(this, (FileUpload)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContentType(String contentType) {
        void var1_1;
        this.contentType = (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"contentType");
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContentTransferEncoding(String contentTransferEncoding) {
        void var1_1;
        this.contentTransferEncoding = var1_1;
    }

    public String toString() {
        return HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + this.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + this.filename + "\"\r\n" + HttpHeaderNames.CONTENT_TYPE + ": " + this.contentType + (this.getCharset() != null ? "; " + HttpHeaderValues.CHARSET + '=' + this.getCharset().name() + "\r\n" : "\r\n") + HttpHeaderNames.CONTENT_LENGTH + ": " + this.length() + "\r\nCompleted: " + this.isCompleted() + "\r\nIsInMemory: " + this.isInMemory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileUpload copy() {
        void var1_1;
        ByteBuf content = this.content();
        return this.replace((ByteBuf)(content != null ? content.copy() : var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileUpload duplicate() {
        void var1_1;
        ByteBuf content = this.content();
        return this.replace((ByteBuf)(content != null ? content.duplicate() : var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileUpload retainedDuplicate() {
        ByteBuf content = this.content();
        if (content != null) {
            content = content.retainedDuplicate();
            boolean success = false;
            try {
                void var3_3;
                FileUpload duplicate = this.replace(content);
                success = true;
                return var3_3;
            }
            catch (Throwable throwable) {
                void var2_2;
                if (var2_2 == false) {
                    void var1_1;
                    var1_1.release();
                }
                throw throwable;
            }
        }
        return this.replace(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileUpload replace(ByteBuf content) {
        void var2_3;
        MemoryFileUpload upload = new MemoryFileUpload(this.getName(), this.getFilename(), this.getContentType(), this.getContentTransferEncoding(), this.getCharset(), this.size);
        if (content != null) {
            try {
                upload.setContent(content);
            }
            catch (IOException e) {
                void var1_2;
                throw new ChannelException((Throwable)var1_2);
            }
        }
        upload.setCompleted(this.isCompleted());
        return var2_3;
    }

    @Override
    public FileUpload retain() {
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileUpload retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public FileUpload touch() {
        super.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileUpload touch(Object hint) {
        void var1_1;
        super.touch(var1_1);
        return this;
    }
}

