/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

final class InternalAttribute
extends AbstractReferenceCounted
implements InterfaceHttpData {
    private final List<ByteBuf> value = new ArrayList<ByteBuf>();
    private final Charset charset;
    private int size;

    /*
     * WARNING - void declaration
     */
    InternalAttribute(Charset charset) {
        void var1_1;
        this.charset = var1_1;
    }

    @Override
    public final InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.InternalAttribute;
    }

    /*
     * WARNING - void declaration
     */
    public final void addValue(String value) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)value, (String)"value");
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)value, (Charset)this.charset);
        this.value.add(buf);
        this.size += var1_1.readableBytes();
    }

    /*
     * WARNING - void declaration
     */
    public final void addValue(String value, int rank) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)value, (String)"value");
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)value, (Charset)this.charset);
        this.value.add((int)var2_2, buf);
        this.size += var1_1.readableBytes();
    }

    /*
     * WARNING - void declaration
     */
    public final void setValue(String value, int rank) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)value, (String)"value");
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)value, (Charset)this.charset);
        ByteBuf old = this.value.set(rank, buf);
        if (old != null) {
            void var2_3;
            this.size -= old.readableBytes();
            var2_3.release();
        }
        this.size += var1_1.readableBytes();
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof InternalAttribute)) {
            return false;
        }
        InternalAttribute attribute = (InternalAttribute)o;
        return this.getName().equalsIgnoreCase(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(InterfaceHttpData o) {
        void var1_1;
        if (!(o instanceof InternalAttribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)o.getHttpDataType()));
        }
        return this.compareTo((InternalAttribute)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(InternalAttribute o) {
        void var1_1;
        return this.getName().compareToIgnoreCase(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder result = new StringBuilder();
        for (ByteBuf elt : this.value) {
            void var3_3;
            result.append(var3_3.toString(this.charset));
        }
        return var1_1.toString();
    }

    public final int size() {
        return this.size;
    }

    public final ByteBuf toByteBuf() {
        return Unpooled.compositeBuffer().addComponents(this.value).writerIndex(this.size()).readerIndex(0);
    }

    @Override
    public final String getName() {
        return "InternalAttribute";
    }

    protected final void deallocate() {
    }

    @Override
    public final InterfaceHttpData retain() {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.retain();
        }
        return this;
    }

    @Override
    public final InterfaceHttpData retain(int increment) {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.retain(increment);
        }
        return this;
    }

    @Override
    public final InterfaceHttpData touch() {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.touch();
        }
        return this;
    }

    @Override
    public final InterfaceHttpData touch(Object hint) {
        for (ByteBuf byteBuf : this.value) {
            byteBuf.touch(hint);
        }
        return this;
    }
}

