/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostStandardRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private final int maxFields;
    private final int maxBufferedBytes;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private HttpPostRequestDecoder.MultiPartStatus currentStatus = HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    /*
     * WARNING - void declaration
     */
    public HttpPostStandardRequestDecoder(HttpRequest request) {
        this(new DefaultHttpDataFactory(16384L), (HttpRequest)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostStandardRequestDecoder(HttpDataFactory factory, HttpRequest request) {
        this((HttpDataFactory)var1_1, (HttpRequest)var2_2, HttpConstants.DEFAULT_CHARSET);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostStandardRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset) {
        this((HttpDataFactory)var1_1, (HttpRequest)var2_2, (Charset)var3_3, 128, 1024);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostStandardRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset, int maxFields, int maxBufferedBytes) {
        void var3_4;
        this.request = (HttpRequest)ObjectUtil.checkNotNull((Object)request, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)var3_4, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNull((Object)factory, (String)"factory");
        this.maxFields = maxFields;
        this.maxBufferedBytes = maxBufferedBytes;
        try {
            void var2_3;
            if (!(request instanceof HttpContent)) {
                this.parseBody();
                return;
            }
            this.offer((HttpContent)var2_3);
        }
        catch (Throwable e) {
            void var1_2;
            this.destroy();
            PlatformDependent.throwException((Throwable)var1_2);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostStandardRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDiscardThreshold(int discardThreshold) {
        void var1_1;
        this.discardThreshold = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String name) {
        void var1_1;
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InterfaceHttpData getBodyHttpData(String name) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(name);
        if (list != null) {
            void var1_1;
            return (InterfaceHttpData)var1_1.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpPostStandardRequestDecoder offer(HttpContent content) {
        this.checkDestroyed();
        if (content instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        ByteBuf buf = content.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = buf.alloc().buffer(buf.readableBytes()).writeBytes(buf);
        } else {
            this.undecodedChunk.writeBytes(buf);
        }
        this.parseBody();
        if (this.maxBufferedBytes > 0 && this.undecodedChunk != null && this.undecodedChunk.readableBytes() > this.maxBufferedBytes) {
            throw new HttpPostRequestDecoder.TooLongFormFieldException();
        }
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            if (this.undecodedChunk.refCnt() == 1) {
                this.undecodedChunk.discardReadBytes();
            } else {
                void var1_1;
                ByteBuf buffer = this.undecodedChunk.alloc().buffer(this.undecodedChunk.readableBytes());
                buffer.writeBytes(this.undecodedChunk);
                this.undecodedChunk.release();
                this.undecodedChunk = var1_1;
            }
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder.EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyAttributes();
    }

    /*
     * WARNING - void declaration
     */
    protected void addHttpData(InterfaceHttpData data) {
        void var1_1;
        void var2_2;
        if (data == null) {
            return;
        }
        if (this.maxFields > 0 && this.bodyListHttpData.size() >= this.maxFields) {
            throw new HttpPostRequestDecoder.TooManyFormFieldsException();
        }
        List<InterfaceHttpData> datas = this.bodyMapHttpData.get(data.getName());
        if (datas == null) {
            datas = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(data.getName(), datas);
        }
        var2_2.add(data);
        this.bodyListHttpData.add((InterfaceHttpData)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributesStandard() {
        int firstpos;
        int currentpos = firstpos = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
        }
        boolean contRead = true;
        try {
            block8: while (this.undecodedChunk.isReadable() && contRead) {
                char read = (char)this.undecodedChunk.readUnsignedByte();
                ++currentpos;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        void key22;
                        if (read == '=') {
                            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FIELD;
                            int equalpos = currentpos - 1;
                            String key = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(firstpos, equalpos - firstpos, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, key);
                            firstpos = currentpos;
                            continue block8;
                        }
                        if (key22 != 38 && (!this.isLastChunk || this.undecodedChunk.isReadable() || !this.hasFormBody())) continue block8;
                        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
                        int ampersandpos = key22 == 38 ? currentpos - 1 : currentpos;
                        String key22 = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(firstpos, ampersandpos - firstpos, this.charset), this.charset);
                        if (!key22.isEmpty()) {
                            this.currentAttribute = this.factory.createAttribute(this.request, key22);
                            this.currentAttribute.setValue("");
                            HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                            httpPostStandardRequestDecoder.addHttpData(httpPostStandardRequestDecoder.currentAttribute);
                        }
                        this.currentAttribute = null;
                        firstpos = currentpos;
                        contRead = true;
                        continue block8;
                    }
                    case FIELD: {
                        int ampersandpos;
                        void key22;
                        if (key22 == 38) {
                            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
                            ampersandpos = currentpos - 1;
                            HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                            httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(firstpos, ampersandpos - firstpos));
                            firstpos = currentpos;
                            contRead = true;
                            continue block8;
                        }
                        if (ampersandpos == 13) {
                            if (this.undecodedChunk.isReadable()) {
                                ampersandpos = (char)this.undecodedChunk.readUnsignedByte();
                                ++currentpos;
                                if (ampersandpos != 10) {
                                    throw new HttpPostRequestDecoder.ErrorDataDecoderException("Bad end of line");
                                }
                                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE;
                                ampersandpos = currentpos - 2;
                                HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                                httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(firstpos, ampersandpos - firstpos));
                                firstpos = currentpos;
                                break;
                            }
                            --currentpos;
                            continue block8;
                        }
                        if (ampersandpos != 10) continue block8;
                        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE;
                        ampersandpos = currentpos - 1;
                        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                        httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(firstpos, ampersandpos - firstpos));
                        firstpos = currentpos;
                        break;
                    }
                }
                contRead = false;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                int ampersandpos = currentpos;
                if (ampersandpos > firstpos) {
                    HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
                    httpPostStandardRequestDecoder.setFinalBuffer(httpPostStandardRequestDecoder.undecodedChunk.retainedSlice(firstpos, ampersandpos - firstpos));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                firstpos = currentpos;
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            } else if (contRead && this.currentAttribute != null && this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.FIELD) {
                void var2_2;
                this.currentAttribute.addContent(this.undecodedChunk.retainedSlice(firstpos, currentpos - firstpos), false);
                firstpos = var2_2;
            }
            this.undecodedChunk.readerIndex(firstpos);
            return;
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            this.undecodedChunk.readerIndex(firstpos);
            throw e;
        }
        catch (IOException e) {
            this.undecodedChunk.readerIndex(firstpos);
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
        }
        catch (IllegalArgumentException e) {
            void var3_10;
            void var1_1;
            this.undecodedChunk.readerIndex((int)var1_1);
            throw new HttpPostRequestDecoder.ErrorDataDecoderException((Throwable)var3_10);
        }
    }

    private void parseBodyAttributes() {
        if (this.undecodedChunk == null) {
            return;
        }
        this.parseBodyAttributesStandard();
    }

    /*
     * WARNING - void declaration
     */
    private void setFinalBuffer(ByteBuf buffer) throws IOException {
        this.currentAttribute.addContent(buffer, true);
        ByteBuf decodedBuf = HttpPostStandardRequestDecoder.decodeAttribute(this.currentAttribute.getByteBuf(), this.charset);
        if (decodedBuf != null) {
            void var1_1;
            this.currentAttribute.setContent((ByteBuf)var1_1);
        }
        HttpPostStandardRequestDecoder httpPostStandardRequestDecoder = this;
        httpPostStandardRequestDecoder.addHttpData(httpPostStandardRequestDecoder.currentAttribute);
        this.currentAttribute = null;
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeAttribute(String s, Charset charset) {
        try {
            return QueryStringDecoder.decodeComponent(s, charset);
        }
        catch (IllegalArgumentException e) {
            void var1_2;
            String string;
            throw new HttpPostRequestDecoder.ErrorDataDecoderException("Bad string: '" + string + '\'', (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf decodeAttribute(ByteBuf b, Charset charset) {
        void var2_3;
        int n = b.forEachByte((ByteProcessor)new UrlEncodedDetector());
        if (n == -1) {
            return null;
        }
        ByteBuf buf = b.alloc().buffer(b.readableBytes());
        UrlDecoder urlDecode = new UrlDecoder(buf);
        int idx = b.forEachByte((ByteProcessor)urlDecode);
        if (urlDecode.nextEscapedIdx != 0) {
            void var1_1;
            ByteBuf byteBuf;
            void var3_4;
            if (idx == -1) {
                idx = b.readableBytes() - 1;
            }
            buf.release();
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(String.format("Invalid hex byte at index '%d' in string: '%s'", idx -= ((UrlDecoder)var3_4).nextEscapedIdx - 1, byteBuf.toString((Charset)var1_1)));
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData httpData : this.bodyListHttpData) {
            void var2_2;
            if (httpData.refCnt() <= 0) continue;
            var2_2.release();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeHttpDataFromClean(InterfaceHttpData data) {
        void var1_1;
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, (InterfaceHttpData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasFormBody() {
        void var1_1;
        String contentHeaderValue = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentHeaderValue == null) {
            return false;
        }
        return HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.contentEquals((CharSequence)contentHeaderValue) || HttpHeaderValues.MULTIPART_FORM_DATA.contentEquals((CharSequence)var1_1);
    }

    private static final class UrlDecoder
    implements ByteProcessor {
        private final ByteBuf output;
        private int nextEscapedIdx;
        private byte hiByte;

        /*
         * WARNING - void declaration
         */
        UrlDecoder(ByteBuf output) {
            void var1_1;
            this.output = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean process(byte value) {
            void var1_1;
            if (this.nextEscapedIdx != 0) {
                if (this.nextEscapedIdx == 1) {
                    this.hiByte = value;
                    ++this.nextEscapedIdx;
                } else {
                    void var2_2;
                    int hi = StringUtil.decodeHexNibble((char)((char)this.hiByte));
                    int lo = StringUtil.decodeHexNibble((char)((char)value));
                    if (hi == -1 || lo == -1) {
                        ++this.nextEscapedIdx;
                        return false;
                    }
                    this.output.writeByte((int)((var2_2 << 4) + var1_1));
                    this.nextEscapedIdx = 0;
                }
            } else if (var1_1 == 37) {
                this.nextEscapedIdx = 1;
            } else if (var1_1 == 43) {
                this.output.writeByte(32);
            } else {
                this.output.writeByte((int)var1_1);
            }
            return true;
        }
    }

    private static final class UrlEncodedDetector
    implements ByteProcessor {
        private UrlEncodedDetector() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean process(byte value) throws Exception {
            void var1_1;
            return value != 37 && var1_1 != 43;
        }
    }
}

