/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InternalAttribute;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class HttpPostRequestEncoder
implements ChunkedInput<HttpContent> {
    private static final Map.Entry[] percentEncodings = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("\\*"), "%2A"), new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("\\+"), "%20"), new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("~"), "%7E")};
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isChunked;
    private final List<InterfaceHttpData> bodyListDatas;
    final List<InterfaceHttpData> multipartHttpDatas;
    private final boolean isMultipart;
    String multipartDataBoundary;
    String multipartMixedBoundary;
    private boolean headerFinalized;
    private final EncoderMode encoderMode;
    private boolean isLastChunk;
    private boolean isLastChunkSent;
    private FileUpload currentFileUpload;
    private boolean duringMixedMode;
    private long globalBodySize;
    private long globalProgress;
    private ListIterator<InterfaceHttpData> iterator;
    private ByteBuf currentBuffer;
    private InterfaceHttpData currentData;
    private boolean isKey = true;

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestEncoder(HttpRequest request, boolean multipart) throws ErrorDataEncoderException {
        this(new DefaultHttpDataFactory(16384L), (HttpRequest)var1_1, (boolean)var2_2, HttpConstants.DEFAULT_CHARSET, EncoderMode.RFC1738);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart) throws ErrorDataEncoderException {
        this((HttpDataFactory)var1_1, (HttpRequest)var2_2, (boolean)var3_3, HttpConstants.DEFAULT_CHARSET, EncoderMode.RFC1738);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart, Charset charset, EncoderMode encoderMode) throws ErrorDataEncoderException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.request = (HttpRequest)ObjectUtil.checkNotNull((Object)request, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNull((Object)var1_1, (String)"factory");
        if (HttpMethod.TRACE.equals(var2_2.method())) {
            throw new ErrorDataEncoderException("Cannot create a Encoder if request is a TRACE");
        }
        this.bodyListDatas = new ArrayList<InterfaceHttpData>();
        this.isLastChunk = false;
        this.isLastChunkSent = false;
        this.isMultipart = var3_3;
        this.multipartHttpDatas = new ArrayList<InterfaceHttpData>();
        this.encoderMode = encoderMode;
        if (this.isMultipart) {
            this.initDataMultipart();
        }
    }

    public void cleanFiles() {
        this.factory.cleanRequestHttpData(this.request);
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private void initDataMultipart() {
        this.multipartDataBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private void initMixedMultipart() {
        this.multipartMixedBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private static String getNewMultipartDelimiter() {
        return Long.toHexString(PlatformDependent.threadLocalRandom().nextLong());
    }

    public List<InterfaceHttpData> getBodyListAttributes() {
        return this.bodyListDatas;
    }

    /*
     * WARNING - void declaration
     */
    public void setBodyHttpDatas(List<InterfaceHttpData> datas) throws ErrorDataEncoderException {
        Iterator iterator;
        ObjectUtil.checkNotNull(datas, (String)"datas");
        this.globalBodySize = 0L;
        this.bodyListDatas.clear();
        this.currentFileUpload = null;
        this.duringMixedMode = false;
        this.multipartHttpDatas.clear();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            InterfaceHttpData data = (InterfaceHttpData)iterator.next();
            this.addBodyHttpData((InterfaceHttpData)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBodyAttribute(String name, String value) throws ErrorDataEncoderException {
        void var1_1;
        void var2_2;
        String svalue = value != null ? value : "";
        Attribute data = this.factory.createAttribute(this.request, (String)ObjectUtil.checkNotNull((Object)name, (String)"name"), (String)var2_2);
        this.addBodyHttpData((InterfaceHttpData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addBodyFileUpload(String name, File file, String contentType, boolean isText) throws ErrorDataEncoderException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addBodyFileUpload((String)var1_1, file.getName(), (File)var2_2, (String)var3_3, isText);
    }

    /*
     * WARNING - void declaration
     */
    public void addBodyFileUpload(String name, String filename, File file, String contentType, boolean isText) throws ErrorDataEncoderException {
        void var1_1;
        void var2_3;
        ObjectUtil.checkNotNull((Object)name, (String)"name");
        ObjectUtil.checkNotNull((Object)file, (String)"file");
        if (filename == null) {
            filename = "";
        }
        String scontentType = contentType;
        String contentTransferEncoding = null;
        if (contentType == null) {
            scontentType = isText ? "text/plain" : "application/octet-stream";
        }
        if (!isText) {
            contentTransferEncoding = HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value();
        }
        FileUpload fileUpload = this.factory.createFileUpload(this.request, name, (String)var2_3, scontentType, contentTransferEncoding, null, file.length());
        try {
            void var3_4;
            fileUpload.setContent((File)var3_4);
        }
        catch (IOException e) {
            void var1_2;
            throw new ErrorDataEncoderException((Throwable)var1_2);
        }
        this.addBodyHttpData((InterfaceHttpData)var1_1);
    }

    public void addBodyFileUploads(String name, File[] file, String[] contentType, boolean[] isText) throws ErrorDataEncoderException {
        if (file.length != contentType.length && file.length != isText.length) {
            throw new IllegalArgumentException("Different array length");
        }
        for (int i = 0; i < file.length; ++i) {
            this.addBodyFileUpload(name, file[i], contentType[i], isText[i]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addBodyHttpData(InterfaceHttpData data) throws ErrorDataEncoderException {
        block25: {
            block28: {
                block26: {
                    block27: {
                        if (this.headerFinalized) {
                            throw new ErrorDataEncoderException("Cannot add value once finalized");
                        }
                        this.bodyListDatas.add((InterfaceHttpData)ObjectUtil.checkNotNull((Object)data, (String)"data"));
                        if (!this.isMultipart) {
                            if (data instanceof Attribute) {
                                attribute = (Attribute)data;
                                try {
                                    key = this.encodeAttribute(attribute.getName(), this.charset);
                                    value = this.encodeAttribute(attribute.getValue(), this.charset);
                                    newattribute = this.factory.createAttribute(this.request, key, value);
                                    this.multipartHttpDatas.add(newattribute);
                                    this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
                                }
                                catch (IOException e) {
                                    throw new ErrorDataEncoderException(e);
                                }
                            } else if (data instanceof FileUpload) {
                                fileUpload = (FileUpload)data;
                                key = this.encodeAttribute(fileUpload.getName(), this.charset);
                                value = this.encodeAttribute(fileUpload.getFilename(), this.charset);
                                newattribute = this.factory.createAttribute(this.request, key, value);
                                this.multipartHttpDatas.add(newattribute);
                                this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
                            }
                            return;
                        }
                        if (data instanceof Attribute) {
                            if (this.duringMixedMode) {
                                internal = new InternalAttribute(this.charset);
                                internal.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                                this.multipartHttpDatas.add(internal);
                                this.multipartMixedBoundary = null;
                                this.currentFileUpload = null;
                                this.duringMixedMode = false;
                            }
                            internal = new InternalAttribute(this.charset);
                            if (!this.multipartHttpDatas.isEmpty()) {
                                internal.addValue("\r\n");
                            }
                            internal.addValue("--" + this.multipartDataBoundary + "\r\n");
                            attribute = (Attribute)data;
                            internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + attribute.getName() + "\"\r\n");
                            internal.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + attribute.length() + "\r\n");
                            localcharset = attribute.getCharset();
                            if (localcharset != null) {
                                internal.addValue(HttpHeaderNames.CONTENT_TYPE + ": text/plain" + "; " + HttpHeaderValues.CHARSET + '=' + localcharset.name() + "\r\n");
                            }
                            internal.addValue("\r\n");
                            this.multipartHttpDatas.add(internal);
                            this.multipartHttpDatas.add(data);
                            this.globalBodySize += attribute.length() + (long)internal.size();
                            return;
                        }
                        if (!(data instanceof FileUpload)) break block25;
                        fileUpload = (FileUpload)data;
                        internal = new InternalAttribute(this.charset);
                        if (!this.multipartHttpDatas.isEmpty()) {
                            internal.addValue("\r\n");
                        }
                        if (!this.duringMixedMode) break block26;
                        if (this.currentFileUpload == null || !this.currentFileUpload.getName().equals(fileUpload.getName())) break block27;
                        localMixed = true;
                        break block28;
                    }
                    internal.addValue("--" + this.multipartMixedBoundary + "--");
                    this.multipartHttpDatas.add(internal);
                    this.multipartMixedBoundary = null;
                    internal = new InternalAttribute(this.charset);
                    internal.addValue("\r\n");
                    ** GOTO lbl-1000
                }
                if (this.encoderMode != EncoderMode.HTML5 && this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                    this.initMixedMultipart();
                    pastAttribute = (InternalAttribute)this.multipartHttpDatas.get(this.multipartHttpDatas.size() - 2);
                    this.globalBodySize -= (long)pastAttribute.size();
                    replacement = new StringBuilder(139 + this.multipartDataBoundary.length() + (this.multipartMixedBoundary.length() << 1) + fileUpload.getFilename().length() + fileUpload.getName().length()).append("--").append(this.multipartDataBoundary).append("\r\n").append((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append((CharSequence)HttpHeaderValues.FORM_DATA).append("; ").append((CharSequence)HttpHeaderValues.NAME).append("=\"").append(fileUpload.getName()).append("\"\r\n").append((CharSequence)HttpHeaderNames.CONTENT_TYPE).append(": ").append((CharSequence)HttpHeaderValues.MULTIPART_MIXED).append("; ").append((CharSequence)HttpHeaderValues.BOUNDARY).append('=').append(this.multipartMixedBoundary).append("\r\n\r\n--").append(this.multipartMixedBoundary).append("\r\n").append((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append((CharSequence)HttpHeaderValues.ATTACHMENT);
                    if (!fileUpload.getFilename().isEmpty()) {
                        replacement.append("; ").append((CharSequence)HttpHeaderValues.FILENAME).append("=\"").append(this.currentFileUpload.getFilename()).append('\"');
                    }
                    replacement.append("\r\n");
                    pastAttribute.setValue(replacement.toString(), 1);
                    pastAttribute.setValue("", 2);
                    this.globalBodySize += (long)pastAttribute.size();
                    localMixed = true;
                    this.duringMixedMode = true;
                } else lbl-1000:
                // 2 sources

                {
                    localMixed = false;
                    this.currentFileUpload = fileUpload;
                    this.duringMixedMode = false;
                }
            }
            if (localMixed) {
                internal.addValue("--" + this.multipartMixedBoundary + "\r\n");
                if (fileUpload.getFilename().isEmpty()) {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + "\r\n");
                } else {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + "; " + HttpHeaderValues.FILENAME + "=\"" + fileUpload.getFilename() + "\"\r\n");
                }
            } else {
                internal.addValue("--" + this.multipartDataBoundary + "\r\n");
                if (fileUpload.getFilename().isEmpty()) {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + fileUpload.getName() + "\"\r\n");
                } else {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + fileUpload.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + fileUpload.getFilename() + "\"\r\n");
                }
            }
            internal.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + fileUpload.length() + "\r\n");
            internal.addValue(HttpHeaderNames.CONTENT_TYPE + ": " + fileUpload.getContentType());
            contentTransferEncoding = fileUpload.getContentTransferEncoding();
            if (contentTransferEncoding != null && contentTransferEncoding.equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value())) {
                internal.addValue("\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": " + HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value() + "\r\n\r\n");
            } else if (fileUpload.getCharset() != null) {
                internal.addValue("; " + HttpHeaderValues.CHARSET + '=' + fileUpload.getCharset().name() + "\r\n\r\n");
            } else {
                internal.addValue("\r\n\r\n");
            }
            this.multipartHttpDatas.add(internal);
            this.multipartHttpDatas.add((InterfaceHttpData)var1_1);
            this.globalBodySize += var2_5.length() + (long)var3_10.size();
        }
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest finalizeRequest() throws ErrorDataEncoderException {
        void var2_2;
        if (!this.headerFinalized) {
            if (this.isMultipart) {
                InternalAttribute internal = new InternalAttribute(this.charset);
                if (this.duringMixedMode) {
                    internal.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                }
                internal.addValue("\r\n--" + this.multipartDataBoundary + "--\r\n");
                this.multipartHttpDatas.add(internal);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
                this.globalBodySize += (long)internal.size();
            }
        } else {
            throw new ErrorDataEncoderException("Header already encoded");
        }
        this.headerFinalized = true;
        HttpHeaders headers = this.request.headers();
        List<String> contentTypes = headers.getAll((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        List<String> list = headers.getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (contentTypes != null) {
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            for (String contentType : contentTypes) {
                String lowercased = contentType.toLowerCase();
                if (lowercased.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || lowercased.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) continue;
                headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
            }
        }
        if (this.isMultipart) {
            String value = HttpHeaderValues.MULTIPART_FORM_DATA + "; " + HttpHeaderValues.BOUNDARY + '=' + this.multipartDataBoundary;
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)value);
        } else {
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
        }
        long realSize = this.globalBodySize;
        if (!this.isMultipart) {
            --realSize;
        }
        this.iterator = this.multipartHttpDatas.listIterator();
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(realSize));
        if (realSize > 8096L || this.isMultipart) {
            this.isChunked = true;
            if (list != null) {
                headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                for (CharSequence charSequence : list) {
                    if (HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
                    headers.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)charSequence);
                }
            }
            HttpUtil.setTransferEncodingChunked(this.request, true);
            return new WrappedHttpRequest(this.request);
        }
        HttpContent chunk = this.nextChunk();
        if (this.request instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)this.request;
            ByteBuf chunkContent = chunk.content();
            if (fullHttpRequest.content() != chunkContent) {
                void var1_1;
                fullHttpRequest.content().clear().writeBytes(chunkContent);
                var1_1.release();
            }
            return fullHttpRequest;
        }
        return new WrappedFullHttpRequest(this.request, (HttpContent)var2_2);
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    /*
     * WARNING - void declaration
     */
    private String encodeAttribute(String s, Charset charset) throws ErrorDataEncoderException {
        if (s == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(s, charset.name());
            if (this.encoderMode == EncoderMode.RFC3986) {
                Map.Entry[] entryArray = percentEncodings;
                int n = percentEncodings.length;
                for (int i = 0; i < n; ++i) {
                    Map.Entry entry = entryArray[i];
                    String replacement = (String)entry.getValue();
                    encoded = ((Pattern)entry.getKey()).matcher(encoded).replaceAll(replacement);
                }
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            void var1_2;
            void var2_3;
            throw new ErrorDataEncoderException(var2_3.name(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf fillByteBuf() {
        void var1_2;
        int n = this.currentBuffer.readableBytes();
        if (n > 8096) {
            return this.currentBuffer.readRetainedSlice(8096);
        }
        ByteBuf slice = this.currentBuffer;
        this.currentBuffer = null;
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private HttpContent encodeNextChunkMultipart(int sizeleft) throws ErrorDataEncoderException {
        void var1_2;
        ByteBuf buffer22;
        if (this.currentData == null) {
            return null;
        }
        if (this.currentData instanceof InternalAttribute) {
            buffer22 = ((InternalAttribute)this.currentData).toByteBuf();
            this.currentData = null;
        } else {
            try {
                void buffer22;
                buffer22 = ((HttpData)this.currentData).getChunk((int)buffer22);
            }
            catch (IOException e) {
                throw new ErrorDataEncoderException(e);
            }
            if (buffer22.capacity() == 0) {
                this.currentData = null;
                return null;
            }
        }
        this.currentBuffer = this.currentBuffer == null ? buffer22 : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer22});
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            return null;
        }
        buffer22 = this.fillByteBuf();
        return new DefaultHttpContent((ByteBuf)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private HttpContent encodeNextChunkUrlEncoded(int sizeleft) throws ErrorDataEncoderException {
        void var2_4;
        void var1_1;
        ByteBuf buffer;
        String string;
        if (this.currentData == null) {
            return null;
        }
        if (this.isKey) {
            string = this.currentData.getName();
            buffer = Unpooled.wrappedBuffer((byte[])string.getBytes(this.charset));
            this.isKey = false;
            this.currentBuffer = this.currentBuffer == null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, Unpooled.wrappedBuffer((byte[])"=".getBytes(this.charset))}) : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer, Unpooled.wrappedBuffer((byte[])"=".getBytes(this.charset))});
            size -= buffer.readableBytes() + 1;
            if (this.currentBuffer.readableBytes() >= 8096) {
                buffer = this.fillByteBuf();
                return new DefaultHttpContent(buffer);
            }
        }
        try {
            void size;
            buffer = ((HttpData)this.currentData).getChunk((int)size);
        }
        catch (IOException e) {
            throw new ErrorDataEncoderException(e);
        }
        ByteBuf delimiter = null;
        if (buffer.readableBytes() < var1_1) {
            this.isKey = true;
            ByteBuf byteBuf = delimiter = this.iterator.hasNext() ? Unpooled.wrappedBuffer((byte[])"&".getBytes(this.charset)) : null;
        }
        if (buffer.capacity() == 0) {
            this.currentData = null;
            if (this.currentBuffer == null) {
                if (delimiter == null) {
                    return null;
                }
                this.currentBuffer = delimiter;
            } else if (delimiter != null) {
                this.currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, delimiter});
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                buffer = this.fillByteBuf();
                return new DefaultHttpContent(buffer);
            }
            return null;
        }
        this.currentBuffer = this.currentBuffer == null ? (delimiter != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, delimiter}) : buffer) : (delimiter != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer, string}) : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer}));
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            this.isKey = true;
            return null;
        }
        buffer = this.fillByteBuf();
        return new DefaultHttpContent((ByteBuf)var2_4);
    }

    public void close() throws Exception {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        return this.readChunk(var1_1.alloc());
    }

    /*
     * WARNING - void declaration
     */
    public HttpContent readChunk(ByteBufAllocator allocator) throws Exception {
        void var1_1;
        if (this.isLastChunkSent) {
            return null;
        }
        HttpContent nextChunk = this.nextChunk();
        this.globalProgress += (long)nextChunk.content().readableBytes();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HttpContent nextChunk() throws ErrorDataEncoderException {
        int chunk32;
        if (this.isLastChunk) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        int size = this.calculateRemainingSize();
        if (size <= 0) {
            ByteBuf buffer = this.fillByteBuf();
            return new DefaultHttpContent(buffer);
        }
        if (this.currentData != null) {
            void buffer;
            HttpContent chunk32 = this.isMultipart ? this.encodeNextChunkMultipart((int)buffer) : this.encodeNextChunkUrlEncoded(chunk32);
            if (chunk32 != null) {
                return chunk32;
            }
            chunk32 = this.calculateRemainingSize();
        }
        if (!this.iterator.hasNext()) {
            return this.lastChunk();
        }
        while (chunk32 > 0 && this.iterator.hasNext()) {
            void var1_4;
            this.currentData = this.iterator.next();
            HttpContent chunk = this.isMultipart ? this.encodeNextChunkMultipart(chunk32) : this.encodeNextChunkUrlEncoded(chunk32);
            if (chunk == null) {
                chunk32 = this.calculateRemainingSize();
                continue;
            }
            return var1_4;
        }
        return this.lastChunk();
    }

    /*
     * WARNING - void declaration
     */
    private int calculateRemainingSize() {
        void var1_1;
        int size = 8096;
        if (this.currentBuffer != null) {
            size = 8096 - this.currentBuffer.readableBytes();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HttpContent lastChunk() {
        void var1_1;
        this.isLastChunk = true;
        if (this.currentBuffer == null) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        ByteBuf buffer = this.currentBuffer;
        this.currentBuffer = null;
        return new DefaultHttpContent((ByteBuf)var1_1);
    }

    public boolean isEndOfInput() throws Exception {
        return this.isLastChunkSent;
    }

    public long length() {
        if (this.isMultipart) {
            return this.globalBodySize;
        }
        return this.globalBodySize - 1L;
    }

    public long progress() {
        return this.globalProgress;
    }

    private static final class WrappedFullHttpRequest
    extends WrappedHttpRequest
    implements FullHttpRequest {
        private final HttpContent content;

        /*
         * WARNING - void declaration
         */
        private WrappedFullHttpRequest(HttpRequest request, HttpContent content) {
            super((HttpRequest)var1_1);
            void var2_2;
            void var1_1;
            this.content = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest setProtocolVersion(HttpVersion version) {
            void var1_1;
            super.setProtocolVersion((HttpVersion)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest setMethod(HttpMethod method) {
            void var1_1;
            super.setMethod((HttpMethod)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest setUri(String uri) {
            void var1_1;
            super.setUri((String)var1_1);
            return this;
        }

        @Override
        public final FullHttpRequest copy() {
            WrappedFullHttpRequest wrappedFullHttpRequest = this;
            return wrappedFullHttpRequest.replace(wrappedFullHttpRequest.content().copy());
        }

        @Override
        public final FullHttpRequest duplicate() {
            WrappedFullHttpRequest wrappedFullHttpRequest = this;
            return wrappedFullHttpRequest.replace(wrappedFullHttpRequest.content().duplicate());
        }

        @Override
        public final FullHttpRequest retainedDuplicate() {
            WrappedFullHttpRequest wrappedFullHttpRequest = this;
            return wrappedFullHttpRequest.replace(wrappedFullHttpRequest.content().retainedDuplicate());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest replace(ByteBuf content) {
            void var1_1;
            DefaultFullHttpRequest duplicate = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), content);
            duplicate.headers().set(this.headers());
            duplicate.trailingHeaders().set(this.trailingHeaders());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest retain(int increment) {
            void var1_1;
            this.content.retain((int)var1_1);
            return this;
        }

        @Override
        public final FullHttpRequest retain() {
            this.content.retain();
            return this;
        }

        @Override
        public final FullHttpRequest touch() {
            this.content.touch();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final FullHttpRequest touch(Object hint) {
            void var1_1;
            this.content.touch(var1_1);
            return this;
        }

        public final ByteBuf content() {
            return this.content.content();
        }

        @Override
        public final HttpHeaders trailingHeaders() {
            if (this.content instanceof LastHttpContent) {
                return ((LastHttpContent)this.content).trailingHeaders();
            }
            return EmptyHttpHeaders.INSTANCE;
        }

        public final int refCnt() {
            return this.content.refCnt();
        }

        public final boolean release() {
            return this.content.release();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean release(int decrement) {
            void var1_1;
            return this.content.release((int)var1_1);
        }
    }

    private static class WrappedHttpRequest
    implements HttpRequest {
        private final HttpRequest request;

        /*
         * WARNING - void declaration
         */
        WrappedHttpRequest(HttpRequest request) {
            void var1_1;
            this.request = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public HttpRequest setProtocolVersion(HttpVersion version) {
            void var1_1;
            this.request.setProtocolVersion((HttpVersion)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public HttpRequest setMethod(HttpMethod method) {
            void var1_1;
            this.request.setMethod((HttpMethod)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public HttpRequest setUri(String uri) {
            void var1_1;
            this.request.setUri((String)var1_1);
            return this;
        }

        @Override
        public HttpMethod getMethod() {
            return this.request.method();
        }

        @Override
        public HttpMethod method() {
            return this.request.method();
        }

        @Override
        public String getUri() {
            return this.request.uri();
        }

        @Override
        public String uri() {
            return this.request.uri();
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.request.protocolVersion();
        }

        @Override
        public HttpVersion protocolVersion() {
            return this.request.protocolVersion();
        }

        @Override
        public HttpHeaders headers() {
            return this.request.headers();
        }

        public DecoderResult decoderResult() {
            return this.request.decoderResult();
        }

        @Override
        @Deprecated
        public DecoderResult getDecoderResult() {
            return this.request.getDecoderResult();
        }

        /*
         * WARNING - void declaration
         */
        public void setDecoderResult(DecoderResult result) {
            void var1_1;
            this.request.setDecoderResult((DecoderResult)var1_1);
        }
    }

    public static class ErrorDataEncoderException
    extends Exception {
        private static final long serialVersionUID = 5020247425493164465L;

        public ErrorDataEncoderException() {
        }

        /*
         * WARNING - void declaration
         */
        public ErrorDataEncoderException(String msg) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ErrorDataEncoderException(Throwable cause) {
            super((Throwable)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ErrorDataEncoderException(String msg, Throwable cause) {
            super((String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static enum EncoderMode {
        RFC1738,
        RFC3986,
        HTML5;

    }
}

