/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.List;

public class HttpPostRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    static final int DEFAULT_DISCARD_THRESHOLD = 0xA00000;
    static final int DEFAULT_MAX_FIELDS = 128;
    static final int DEFAULT_MAX_BUFFERED_BYTES = 1024;
    private final InterfaceHttpPostRequestDecoder decoder;

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestDecoder(HttpRequest request) {
        this(new DefaultHttpDataFactory(16384L), (HttpRequest)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestDecoder(HttpRequest request, int maxFields, int maxBufferedBytes) {
        this(new DefaultHttpDataFactory(16384L), (HttpRequest)var1_1, HttpConstants.DEFAULT_CHARSET, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestDecoder(HttpDataFactory factory, HttpRequest request) {
        this((HttpDataFactory)var1_1, (HttpRequest)var2_2, HttpConstants.DEFAULT_CHARSET);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)factory, (String)"factory");
        ObjectUtil.checkNotNull((Object)request, (String)"request");
        ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        if (HttpPostRequestDecoder.isMultipart(request)) {
            this.decoder = new HttpPostMultipartRequestDecoder(factory, request, charset);
            return;
        }
        this.decoder = new HttpPostStandardRequestDecoder((HttpDataFactory)var1_1, (HttpRequest)var2_2, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset, int maxFields, int maxBufferedBytes) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)factory, (String)"factory");
        ObjectUtil.checkNotNull((Object)request, (String)"request");
        ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        if (HttpPostRequestDecoder.isMultipart(request)) {
            this.decoder = new HttpPostMultipartRequestDecoder(factory, request, charset, maxFields, maxBufferedBytes);
            return;
        }
        this.decoder = new HttpPostStandardRequestDecoder((HttpDataFactory)var1_1, (HttpRequest)var2_2, (Charset)var3_3, maxFields, maxBufferedBytes);
    }

    public static boolean isMultipart(HttpRequest request) {
        String mimeType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (mimeType != null && mimeType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString())) {
            String string;
            return HttpPostRequestDecoder.getMultipartDataBoundary(string) != null;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static String[] getMultipartDataBoundary(String contentType) {
        String multiPartHeader;
        String[] headerContentType = HttpPostRequestDecoder.splitHeaderContentType(contentType);
        if (headerContentType[0].regionMatches(true, 0, multiPartHeader = HttpHeaderValues.MULTIPART_FORM_DATA.toString(), 0, multiPartHeader.length())) {
            void var1_3;
            void var2_4;
            String[] stringArray;
            String charset;
            void var3_5;
            String charsetHeader;
            int index;
            String bound;
            void mrank2;
            int crank;
            int mrank2;
            String boundaryHeader = HttpHeaderValues.BOUNDARY.toString();
            if (headerContentType[1].regionMatches(true, 0, boundaryHeader, 0, boundaryHeader.length())) {
                mrank2 = 1;
                crank = 2;
            } else if (headerContentType[2].regionMatches(true, 0, (String)mrank2, 0, mrank2.length())) {
                mrank2 = 2;
                crank = 1;
            } else {
                return null;
            }
            String boundary = StringUtil.substringAfter((String)headerContentType[mrank2], (char)'=');
            if (boundary == null) {
                throw new ErrorDataDecoderException("Needs a boundary value");
            }
            if (boundary.charAt(0) == '\"' && (bound = boundary.trim()).charAt(index = bound.length() - 1) == '\"') {
                boundary = bound.substring(1, index);
            }
            if (headerContentType[crank].regionMatches(true, 0, charsetHeader = HttpHeaderValues.CHARSET.toString(), 0, var3_5.length()) && (charset = StringUtil.substringAfter((String)stringArray[var2_4], (char)'=')) != null) {
                return new String[]{"--" + boundary, charset};
            }
            return new String[]{"--" + (String)var1_3};
        }
        return null;
    }

    @Override
    public boolean isMultipart() {
        return this.decoder.isMultipart();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDiscardThreshold(int discardThreshold) {
        void var1_1;
        this.decoder.setDiscardThreshold((int)var1_1);
    }

    @Override
    public int getDiscardThreshold() {
        return this.decoder.getDiscardThreshold();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        return this.decoder.getBodyHttpDatas();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String name) {
        void var1_1;
        return this.decoder.getBodyHttpDatas((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InterfaceHttpData getBodyHttpData(String name) {
        void var1_1;
        return this.decoder.getBodyHttpData((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InterfaceHttpPostRequestDecoder offer(HttpContent content) {
        void var1_1;
        return this.decoder.offer((HttpContent)var1_1);
    }

    @Override
    public boolean hasNext() {
        return this.decoder.hasNext();
    }

    @Override
    public InterfaceHttpData next() {
        return this.decoder.next();
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.decoder.currentPartialHttpData();
    }

    @Override
    public void destroy() {
        this.decoder.destroy();
    }

    @Override
    public void cleanFiles() {
        this.decoder.cleanFiles();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeHttpDataFromClean(InterfaceHttpData data) {
        void var1_1;
        this.decoder.removeHttpDataFromClean((InterfaceHttpData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitHeaderContentType(String sb) {
        String string;
        void var3_3;
        void var2_2;
        void var1_1;
        int bEnd;
        int aStart = HttpPostBodyUtil.findNonWhitespace(sb, 0);
        int aEnd = sb.indexOf(59);
        if (aEnd == -1) {
            return new String[]{sb, "", ""};
        }
        int bStart = HttpPostBodyUtil.findNonWhitespace(sb, aEnd + 1);
        if (sb.charAt(aEnd - 1) == ' ') {
            --aEnd;
        }
        if ((bEnd = sb.indexOf(59, bStart)) == -1) {
            bEnd = HttpPostBodyUtil.findEndOfString(sb);
            return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), ""};
        }
        int cStart = HttpPostBodyUtil.findNonWhitespace(sb, bEnd + 1);
        if (sb.charAt(bEnd - 1) == ' ') {
            --bEnd;
        }
        int cEnd = HttpPostBodyUtil.findEndOfString(sb);
        return new String[]{sb.substring((int)var1_1, (int)var2_2), sb.substring((int)var3_3, bEnd), string.substring(cStart, cEnd)};
    }

    public static final class TooLongFormFieldException
    extends DecoderException {
        private static final long serialVersionUID = 1336267941020800769L;
    }

    public static final class TooManyFormFieldsException
    extends DecoderException {
        private static final long serialVersionUID = 1336267941020800769L;
    }

    public static class ErrorDataDecoderException
    extends DecoderException {
        private static final long serialVersionUID = 5020247425493164465L;

        public ErrorDataDecoderException() {
        }

        /*
         * WARNING - void declaration
         */
        public ErrorDataDecoderException(String msg) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ErrorDataDecoderException(Throwable cause) {
            super((Throwable)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ErrorDataDecoderException(String msg, Throwable cause) {
            super((String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static class EndOfDataDecoderException
    extends DecoderException {
        private static final long serialVersionUID = 1336267941020800769L;
    }

    public static class NotEnoughDataDecoderException
    extends DecoderException {
        private static final long serialVersionUID = -7846841864603865638L;

        public NotEnoughDataDecoderException() {
        }

        /*
         * WARNING - void declaration
         */
        public NotEnoughDataDecoderException(String msg) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public NotEnoughDataDecoderException(Throwable cause) {
            super((Throwable)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public NotEnoughDataDecoderException(String msg, Throwable cause) {
            super((String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    protected static enum MultiPartStatus {
        NOTSTARTED,
        PREAMBLE,
        HEADERDELIMITER,
        DISPOSITION,
        FIELD,
        FILEUPLOAD,
        MIXEDPREAMBLE,
        MIXEDDELIMITER,
        MIXEDDISPOSITION,
        MIXEDFILEUPLOAD,
        MIXEDCLOSEDELIMITER,
        CLOSEDELIMITER,
        PREEPILOGUE,
        EPILOGUE;

    }
}

