/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostMultipartRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final int maxFields;
    private final int maxBufferedBytes;
    private Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private final String multipartDataBoundary;
    private String multipartMixedBoundary;
    private HttpPostRequestDecoder.MultiPartStatus currentStatus = HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED;
    private Map<CharSequence, Attribute> currentFieldAttributes;
    private FileUpload currentFileUpload;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;
    private static final String FILENAME_ENCODED = HttpHeaderValues.FILENAME.toString() + '*';

    /*
     * WARNING - void declaration
     */
    public HttpPostMultipartRequestDecoder(HttpRequest request) {
        this(new DefaultHttpDataFactory(16384L), (HttpRequest)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostMultipartRequestDecoder(HttpDataFactory factory, HttpRequest request) {
        this((HttpDataFactory)var1_1, (HttpRequest)var2_2, HttpConstants.DEFAULT_CHARSET);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostMultipartRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset) {
        this((HttpDataFactory)var1_1, (HttpRequest)var2_2, (Charset)var3_3, 128, 1024);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpPostMultipartRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset, int maxFields, int maxBufferedBytes) {
        void var3_5;
        this.request = (HttpRequest)ObjectUtil.checkNotNull((Object)request, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)var3_5, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNull((Object)factory, (String)"factory");
        this.maxFields = maxFields;
        this.maxBufferedBytes = maxBufferedBytes;
        String contentTypeValue = this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue == null) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException("No '" + HttpHeaderNames.CONTENT_TYPE + "' header present.");
        }
        String[] dataBoundary = HttpPostRequestDecoder.getMultipartDataBoundary(contentTypeValue);
        if (dataBoundary != null) {
            this.multipartDataBoundary = dataBoundary[0];
            if (dataBoundary.length > 1 && dataBoundary[1] != null) {
                try {
                    this.charset = Charset.forName(dataBoundary[1]);
                }
                catch (IllegalCharsetNameException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
            }
        } else {
            this.multipartDataBoundary = null;
        }
        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
        try {
            void var2_4;
            if (!(request instanceof HttpContent)) {
                this.parseBody();
                return;
            }
            this.offer((HttpContent)var2_4);
        }
        catch (Throwable e) {
            void var1_3;
            this.destroy();
            PlatformDependent.throwException((Throwable)var1_3);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostMultipartRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDiscardThreshold(int discardThreshold) {
        void var1_1;
        this.discardThreshold = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String name) {
        void var1_1;
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InterfaceHttpData getBodyHttpData(String name) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(name);
        if (list != null) {
            void var1_1;
            return (InterfaceHttpData)var1_1.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpPostMultipartRequestDecoder offer(HttpContent content) {
        this.checkDestroyed();
        if (content instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        ByteBuf buf = content.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = buf.alloc().buffer(buf.readableBytes()).writeBytes(buf);
        } else {
            this.undecodedChunk.writeBytes(buf);
        }
        this.parseBody();
        if (this.maxBufferedBytes > 0 && this.undecodedChunk != null && this.undecodedChunk.readableBytes() > this.maxBufferedBytes) {
            throw new HttpPostRequestDecoder.TooLongFormFieldException();
        }
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            if (this.undecodedChunk.refCnt() == 1) {
                this.undecodedChunk.discardReadBytes();
            } else {
                void var1_1;
                ByteBuf buffer = this.undecodedChunk.alloc().buffer(this.undecodedChunk.readableBytes());
                buffer.writeBytes(this.undecodedChunk);
                this.undecodedChunk.release();
                this.undecodedChunk = var1_1;
            }
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder.EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        if (this.currentFileUpload != null) {
            return this.currentFileUpload;
        }
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyMultipart();
    }

    /*
     * WARNING - void declaration
     */
    protected void addHttpData(InterfaceHttpData data) {
        void var1_1;
        void var2_2;
        if (data == null) {
            return;
        }
        if (this.maxFields > 0 && this.bodyListHttpData.size() >= this.maxFields) {
            throw new HttpPostRequestDecoder.TooManyFormFieldsException();
        }
        List<InterfaceHttpData> datas = this.bodyMapHttpData.get(data.getName());
        if (datas == null) {
            datas = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(data.getName(), datas);
        }
        var2_2.add(data);
        this.bodyListHttpData.add((InterfaceHttpData)var1_1);
    }

    private void parseBodyMultipart() {
        if (this.undecodedChunk == null || this.undecodedChunk.readableBytes() == 0) {
            return;
        }
        HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
        InterfaceHttpData data = httpPostMultipartRequestDecoder.decodeMultipart(httpPostMultipartRequestDecoder.currentStatus);
        while (data != null) {
            this.addHttpData(data);
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) break;
            HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder2 = this;
            data = httpPostMultipartRequestDecoder2.decodeMultipart(httpPostMultipartRequestDecoder2.currentStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    private InterfaceHttpData decodeMultipart(HttpPostRequestDecoder.MultiPartStatus state) {
        switch (state) {
            case NOTSTARTED: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case PREAMBLE: {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case HEADERDELIMITER: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.findMultipartDelimiter(httpPostMultipartRequestDecoder.multipartDataBoundary, HttpPostRequestDecoder.MultiPartStatus.DISPOSITION, HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE);
            }
            case DISPOSITION: {
                return this.findMultipartDisposition();
            }
            case FIELD: {
                void var3_9;
                Charset localCharset = null;
                Attribute charsetAttribute = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET);
                if (charsetAttribute != null) {
                    try {
                        localCharset = Charset.forName(charsetAttribute.getValue());
                    }
                    catch (IOException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                }
                Attribute nameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
                if (this.currentAttribute == null) {
                    void var1_1;
                    long size;
                    Attribute lengthAttribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
                    try {
                        size = lengthAttribute != null ? Long.parseLong(lengthAttribute.getValue()) : 0L;
                    }
                    catch (IOException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (NumberFormatException numberFormatException) {
                        size = 0L;
                    }
                    try {
                        void var2_6;
                        this.currentAttribute = size > 0L ? this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(nameAttribute.getValue()), size) : this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(var2_6.getValue()));
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IOException e) {
                        void var1_5;
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException((Throwable)var1_5);
                    }
                    if (var1_1 != null) {
                        this.currentAttribute.setCharset((Charset)var1_1);
                    }
                }
                if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, this.multipartDataBoundary, this.currentAttribute)) {
                    return null;
                }
                Attribute finalAttribute = this.currentAttribute;
                this.currentAttribute = null;
                this.currentFieldAttributes = null;
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                return var3_9;
            }
            case FILEUPLOAD: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.getFileUpload(httpPostMultipartRequestDecoder.multipartDataBoundary);
            }
            case MIXEDDELIMITER: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.findMultipartDelimiter(httpPostMultipartRequestDecoder.multipartMixedBoundary, HttpPostRequestDecoder.MultiPartStatus.MIXEDDISPOSITION, HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            case MIXEDDISPOSITION: {
                return this.findMultipartDisposition();
            }
            case MIXEDFILEUPLOAD: {
                HttpPostMultipartRequestDecoder httpPostMultipartRequestDecoder = this;
                return httpPostMultipartRequestDecoder.getFileUpload(httpPostMultipartRequestDecoder.multipartMixedBoundary);
            }
            case PREEPILOGUE: {
                return null;
            }
            case EPILOGUE: {
                return null;
            }
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Shouldn't reach here.");
    }

    /*
     * WARNING - void declaration
     */
    private static void skipControlCharacters(ByteBuf undecodedChunk) {
        HttpPostBodyUtil.SeekAheadOptimize e12;
        if (!undecodedChunk.hasArray()) {
            try {
                HttpPostMultipartRequestDecoder.skipControlCharactersStandard(undecodedChunk);
                return;
            }
            catch (IndexOutOfBoundsException e12) {
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(e12);
            }
        }
        HttpPostBodyUtil.SeekAheadOptimize sao = new HttpPostBodyUtil.SeekAheadOptimize((ByteBuf)e12);
        while (sao.pos < sao.limit) {
            void var1_2;
            char c;
            if (Character.isISOControl(c = (char)(sao.bytes[sao.pos++] & 0xFF)) || Character.isWhitespace((char)var1_2)) continue;
            sao.setReadPosition(1);
            return;
        }
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException("Access out of bounds");
    }

    /*
     * WARNING - void declaration
     */
    private static void skipControlCharactersStandard(ByteBuf undecodedChunk) {
        void var1_1;
        char c;
        while (Character.isISOControl(c = (char)undecodedChunk.readUnsignedByte()) || Character.isWhitespace((char)var1_1)) {
        }
        ByteBuf byteBuf = undecodedChunk;
        byteBuf.readerIndex(byteBuf.readerIndex() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private InterfaceHttpData findMultipartDelimiter(String delimiter, HttpPostRequestDecoder.MultiPartStatus dispositionStatus, HttpPostRequestDecoder.MultiPartStatus closeDelimiterStatus) {
        void var1_1;
        String newline;
        int readerIndex = this.undecodedChunk.readerIndex();
        try {
            HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(readerIndex);
            return null;
        }
        this.skipOneLine();
        try {
            newline = HttpPostMultipartRequestDecoder.readDelimiterOptimized(this.undecodedChunk, delimiter, this.charset);
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(readerIndex);
            return null;
        }
        if (newline.equals(delimiter)) {
            void var2_2;
            this.currentStatus = dispositionStatus;
            return this.decodeMultipart((HttpPostRequestDecoder.MultiPartStatus)var2_2);
        }
        if (newline.equals((String)var1_1 + "--")) {
            void var3_3;
            this.currentStatus = var3_3;
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER) {
                this.currentFieldAttributes = null;
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER);
            }
            return null;
        }
        this.undecodedChunk.readerIndex(readerIndex);
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("No Multipart delimiter found");
    }

    /*
     * WARNING - void declaration
     */
    private InterfaceHttpData findMultipartDisposition() {
        void var2_4;
        int readerIndex = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            this.currentFieldAttributes = new TreeMap<CharSequence, Attribute>(CaseIgnoringComparator.INSTANCE);
        }
        while (!this.skipOneLine()) {
            Attribute attribute;
            Object values;
            String newline;
            try {
                HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
                newline = HttpPostMultipartRequestDecoder.readLineOptimized(this.undecodedChunk, this.charset);
            }
            catch (HttpPostRequestDecoder.NotEnoughDataDecoderException notEnoughDataDecoderException) {
                this.undecodedChunk.readerIndex(readerIndex);
                return null;
            }
            String[] contents = HttpPostMultipartRequestDecoder.splitMultipartHeader(newline);
            if (HttpHeaderNames.CONTENT_DISPOSITION.contentEqualsIgnoreCase((CharSequence)contents[0])) {
                boolean bl;
                if (!(this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION ? HttpHeaderValues.FORM_DATA.contentEqualsIgnoreCase((CharSequence)contents[1]) : (bl = HttpHeaderValues.ATTACHMENT.contentEqualsIgnoreCase((CharSequence)contents[1]) || HttpHeaderValues.FILE.contentEqualsIgnoreCase((CharSequence)contents[1])))) continue;
                int i = 2;
                while (i < contents.length) {
                    values = contents[i].split("=", 2);
                    try {
                        attribute = this.getContentDispositionAttribute((String)values);
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    this.currentFieldAttributes.put(attribute.getName(), attribute);
                    ++e;
                }
                continue;
            }
            if (HttpHeaderNames.CONTENT_TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)contents[0])) {
                Attribute attribute2;
                try {
                    attribute2 = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_TRANSFER_ENCODING.toString(), HttpPostMultipartRequestDecoder.cleanString(contents[1]));
                }
                catch (NullPointerException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                this.currentFieldAttributes.put((CharSequence)HttpHeaderNames.CONTENT_TRANSFER_ENCODING, attribute2);
                continue;
            }
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)contents[0])) {
                Attribute attribute3;
                try {
                    attribute3 = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_LENGTH.toString(), HttpPostMultipartRequestDecoder.cleanString(contents[1]));
                }
                catch (NullPointerException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                this.currentFieldAttributes.put((CharSequence)HttpHeaderNames.CONTENT_LENGTH, attribute3);
                continue;
            }
            if (!HttpHeaderNames.CONTENT_TYPE.contentEqualsIgnoreCase((CharSequence)contents[0])) continue;
            if (HttpHeaderValues.MULTIPART_MIXED.contentEqualsIgnoreCase((CharSequence)contents[1])) {
                if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
                    String values2 = StringUtil.substringAfter((String)contents[2], (char)'=');
                    this.multipartMixedBoundary = "--" + values2;
                    this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                    return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER);
                }
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("Mixed Multipart found in a previous Mixed Multipart");
            }
            for (int i = 1; i < contents.length; ++i) {
                Attribute attribute4;
                String charsetHeader = HttpHeaderValues.CHARSET.toString();
                if (contents[i].regionMatches(true, 0, charsetHeader, 0, charsetHeader.length())) {
                    values = StringUtil.substringAfter((String)contents[i], (char)'=');
                    try {
                        attribute = this.factory.createAttribute(this.request, charsetHeader, HttpPostMultipartRequestDecoder.cleanString((String)values));
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    this.currentFieldAttributes.put((CharSequence)HttpHeaderValues.CHARSET, attribute);
                    continue;
                }
                if (contents[i].contains("=")) {
                    Attribute attribute5;
                    String name = StringUtil.substringBefore((String)contents[i], (char)'=');
                    String values3 = StringUtil.substringAfter((String)contents[i], (char)'=');
                    try {
                        attribute5 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(name), values3);
                    }
                    catch (NullPointerException e) {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                    }
                    catch (IllegalArgumentException e) {
                        void var1_3;
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException((Throwable)var1_3);
                    }
                    this.currentFieldAttributes.put(name, attribute5);
                    continue;
                }
                try {
                    attribute4 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(contents[0]), contents[i]);
                }
                catch (NullPointerException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
                }
                this.currentFieldAttributes.put(attribute4.getName(), attribute4);
            }
        }
        Attribute filenameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.DISPOSITION) {
            if (filenameAttribute != null) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD;
                return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD);
            }
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FIELD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.FIELD);
        }
        if (var2_4 != null) {
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD;
            return this.decodeMultipart(HttpPostRequestDecoder.MultiPartStatus.MIXEDFILEUPLOAD);
        }
        throw new HttpPostRequestDecoder.ErrorDataDecoderException("Filename not found");
    }

    /*
     * WARNING - void declaration
     */
    private Attribute getContentDispositionAttribute(String ... values) {
        void var1_1;
        void var2_2;
        String name = HttpPostMultipartRequestDecoder.cleanString(values[0]);
        String value = values[1];
        if (HttpHeaderValues.FILENAME.contentEquals((CharSequence)name)) {
            int last = value.length() - 1;
            if (last > 0 && value.charAt(0) == '\"' && value.charAt(last) == '\"') {
                value = value.substring(1, last);
            }
        } else if (FILENAME_ENCODED.equals(name)) {
            try {
                name = HttpHeaderValues.FILENAME.toString();
                String[] split = HttpPostMultipartRequestDecoder.cleanString(value).split("'", 3);
                value = QueryStringDecoder.decodeComponent(split[2], Charset.forName(split[0]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (UnsupportedCharsetException e) {
                void var3_6;
                throw new HttpPostRequestDecoder.ErrorDataDecoderException((Throwable)var3_6);
            }
        } else {
            value = HttpPostMultipartRequestDecoder.cleanString(value);
        }
        return this.factory.createAttribute(this.request, (String)var2_2, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected InterfaceHttpData getFileUpload(String delimiter) {
        void var1_1;
        Attribute charsetAttribute;
        Attribute encoding = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        Charset localCharset = this.charset;
        HttpPostBodyUtil.TransferEncodingMechanism mechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT7;
        if (encoding != null) {
            String code;
            try {
                code = encoding.getValue().toLowerCase();
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            if (code.equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT7.value())) {
                localCharset = CharsetUtil.US_ASCII;
            } else if (code.equals(HttpPostBodyUtil.TransferEncodingMechanism.BIT8.value())) {
                localCharset = CharsetUtil.ISO_8859_1;
                mechanism = HttpPostBodyUtil.TransferEncodingMechanism.BIT8;
            } else if (code.equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value())) {
                mechanism = HttpPostBodyUtil.TransferEncodingMechanism.BINARY;
            } else {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException("TransferEncoding Unknown: " + code);
            }
        }
        if ((charsetAttribute = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET)) != null) {
            try {
                localCharset = Charset.forName(charsetAttribute.getValue());
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (UnsupportedCharsetException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
        }
        if (this.currentFileUpload == null) {
            long size;
            Attribute filenameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
            Attribute nameAttribute = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
            Attribute contentTypeAttribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TYPE);
            Attribute lengthAttribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
            try {
                size = lengthAttribute != null ? Long.parseLong(lengthAttribute.getValue()) : 0L;
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (NumberFormatException numberFormatException) {
                size = 0L;
            }
            try {
                void var3_6;
                String contentType = e != null ? e.getValue() : "application/octet-stream";
                this.currentFileUpload = this.factory.createFileUpload(this.request, HttpPostMultipartRequestDecoder.cleanString(nameAttribute.getValue()), HttpPostMultipartRequestDecoder.cleanString(filenameAttribute.getValue()), contentType, mechanism.value(), (Charset)var3_6, size);
            }
            catch (NullPointerException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (IllegalArgumentException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
            catch (IOException e) {
                throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
            }
        }
        if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, (String)var1_1, this.currentFileUpload)) {
            return null;
        }
        if (this.currentFileUpload.isCompleted()) {
            void var2_2;
            if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.FILEUPLOAD) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.HEADERDELIMITER;
                this.currentFieldAttributes = null;
            } else {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.MIXEDDELIMITER;
                this.cleanMixedAttributes();
            }
            FileUpload fileUpload = this.currentFileUpload;
            this.currentFileUpload = null;
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData httpData : this.bodyListHttpData) {
            void var2_2;
            if (httpData.refCnt() <= 0) continue;
            var2_2.release();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeHttpDataFromClean(InterfaceHttpData data) {
        void var1_1;
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, (InterfaceHttpData)var1_1);
    }

    private void cleanMixedAttributes() {
        this.currentFieldAttributes.remove(HttpHeaderValues.CHARSET);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_LENGTH);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TYPE);
        this.currentFieldAttributes.remove(HttpHeaderValues.FILENAME);
    }

    /*
     * WARNING - void declaration
     */
    private static String readLineOptimized(ByteBuf undecodedChunk, Charset charset) {
        void var2_3;
        ByteBuf byteBuf;
        block7: {
            String string;
            int readerIndex = undecodedChunk.readerIndex();
            ByteBuf line = null;
            if (!undecodedChunk.isReadable()) break block7;
            ByteBuf byteBuf2 = undecodedChunk;
            int posLfOrCrLf = HttpPostBodyUtil.findLineBreak(byteBuf2, byteBuf2.readerIndex());
            if (posLfOrCrLf <= 0) {
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            try {
                line = undecodedChunk.alloc().heapBuffer(posLfOrCrLf);
                line.writeBytes(undecodedChunk, posLfOrCrLf);
                byte by = undecodedChunk.readByte();
                posLfOrCrLf = by;
                if (by == 13) {
                    undecodedChunk.readByte();
                }
                string = line.toString((Charset)((Object)string));
            }
            catch (Throwable throwable) {
                try {
                    void var3_4;
                    var3_4.release();
                    throw throwable;
                }
                catch (IndexOutOfBoundsException e) {
                    undecodedChunk.readerIndex(readerIndex);
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException(e);
                }
            }
            line.release();
            return string;
        }
        byteBuf.readerIndex((int)var2_3);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    /*
     * WARNING - void declaration
     */
    private static String readDelimiterOptimized(ByteBuf undecodedChunk, String delimiter, Charset charset) {
        void var3_5;
        ByteBuf byteBuf;
        int readerIndex = undecodedChunk.readerIndex();
        byte[] bdelimiter = delimiter.getBytes(charset);
        int delimiterLength = bdelimiter.length;
        try {
            int delimiterPos = HttpPostBodyUtil.findDelimiter(undecodedChunk, readerIndex, bdelimiter, false);
            if (delimiterPos < 0) {
                undecodedChunk.readerIndex(readerIndex);
                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
            }
            StringBuilder sb = new StringBuilder(delimiter);
            undecodedChunk.readerIndex(readerIndex + delimiterPos + delimiterLength);
            if (undecodedChunk.isReadable()) {
                byte nextByte = undecodedChunk.readByte();
                if (nextByte == 13) {
                    nextByte = undecodedChunk.readByte();
                    if (nextByte == 10) {
                        return sb.toString();
                    }
                    undecodedChunk.readerIndex(readerIndex);
                    throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                }
                if (nextByte == 10) {
                    return sb.toString();
                }
                if (nextByte == 45) {
                    sb.append('-');
                    nextByte = undecodedChunk.readByte();
                    if (nextByte == 45) {
                        void var1_1;
                        sb.append('-');
                        if (undecodedChunk.isReadable()) {
                            nextByte = undecodedChunk.readByte();
                            if (nextByte == 13) {
                                nextByte = undecodedChunk.readByte();
                                if (nextByte == 10) {
                                    return sb.toString();
                                }
                                undecodedChunk.readerIndex(readerIndex);
                                throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
                            }
                            if (nextByte == 10) {
                                return sb.toString();
                            }
                            ByteBuf byteBuf2 = undecodedChunk;
                            byteBuf2.readerIndex(byteBuf2.readerIndex() - 1);
                            return sb.toString();
                        }
                        return var1_1.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            void var2_4;
            undecodedChunk.readerIndex(readerIndex);
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException((Throwable)var2_4);
        }
        byteBuf.readerIndex((int)var3_5);
        throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
    }

    /*
     * WARNING - void declaration
     */
    private static void rewriteCurrentBuffer(ByteBuf buffer, int lengthToSkip) {
        void var1_1;
        void var3_3;
        void var2_2;
        ByteBuf byteBuf;
        if (lengthToSkip == 0) {
            return;
        }
        int readerIndex = buffer.readerIndex();
        int readableBytes = buffer.readableBytes();
        if (readableBytes == lengthToSkip) {
            buffer.readerIndex(readerIndex);
            buffer.writerIndex(readerIndex);
            return;
        }
        buffer.setBytes(readerIndex, buffer, readerIndex + lengthToSkip, readableBytes - lengthToSkip);
        buffer.readerIndex(readerIndex);
        byteBuf.writerIndex((int)(var2_2 + var3_3 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean loadDataMultipartOptimized(ByteBuf undecodedChunk, String delimiter, HttpData httpData) {
        void var3_9;
        ByteBuf byteBuf;
        byte[] bdelimiter;
        if (!undecodedChunk.isReadable()) {
            return false;
        }
        int startReaderIndex = undecodedChunk.readerIndex();
        int posDelimiter = HttpPostBodyUtil.findDelimiter(undecodedChunk, startReaderIndex, bdelimiter = delimiter.getBytes(httpData.getCharset()), true);
        if (posDelimiter < 0) {
            ByteBuf e2;
            void content2;
            int readableBytes = undecodedChunk.readableBytes();
            int lastPosition = readableBytes - bdelimiter.length - 1;
            if (lastPosition < 0) {
                lastPosition = 0;
            }
            if ((posDelimiter = HttpPostBodyUtil.findLastLineBreak(undecodedChunk, startReaderIndex + lastPosition)) < 0 && httpData.definedLength() == httpData.length() + (long)readableBytes - 1L && undecodedChunk.getByte(readableBytes + startReaderIndex - 1) == 13) {
                lastPosition = 0;
                posDelimiter = readableBytes - 1;
            }
            if (posDelimiter < 0) {
                ByteBuf content2 = undecodedChunk.copy();
                try {
                    httpData.addContent(content2, false);
                }
                catch (IOException e2) {
                    throw new HttpPostRequestDecoder.ErrorDataDecoderException(e2);
                }
                e2.readerIndex(startReaderIndex);
                e2.writerIndex(startReaderIndex);
                return false;
            }
            if ((posDelimiter += content2) == 0) {
                return false;
            }
            ByteBuf content2 = e2.copy(startReaderIndex, posDelimiter);
            try {
                httpData.addContent(content2, false);
            }
            catch (IOException e2) {
                void var0_2;
                throw new HttpPostRequestDecoder.ErrorDataDecoderException((Throwable)var0_2);
            }
            HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(byteBuf, posDelimiter);
            return false;
        }
        ByteBuf content = byteBuf.copy((int)var3_9, posDelimiter);
        try {
            void var2_8;
            var2_8.addContent(content, true);
        }
        catch (IOException e) {
            void var1_7;
            throw new HttpPostRequestDecoder.ErrorDataDecoderException((Throwable)var1_7);
        }
        HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(byteBuf, posDelimiter);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static String cleanString(String field) {
        void var2_2;
        int size = field.length();
        StringBuilder sb = new StringBuilder(size);
        block4: for (int i = 0; i < size; ++i) {
            char nextChar = field.charAt(i);
            switch (nextChar) {
                case '\t': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    sb.append(' ');
                    continue block4;
                }
                case '\"': {
                    continue block4;
                }
                default: {
                    sb.append(nextChar);
                }
            }
        }
        return var2_2.toString().trim();
    }

    /*
     * WARNING - void declaration
     */
    private boolean skipOneLine() {
        void var1_1;
        if (!this.undecodedChunk.isReadable()) {
            return false;
        }
        byte nextByte = this.undecodedChunk.readByte();
        if (nextByte == 13) {
            if (!this.undecodedChunk.isReadable()) {
                this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                return false;
            }
            nextByte = this.undecodedChunk.readByte();
            if (nextByte == 10) {
                return true;
            }
            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 2);
            return false;
        }
        if (var1_1 == 10) {
            return true;
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
        return false;
    }

    private static String[] splitMultipartHeader(String sb) {
        String[] stringArray;
        int n;
        int colonEnd;
        int nameStart;
        char ch;
        ArrayList<String> headers = new ArrayList<String>(1);
        for (int nameEnd = nameStart = HttpPostBodyUtil.findNonWhitespace(sb, 0); nameEnd < sb.length() && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < sb.length(); ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        int valueStart = HttpPostBodyUtil.findNonWhitespace(sb, colonEnd);
        int valueEnd = HttpPostBodyUtil.findEndOfString(sb);
        headers.add(sb.substring(nameStart, n));
        String svalue = valueStart >= valueEnd ? "" : sb.substring(valueStart, valueEnd);
        for (String value : svalue.indexOf(59) >= 0 ? HttpPostMultipartRequestDecoder.splitMultipartHeaderValues(svalue) : svalue.split(",")) {
            headers.add(value.trim());
        }
        String[] array = new String[headers.size()];
        for (int i = 0; i < headers.size(); ++i) {
            array[i] = (String)headers.get(i);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitMultipartHeaderValues(String svalue) {
        void var1_1;
        String string;
        ArrayList values = InternalThreadLocalMap.get().arrayList(1);
        boolean inQuote = false;
        boolean escapeNext = false;
        int start = 0;
        for (int i = 0; i < svalue.length(); ++i) {
            char c = svalue.charAt(i);
            if (inQuote) {
                if (escapeNext) {
                    escapeNext = false;
                    continue;
                }
                if (c == '\\') {
                    escapeNext = true;
                    continue;
                }
                if (c != '\"') continue;
                inQuote = false;
                continue;
            }
            if (c == '\"') {
                inQuote = true;
                continue;
            }
            if (c != ';') continue;
            values.add(svalue.substring(start, i));
            start = i + 1;
        }
        values.add(string.substring(start));
        return var1_1.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    int getCurrentAllocatedCapacity() {
        return this.undecodedChunk.capacity();
    }
}

