/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;

final class HttpPostBodyUtil {
    public static final int chunkSize = 8096;
    public static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";

    private HttpPostBodyUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static int findNonWhitespace(String sb, int offset) {
        void var1_1;
        for (int result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int findEndOfString(String sb) {
        void var1_1;
        for (int result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int findLineBreak(ByteBuf buffer, int index) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        int toRead = buffer.readableBytes() - (index - buffer.readerIndex());
        int posFirstChar = buffer.bytesBefore(index, toRead, (byte)10);
        if (posFirstChar == -1) {
            return -1;
        }
        if (posFirstChar > 0 && byteBuf.getByte((int)(var1_1 + posFirstChar - true)) == 13) {
            --posFirstChar;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int findLastLineBreak(ByteBuf buffer, int index) {
        void var3_3;
        void var2_2;
        int next;
        int candidate = HttpPostBodyUtil.findLineBreak(buffer, index);
        int findCRLF = 0;
        if (candidate >= 0) {
            findCRLF = buffer.getByte(index + candidate) == 13 ? 2 : 1;
            candidate += findCRLF;
        }
        while (candidate > 0 && (next = HttpPostBodyUtil.findLineBreak(buffer, index + candidate)) >= 0) {
            findCRLF = buffer.getByte(index + (candidate += next)) == 13 ? 2 : 1;
            candidate += findCRLF;
        }
        return (int)(var2_2 - var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static int findDelimiter(ByteBuf buffer, int index, byte[] delimiter, boolean precededByLineBreak) {
        int delimiterLength = delimiter.length;
        int readerIndex = buffer.readerIndex();
        int n = buffer.writerIndex();
        int toRead = n - index;
        boolean delimiterNotFound = true;
        while (delimiterNotFound && delimiterLength <= toRead) {
            void newOffset;
            int posDelimiter = buffer.bytesBefore((int)newOffset, toRead, delimiter[0]);
            if (posDelimiter < 0) {
                return -1;
            }
            newOffset += posDelimiter;
            if ((toRead -= posDelimiter) >= delimiterLength) {
                delimiterNotFound = false;
                for (int i = 0; i < delimiterLength; ++i) {
                    if (buffer.getByte((int)(newOffset + i)) == delimiter[i]) continue;
                    ++newOffset;
                    --toRead;
                    delimiterNotFound = true;
                    break;
                }
            }
            if (delimiterNotFound) continue;
            if (precededByLineBreak && newOffset > readerIndex) {
                if (buffer.getByte((int)(newOffset - true)) == 10) {
                    if (--newOffset > readerIndex && buffer.getByte((int)(newOffset - true)) == 13) {
                        --newOffset;
                    }
                } else {
                    ++newOffset;
                    --toRead;
                    delimiterNotFound = true;
                    continue;
                }
            }
            return (int)(newOffset - readerIndex);
        }
        return -1;
    }

    static class SeekAheadOptimize {
        byte[] bytes;
        int readerIndex;
        int pos;
        int origPos;
        int limit;
        ByteBuf buffer;

        /*
         * WARNING - void declaration
         */
        SeekAheadOptimize(ByteBuf buffer) {
            void var1_1;
            if (!buffer.hasArray()) {
                throw new IllegalArgumentException("buffer hasn't backing byte array");
            }
            this.buffer = buffer;
            this.bytes = buffer.array();
            this.readerIndex = buffer.readerIndex();
            SeekAheadOptimize seekAheadOptimize = this;
            seekAheadOptimize.origPos = seekAheadOptimize.pos = buffer.arrayOffset() + this.readerIndex;
            this.limit = buffer.arrayOffset() + var1_1.writerIndex();
        }

        /*
         * WARNING - void declaration
         */
        void setReadPosition(int minus) {
            void var1_1;
            this.pos -= var1_1;
            this.readerIndex = this.getReadPosition(this.pos);
            this.buffer.readerIndex(this.readerIndex);
        }

        int getReadPosition(int index) {
            return index - this.origPos + this.readerIndex;
        }
    }

    public static enum TransferEncodingMechanism {
        BIT7("7bit"),
        BIT8("8bit"),
        BINARY("binary");

        private final String value;

        /*
         * WARNING - void declaration
         */
        private TransferEncodingMechanism(String value) {
            void var3_3;
            this.value = var3_3;
        }

        public final String value() {
            return this.value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

