/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelException;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.AbstractDiskHttpData;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;

public class DiskAttribute
extends AbstractDiskHttpData
implements Attribute {
    public static String baseDirectory;
    public static boolean deleteOnExitTemporaryFile;
    public static final String prefix = "Attr_";
    public static final String postfix = ".att";
    private String baseDir;
    private boolean deleteOnExit;

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name) {
        this((String)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, String baseDir, boolean deleteOnExit) {
        this((String)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var3_3;
        void var2_2;
        void var1_1;
        this.baseDir = baseDir == null ? baseDirectory : var2_2;
        this.deleteOnExit = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, long definedSize) {
        this((String)var1_1, (long)var2_2, HttpConstants.DEFAULT_CHARSET, baseDirectory, deleteOnExitTemporaryFile);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, long definedSize, String baseDir, boolean deleteOnExit) {
        this((String)var1_1, (long)var2_2, HttpConstants.DEFAULT_CHARSET);
        void var2_2;
        void var1_1;
        this.baseDir = baseDir == null ? baseDirectory : baseDir;
        this.deleteOnExit = deleteOnExit;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, Charset charset) {
        this((String)var1_1, (Charset)var2_2, baseDirectory, deleteOnExitTemporaryFile);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, Charset charset, String baseDir, boolean deleteOnExit) {
        super((String)var1_1, (Charset)var2_2, 0L);
        void var3_3;
        void var2_2;
        void var1_1;
        this.baseDir = baseDir == null ? baseDirectory : var3_3;
        this.deleteOnExit = deleteOnExit;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, long definedSize, Charset charset) {
        this((String)var1_1, (long)var2_2, charset, baseDirectory, deleteOnExitTemporaryFile);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, long definedSize, Charset charset, String baseDir, boolean deleteOnExit) {
        super((String)var1_1, charset, (long)var2_2);
        void var2_2;
        void var1_1;
        this.baseDir = baseDir == null ? baseDirectory : baseDir;
        this.deleteOnExit = deleteOnExit;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, String value) throws IOException {
        this((String)var1_1, (String)var2_2, HttpConstants.DEFAULT_CHARSET);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, String value, Charset charset) throws IOException {
        this((String)var1_1, (String)var2_2, (Charset)var3_3, baseDirectory, deleteOnExitTemporaryFile);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DiskAttribute(String name, String value, Charset charset, String baseDir, boolean deleteOnExit) throws IOException {
        super((String)var1_1, (Charset)var3_3, 0L);
        void var2_2;
        void var3_3;
        void var1_1;
        this.setValue((String)var2_2);
        this.baseDir = baseDir == null ? baseDirectory : baseDir;
        this.deleteOnExit = deleteOnExit;
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.Attribute;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getValue() throws IOException {
        void var1_1;
        byte[] bytes = this.get();
        return new String((byte[])var1_1, this.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setValue(String value) throws IOException {
        void var1_1;
        ObjectUtil.checkNotNull((Object)value, (String)"value");
        byte[] bytes = value.getBytes(this.getCharset());
        this.checkSize(bytes.length);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bytes);
        if (this.definedSize > 0L) {
            this.definedSize = buffer.readableBytes();
        }
        this.setContent((ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(ByteBuf buffer, boolean last) throws IOException {
        void var2_2;
        void var1_1;
        long newDefinedSize = this.size + (long)buffer.readableBytes();
        try {
            this.checkSize(newDefinedSize);
        }
        catch (IOException e) {
            void var2_3;
            buffer.release();
            throw var2_3;
        }
        if (this.definedSize > 0L && this.definedSize < newDefinedSize) {
            void var3_4;
            this.definedSize = var3_4;
        }
        super.addContent((ByteBuf)var1_1, (boolean)var2_2);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return this.getName().equalsIgnoreCase(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(InterfaceHttpData o) {
        void var1_1;
        if (!(o instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)o.getHttpDataType()));
        }
        return this.compareTo((Attribute)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Attribute o) {
        void var1_1;
        return this.getName().compareToIgnoreCase(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        try {
            return this.getName() + '=' + this.getValue();
        }
        catch (IOException e) {
            void var1_1;
            return this.getName() + '=' + var1_1;
        }
    }

    @Override
    protected boolean deleteOnExit() {
        return this.deleteOnExit;
    }

    @Override
    protected String getBaseDirectory() {
        return this.baseDir;
    }

    @Override
    protected String getDiskFilename() {
        return this.getName() + postfix;
    }

    @Override
    protected String getPostfix() {
        return postfix;
    }

    @Override
    protected String getPrefix() {
        return prefix;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute copy() {
        void var1_1;
        ByteBuf content = this.content();
        return this.replace(content != null ? var1_1.copy() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute duplicate() {
        void var1_1;
        ByteBuf content = this.content();
        return this.replace(content != null ? var1_1.duplicate() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute retainedDuplicate() {
        ByteBuf content = this.content();
        if (content != null) {
            content = content.retainedDuplicate();
            boolean success = false;
            try {
                void var3_3;
                Attribute duplicate = this.replace(content);
                success = true;
                return var3_3;
            }
            catch (Throwable throwable) {
                void var2_2;
                if (var2_2 == false) {
                    void var1_1;
                    var1_1.release();
                }
                throw throwable;
            }
        }
        return this.replace(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute replace(ByteBuf content) {
        void var2_3;
        DiskAttribute attr = new DiskAttribute(this.getName(), this.baseDir, this.deleteOnExit);
        attr.setCharset(this.getCharset());
        if (content != null) {
            try {
                attr.setContent(content);
            }
            catch (IOException e) {
                void var1_2;
                throw new ChannelException((Throwable)var1_2);
            }
        }
        attr.setCompleted(this.isCompleted());
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public Attribute retain() {
        super.retain();
        return this;
    }

    @Override
    public Attribute touch() {
        super.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute touch(Object hint) {
        void var1_1;
        super.touch(var1_1);
        return this;
    }

    static {
        deleteOnExitTemporaryFile = true;
    }
}

