/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import io.netty.handler.codec.http.multipart.MixedFileUpload;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultHttpDataFactory
implements HttpDataFactory {
    public static final long MINSIZE = 16384L;
    public static final long MAXSIZE = -1L;
    private final boolean useDisk;
    private final boolean checkSize;
    private long minSize;
    private long maxSize = -1L;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private String baseDir;
    private boolean deleteOnExit;
    private final Map<HttpRequest, List<HttpData>> requestFileDeleteMap = Collections.synchronizedMap(new IdentityHashMap());

    public DefaultHttpDataFactory() {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = 16384L;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpDataFactory(Charset charset) {
        this();
        void var1_1;
        this.charset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpDataFactory(boolean useDisk) {
        void var1_1;
        this.useDisk = var1_1;
        this.checkSize = false;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpDataFactory(boolean useDisk, Charset charset) {
        this((boolean)var1_1);
        void var2_2;
        void var1_1;
        this.charset = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpDataFactory(long minSize) {
        void var1_1;
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpDataFactory(long minSize, Charset charset) {
        this((long)var1_1);
        void var3_2;
        void var1_1;
        this.charset = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setBaseDir(String baseDir) {
        void var1_1;
        this.baseDir = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDeleteOnExit(boolean deleteOnExit) {
        void var1_1;
        this.deleteOnExit = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxLimit(long maxSize) {
        void var1_1;
        this.maxSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<HttpData> getList(HttpRequest request) {
        void var2_2;
        List<HttpData> list = this.requestFileDeleteMap.get(request);
        if (list == null) {
            void var1_1;
            list = new ArrayList<HttpData>();
            this.requestFileDeleteMap.put((HttpRequest)var1_1, list);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute createAttribute(HttpRequest request, String name) {
        void var2_2;
        AbstractReferenceCounted attribute;
        if (this.useDisk) {
            attribute = new DiskAttribute(name, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            request = this.getList((HttpRequest)request);
            request.add((HttpData)attribute);
            return attribute;
        }
        if (this.checkSize) {
            List<HttpData> list;
            attribute = new MixedAttribute((String)attribute, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)attribute);
            return attribute;
        }
        attribute = new MemoryAttribute((String)attribute);
        attribute.setMaxSize(this.maxSize);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute createAttribute(HttpRequest request, String name, long definedSize) {
        void var2_2;
        void var3_3;
        AbstractReferenceCounted attribute;
        if (this.useDisk) {
            attribute = new DiskAttribute(name, definedSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            request = this.getList((HttpRequest)request);
            request.add((HttpData)attribute);
            return attribute;
        }
        if (this.checkSize) {
            List<HttpData> list;
            attribute = new MixedAttribute((String)attribute, definedSize, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)attribute);
            return attribute;
        }
        attribute = new MemoryAttribute((String)attribute, (long)var3_3);
        attribute.setMaxSize(this.maxSize);
        return var2_2;
    }

    private static void checkHttpDataSize(HttpData data) {
        try {
            HttpData httpData = data;
            httpData.checkSize(httpData.length());
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Attribute bigger than maxSize allowed");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Attribute createAttribute(HttpRequest request, String name, String value) {
        if (this.useDisk) {
            AbstractReferenceCounted attribute;
            try {
                attribute = new DiskAttribute(name, value, this.charset, this.baseDir, this.deleteOnExit);
                attribute.setMaxSize(this.maxSize);
            }
            catch (IOException iOException) {
                attribute = new MixedAttribute(name, value, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
                attribute.setMaxSize(this.maxSize);
            }
            DefaultHttpDataFactory.checkHttpDataSize(attribute);
            request = this.getList((HttpRequest)request);
            request.add((HttpData)attribute);
            return attribute;
        }
        if (this.checkSize) {
            List<HttpData> list;
            MixedAttribute attribute = new MixedAttribute(name, value, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(attribute);
            list = this.getList((HttpRequest)((Object)list));
            list.add(attribute);
            return attribute;
        }
        try {
            void var3_3;
            void var2_2;
            MemoryAttribute attribute = new MemoryAttribute((String)var2_2, (String)var3_3, this.charset);
            attribute.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(attribute);
            return attribute;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileUpload createFileUpload(HttpRequest request, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        void var2_2;
        void var3_3;
        AbstractReferenceCounted fileUpload;
        if (this.useDisk) {
            fileUpload = new DiskFileUpload(name, filename, contentType, contentTransferEncoding, charset, size, this.baseDir, this.deleteOnExit);
            fileUpload.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
            request = this.getList((HttpRequest)request);
            request.add((HttpData)fileUpload);
            return fileUpload;
        }
        if (this.checkSize) {
            List<HttpData> list;
            fileUpload = new MixedFileUpload((String)fileUpload, filename, contentType, contentTransferEncoding, charset, size, this.minSize, this.baseDir, this.deleteOnExit);
            fileUpload.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
            list = this.getList((HttpRequest)((Object)list));
            list.add((HttpData)fileUpload);
            return fileUpload;
        }
        fileUpload = new MemoryFileUpload((String)fileUpload, (String)var3_3, contentType, contentTransferEncoding, charset, size);
        fileUpload.setMaxSize(this.maxSize);
        DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
        return var2_2;
    }

    @Override
    public void removeHttpDataFromClean(HttpRequest request, InterfaceHttpData data) {
        if (!(data instanceof HttpData)) {
            return;
        }
        List<HttpData> list = this.requestFileDeleteMap.get(request);
        if (list == null) {
            return;
        }
        Iterator<HttpData> i = list.iterator();
        while (i.hasNext()) {
            HttpData httpData = i.next();
            if (httpData != data) continue;
            i.remove();
            if (list.isEmpty()) {
                this.requestFileDeleteMap.remove(request);
            }
            return;
        }
    }

    @Override
    public void cleanRequestHttpData(HttpRequest request) {
        List<HttpData> list = this.requestFileDeleteMap.remove(request);
        if (list != null) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                HttpData httpData = (HttpData)iterator.next();
                httpData.release();
            }
        }
    }

    @Override
    public void cleanAllHttpData() {
        Iterator<Map.Entry<HttpRequest, List<HttpData>>> i = this.requestFileDeleteMap.entrySet().iterator();
        while (i.hasNext()) {
            Iterator<HttpData> iterator = i.next();
            iterator = iterator.getValue();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                HttpData httpData = iterator.next();
                httpData.release();
            }
            i.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanRequestHttpDatas(HttpRequest request) {
        void var1_1;
        this.cleanRequestHttpData((HttpRequest)var1_1);
    }

    @Override
    public void cleanAllHttpDatas() {
        this.cleanAllHttpData();
    }
}

