/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.AbstractReferenceCounted;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

abstract class AbstractMixedHttpData<D extends HttpData>
extends AbstractReferenceCounted
implements HttpData {
    final String baseDir;
    final boolean deleteOnExit;
    D wrapped;
    private final long limitSize;

    /*
     * WARNING - void declaration
     */
    AbstractMixedHttpData(long limitSize, String baseDir, boolean deleteOnExit, D initial) {
        void var3_2;
        void var1_1;
        this.limitSize = var1_1;
        this.wrapped = initial;
        this.baseDir = var3_2;
        this.deleteOnExit = deleteOnExit;
    }

    abstract D makeDiskData();

    @Override
    public long getMaxSize() {
        return this.wrapped.getMaxSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxSize(long maxSize) {
        void var1_1;
        this.wrapped.setMaxSize((long)var1_1);
    }

    public ByteBuf content() {
        return this.wrapped.content();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkSize(long newSize) throws IOException {
        void var1_1;
        this.wrapped.checkSize((long)var1_1);
    }

    @Override
    public long definedLength() {
        return this.wrapped.definedLength();
    }

    @Override
    public Charset getCharset() {
        return this.wrapped.getCharset();
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(ByteBuf buffer, boolean last) throws IOException {
        void var2_2;
        void var1_1;
        if (this.wrapped instanceof AbstractMemoryHttpData) {
            try {
                AbstractMixedHttpData abstractMixedHttpData = this;
                abstractMixedHttpData.checkSize(abstractMixedHttpData.wrapped.length() + (long)buffer.readableBytes());
                if (this.wrapped.length() + (long)buffer.readableBytes() > this.limitSize) {
                    D diskData = this.makeDiskData();
                    ByteBuf data = ((AbstractMemoryHttpData)this.wrapped).getByteBuf();
                    if (data != null && data.isReadable()) {
                        diskData.addContent(data.retain(), false);
                    }
                    this.wrapped.release();
                    this.wrapped = diskData;
                }
            }
            catch (IOException e) {
                void var3_4;
                buffer.release();
                throw var3_4;
            }
        }
        this.wrapped.addContent((ByteBuf)var1_1, (boolean)var2_2);
    }

    protected void deallocate() {
        this.delete();
    }

    @Override
    public void delete() {
        this.wrapped.delete();
    }

    @Override
    public byte[] get() throws IOException {
        return this.wrapped.get();
    }

    @Override
    public ByteBuf getByteBuf() throws IOException {
        return this.wrapped.getByteBuf();
    }

    @Override
    public String getString() throws IOException {
        return this.wrapped.getString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString(Charset encoding) throws IOException {
        void var1_1;
        return this.wrapped.getString((Charset)var1_1);
    }

    @Override
    public boolean isInMemory() {
        return this.wrapped.isInMemory();
    }

    @Override
    public long length() {
        return this.wrapped.length();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean renameTo(File dest) throws IOException {
        void var1_1;
        return this.wrapped.renameTo((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCharset(Charset charset) {
        void var1_1;
        this.wrapped.setCharset((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContent(ByteBuf buffer) throws IOException {
        void var1_1;
        try {
            this.checkSize(buffer.readableBytes());
        }
        catch (IOException e) {
            void var2_2;
            buffer.release();
            throw var2_2;
        }
        if ((long)buffer.readableBytes() > this.limitSize && this.wrapped instanceof AbstractMemoryHttpData) {
            this.wrapped.release();
            this.wrapped = this.makeDiskData();
        }
        this.wrapped.setContent((ByteBuf)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContent(File file) throws IOException {
        void var1_1;
        this.checkSize(file.length());
        if (file.length() > this.limitSize && this.wrapped instanceof AbstractMemoryHttpData) {
            this.wrapped.release();
            this.wrapped = this.makeDiskData();
        }
        this.wrapped.setContent((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContent(InputStream inputStream) throws IOException {
        void var1_1;
        if (this.wrapped instanceof AbstractMemoryHttpData) {
            this.wrapped.release();
            this.wrapped = this.makeDiskData();
        }
        this.wrapped.setContent((InputStream)var1_1);
    }

    @Override
    public boolean isCompleted() {
        return this.wrapped.isCompleted();
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return this.wrapped.getHttpDataType();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        return this.wrapped.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(InterfaceHttpData o) {
        void var1_1;
        return this.wrapped.compareTo((Object)var1_1);
    }

    public String toString() {
        return "Mixed: " + this.wrapped;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getChunk(int length) throws IOException {
        void var1_1;
        return this.wrapped.getChunk((int)var1_1);
    }

    @Override
    public File getFile() throws IOException {
        return this.wrapped.getFile();
    }

    public D copy() {
        return (D)this.wrapped.copy();
    }

    public D duplicate() {
        return (D)this.wrapped.duplicate();
    }

    public D retainedDuplicate() {
        return (D)this.wrapped.retainedDuplicate();
    }

    /*
     * WARNING - void declaration
     */
    public D replace(ByteBuf content) {
        void var1_1;
        return (D)this.wrapped.replace((ByteBuf)var1_1);
    }

    public D touch() {
        this.wrapped.touch();
        return (D)this;
    }

    /*
     * WARNING - void declaration
     */
    public D touch(Object hint) {
        void var1_1;
        this.wrapped.touch(var1_1);
        return (D)this;
    }

    public D retain() {
        return (D)((HttpData)super.retain());
    }

    /*
     * WARNING - void declaration
     */
    public D retain(int increment) {
        void var1_1;
        return (D)((HttpData)super.retain((int)var1_1));
    }
}

