/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    private ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
    private int chunkPosition;

    /*
     * WARNING - void declaration
     */
    protected AbstractMemoryHttpData(String name, Charset charset, long size) {
        super((String)var1_1, (Charset)var2_2, (long)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContent(ByteBuf buffer) throws IOException {
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)buffer, (String)"buffer");
        long localsize = buffer.readableBytes();
        try {
            this.checkSize(localsize);
        }
        catch (IOException e) {
            void var2_3;
            buffer.release();
            throw var2_3;
        }
        if (this.definedSize > 0L && this.definedSize < var2_2) {
            buffer.release();
            throw new IOException("Out of size: " + (long)var2_2 + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = var1_1;
        this.size = var2_2;
        this.setCompleted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContent(InputStream inputStream) throws IOException {
        void var3_3;
        ObjectUtil.checkNotNull((Object)inputStream, (String)"inputStream");
        byte[] bytes = new byte[16384];
        ByteBuf buffer = Unpooled.buffer();
        int written = 0;
        try {
            int read = inputStream.read(bytes);
            while (read > 0) {
                buffer.writeBytes(bytes, 0, read);
                this.checkSize(written += read);
                read = inputStream.read(bytes);
            }
        }
        catch (IOException e) {
            buffer.release();
            throw e;
        }
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            buffer.release();
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = var3_3;
        this.setCompleted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(ByteBuf buffer, boolean last) throws IOException {
        void var1_1;
        void var2_2;
        if (buffer != null) {
            long localsize = buffer.readableBytes();
            try {
                AbstractMemoryHttpData abstractMemoryHttpData = this;
                abstractMemoryHttpData.checkSize(abstractMemoryHttpData.size + localsize);
            }
            catch (IOException e) {
                buffer.release();
                throw e;
            }
            if (this.definedSize > 0L && this.definedSize < this.size + e) {
                buffer.release();
                throw new IOException("Out of size: " + (this.size + e) + " > " + this.definedSize);
            }
            this.size += e;
            if (this.byteBuf == null) {
                this.byteBuf = buffer;
            } else if (e == 0L) {
                buffer.release();
            } else if (this.byteBuf.readableBytes() == 0) {
                this.byteBuf.release();
                this.byteBuf = buffer;
            } else if (this.byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf e = (CompositeByteBuf)this.byteBuf;
                e.addComponent(true, buffer);
            } else {
                void var3_6;
                CompositeByteBuf cbb = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
                cbb.addComponents(true, new ByteBuf[]{this.byteBuf, buffer});
                this.byteBuf = var3_6;
            }
        }
        if (var2_2 != false) {
            this.setCompleted();
            return;
        }
        ObjectUtil.checkNotNull((Object)var1_1, (String)"buffer");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContent(File file) throws IOException {
        void var2_2;
        ByteBuffer byteBuffer;
        ObjectUtil.checkNotNull((Object)file, (String)"file");
        long newsize22 = file.length();
        if (newsize22 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        this.checkSize(newsize22);
        RandomAccessFile accessFile = new RandomAccessFile(file, "r");
        try {
            FileChannel fileChannel = accessFile.getChannel();
            try {
                byte[] byArray = new byte[(int)newsize22];
                byteBuffer = ByteBuffer.wrap(byArray);
                int read = 0;
                while ((long)read < newsize22) {
                    read += fileChannel.read(byteBuffer);
                }
            }
            finally {
                fileChannel.close();
            }
        }
        catch (Throwable newsize22) {
            void var1_1;
            var1_1.close();
            throw newsize22;
        }
        accessFile.close();
        byteBuffer.flip();
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuffer[])new ByteBuffer[]{byteBuffer});
        this.size = var2_2;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.byteBuf != null) {
            this.byteBuf.release();
            this.byteBuf = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] get() {
        void var1_1;
        if (this.byteBuf == null) {
            return Unpooled.EMPTY_BUFFER.array();
        }
        byte[] array = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.getBytes(this.byteBuf.readerIndex(), array);
        return var1_1;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString(Charset encoding) {
        void var1_1;
        if (this.byteBuf == null) {
            return "";
        }
        if (encoding == null) {
            encoding = HttpConstants.DEFAULT_CHARSET;
        }
        return this.byteBuf.toString((Charset)var1_1);
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf getChunk(int length) throws IOException {
        void var1_2;
        void var3_4;
        if (this.byteBuf == null || length == 0 || this.byteBuf.readableBytes() == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int sizeLeft = this.byteBuf.readableBytes() - this.chunkPosition;
        if (sizeLeft == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int sliceLength = length;
        if (sizeLeft < length) {
            void var2_3;
            sliceLength = var2_3;
        }
        ByteBuf chunk = this.byteBuf.retainedSlice(this.chunkPosition, sliceLength);
        this.chunkPosition += var3_4;
        return var1_2;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean renameTo(File dest) throws IOException {
        void var2_2;
        void var3_5;
        ObjectUtil.checkNotNull((Object)dest, (String)"dest");
        if (this.byteBuf == null) {
            if (!dest.createNewFile()) {
                throw new IOException("file exists already: " + dest);
            }
            return true;
        }
        int length22 = this.byteBuf.readableBytes();
        RandomAccessFile accessFile = new RandomAccessFile(dest, "rw");
        try {
            FileChannel fileChannel = accessFile.getChannel();
            try {
                long written;
                if (this.byteBuf.nioBufferCount() == 1) {
                    ByteBuffer byteBuffer = this.byteBuf.nioBuffer();
                    for (written = 0L; written < (long)length22; written += (long)fileChannel.write(byteBuffer)) {
                    }
                } else {
                    ByteBuffer[] byteBuffers = this.byteBuf.nioBuffers();
                    while (written < (long)length22) {
                        written += fileChannel.write(byteBuffers);
                    }
                }
                fileChannel.force(false);
            }
            finally {
                fileChannel.close();
            }
        }
        catch (Throwable length22) {
            void var1_1;
            var1_1.close();
            throw length22;
        }
        accessFile.close();
        return var3_5 == (long)var2_2;
    }

    @Override
    public File getFile() throws IOException {
        throw new IOException("Not represented by a file");
    }

    @Override
    public HttpData touch() {
        return ((AbstractHttpData)this).touch(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpData touch(Object hint) {
        if (this.byteBuf != null) {
            void var1_1;
            this.byteBuf.touch((Object)var1_1);
        }
        return this;
    }
}

