/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelException;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public abstract class AbstractHttpData
extends AbstractReferenceCounted
implements HttpData {
    private static final Pattern STRIP_PATTERN = Pattern.compile("(?:^\\s+|\\s+$|\\n)");
    private static final Pattern REPLACE_PATTERN = Pattern.compile("[\\r\\t]");
    private final String name;
    protected long definedSize;
    protected long size;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private boolean completed;
    private long maxSize = -1L;

    /*
     * WARNING - void declaration
     */
    protected AbstractHttpData(String name, Charset charset, long size) {
        void var3_3;
        void var1_1;
        ObjectUtil.checkNotNull((Object)name, (String)"name");
        name = REPLACE_PATTERN.matcher(name).replaceAll(" ");
        name = STRIP_PATTERN.matcher(name).replaceAll("");
        this.name = ObjectUtil.checkNonEmpty((String)var1_1, (String)"name");
        if (charset != null) {
            void var2_2;
            this.setCharset((Charset)var2_2);
        }
        this.definedSize = var3_3;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxSize(long maxSize) {
        void var1_1;
        this.maxSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkSize(long newSize) throws IOException {
        void var1_1;
        if (this.maxSize >= 0L && var1_1 > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void setCompleted() {
        this.setCompleted(true);
    }

    /*
     * WARNING - void declaration
     */
    protected void setCompleted(boolean completed) {
        void var1_1;
        this.completed = var1_1;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCharset(Charset charset) {
        void var1_1;
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)var1_1, (String)"charset");
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public long definedLength() {
        return this.definedSize;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf content() {
        try {
            return this.getByteBuf();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    protected void deallocate() {
        this.delete();
    }

    @Override
    public HttpData retain() {
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpData retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public abstract HttpData touch();

    @Override
    public abstract HttpData touch(Object var1);
}

