/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.List;

public class CorsHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CorsHandler.class);
    private static final String ANY_ORIGIN = "*";
    private static final String NULL_ORIGIN = "null";
    private CorsConfig config;
    private HttpRequest request;
    private final List<CorsConfig> configList;
    private final boolean isShortCircuit;

    /*
     * WARNING - void declaration
     */
    public CorsHandler(CorsConfig config) {
        this(Collections.singletonList(ObjectUtil.checkNotNull((Object)config, (String)"config")), var1_1.isShortCircuit());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CorsHandler(List<CorsConfig> configList, boolean isShortCircuit) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNonEmpty(configList, (String)"configList");
        this.configList = var1_1;
        this.isShortCircuit = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (msg instanceof HttpRequest) {
            void var3_3;
            this.request = (HttpRequest)msg;
            String origin = this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
            this.config = this.getForOrigin(origin);
            if (CorsHandler.isPreflightRequest(this.request)) {
                this.handlePreflight(ctx, this.request);
                return;
            }
            if (this.isShortCircuit && var3_3 != null && this.config == null) {
                CorsHandler.forbidden(ctx, this.request);
                return;
            }
        }
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void handlePreflight(ChannelHandlerContext ctx, HttpRequest request) {
        void var3_3;
        void var2_2;
        void var1_1;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK, Unpooled.buffer((int)0), DefaultHttpHeadersFactory.headersFactory().withCombiningHeaders(true), DefaultHttpHeadersFactory.trailersFactory().withCombiningHeaders(true));
        if (this.setOrigin(response)) {
            this.setAllowMethods(response);
            this.setAllowHeaders(response);
            this.setAllowCredentials(response);
            this.setMaxAge(response);
            this.setPreflightHeaders(response);
            this.setAllowPrivateNetwork(response);
        }
        if (!response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
        }
        ReferenceCountUtil.release((Object)request);
        CorsHandler.respond((ChannelHandlerContext)var1_1, (HttpRequest)var2_2, (HttpResponse)var3_3);
    }

    private void setPreflightHeaders(HttpResponse response) {
        response.headers().add(this.config.preflightResponseHeaders());
    }

    /*
     * WARNING - void declaration
     */
    private CorsConfig getForOrigin(String requestOrigin) {
        for (CorsConfig corsConfig : this.configList) {
            void var3_3;
            if (corsConfig.isAnyOriginSupported()) {
                return corsConfig;
            }
            if (corsConfig.origins().contains(requestOrigin)) {
                return corsConfig;
            }
            if (!corsConfig.isNullOriginAllowed() && !NULL_ORIGIN.equals(requestOrigin)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean setOrigin(HttpResponse response) {
        String origin = this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (origin != null && this.config != null) {
            void var2_2;
            if (NULL_ORIGIN.equals(origin) && this.config.isNullOriginAllowed()) {
                CorsHandler.setNullOrigin(response);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(response);
                    CorsHandler.setVaryHeader(response);
                } else {
                    CorsHandler.setAnyOrigin(response);
                }
                return true;
            }
            if (this.config.origins().contains(origin)) {
                void var1_1;
                CorsHandler.setOrigin(response, origin);
                CorsHandler.setVaryHeader((HttpResponse)var1_1);
                return true;
            }
            logger.debug("Request origin [{}]] was not among the configured origins [{}]", (Object)var2_2, this.config.origins());
        }
        return false;
    }

    private void echoRequestOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN));
    }

    private static void setVaryHeader(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.VARY, (Object)HttpHeaderNames.ORIGIN);
    }

    private static void setAnyOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, ANY_ORIGIN);
    }

    private static void setNullOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, NULL_ORIGIN);
    }

    /*
     * WARNING - void declaration
     */
    private static void setOrigin(HttpResponse response, String origin) {
        void var1_1;
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setAllowCredentials(HttpResponse response) {
        if (this.config.isCredentialsAllowed() && !response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN).equals(ANY_ORIGIN)) {
            void var1_1;
            var1_1.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isPreflightRequest(HttpRequest request) {
        void var1_1;
        HttpRequest httpRequest;
        HttpHeaders headers = request.headers();
        return HttpMethod.OPTIONS.equals(httpRequest.method()) && headers.contains((CharSequence)HttpHeaderNames.ORIGIN) && var1_1.contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    /*
     * WARNING - void declaration
     */
    private void setExposeHeaders(HttpResponse response) {
        if (!this.config.exposedHeaders().isEmpty()) {
            void var1_1;
            var1_1.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, this.config.exposedHeaders());
        }
    }

    private void setAllowMethods(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, this.config.allowedRequestMethods());
    }

    private void setAllowHeaders(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)this.config.maxAge());
    }

    /*
     * WARNING - void declaration
     */
    private void setAllowPrivateNetwork(HttpResponse response) {
        if (this.request.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK)) {
            void var1_1;
            if (this.config.isPrivateNetworkAllowed()) {
                response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, (Object)"true");
                return;
            }
            var1_1.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, (Object)"false");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        HttpResponse response;
        if (this.config != null && this.config.isCorsSupportEnabled() && msg instanceof HttpResponse && this.setOrigin(response = (HttpResponse)msg)) {
            this.setAllowCredentials(response);
            this.setExposeHeaders(response);
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void forbidden(ChannelHandlerContext ctx, HttpRequest request) {
        void var2_2;
        void var1_1;
        ChannelHandlerContext channelHandlerContext;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.FORBIDDEN, ctx.alloc().buffer(0));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
        ReferenceCountUtil.release((Object)request);
        CorsHandler.respond(channelHandlerContext, (HttpRequest)var1_1, (HttpResponse)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void respond(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        void var1_2;
        void var2_3;
        boolean keepAlive = HttpUtil.isKeepAlive(request);
        HttpUtil.setKeepAlive(response, keepAlive);
        ChannelHandlerContext future = ctx.writeAndFlush((Object)var2_3);
        if (var1_2 == false) {
            ChannelHandlerContext channelHandlerContext;
            channelHandlerContext.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

