/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class CorsConfigBuilder {
    final Set<String> origins;
    final boolean anyOrigin;
    boolean allowNullOrigin;
    boolean enabled = true;
    boolean allowCredentials;
    final Set<String> exposeHeaders = new HashSet<String>();
    long maxAge;
    final Set<HttpMethod> requestMethods = new HashSet<HttpMethod>();
    final Set<String> requestHeaders = new HashSet<String>();
    final Map<CharSequence, Callable<?>> preflightHeaders = new HashMap();
    private boolean noPreflightHeaders;
    boolean shortCircuit;
    boolean allowPrivateNetwork;

    public static CorsConfigBuilder forAnyOrigin() {
        return new CorsConfigBuilder();
    }

    public static CorsConfigBuilder forOrigin(String origin) {
        String string;
        if ("*".equals(origin)) {
            return new CorsConfigBuilder();
        }
        return new CorsConfigBuilder(string);
    }

    public static CorsConfigBuilder forOrigins(String ... origins) {
        String[] stringArray;
        return new CorsConfigBuilder(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    CorsConfigBuilder(String ... origins) {
        void var1_1;
        this.origins = new LinkedHashSet(Arrays.asList(var1_1));
        this.anyOrigin = false;
    }

    CorsConfigBuilder() {
        this.anyOrigin = true;
        this.origins = Collections.emptySet();
    }

    public final CorsConfigBuilder allowNullOrigin() {
        this.allowNullOrigin = true;
        return this;
    }

    public final CorsConfigBuilder disable() {
        this.enabled = false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CorsConfigBuilder exposeHeaders(String ... headers) {
        void var1_1;
        this.exposeHeaders.addAll(Arrays.asList(var1_1));
        return this;
    }

    public final CorsConfigBuilder exposeHeaders(CharSequence ... headers) {
        CharSequence[] charSequenceArray = headers;
        int n = headers.length;
        for (int i = 0; i < n; ++i) {
            CharSequence header = charSequenceArray[i];
            this.exposeHeaders.add(header.toString());
        }
        return this;
    }

    public final CorsConfigBuilder allowCredentials() {
        this.allowCredentials = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CorsConfigBuilder maxAge(long max) {
        void var1_1;
        this.maxAge = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CorsConfigBuilder allowedRequestMethods(HttpMethod ... methods) {
        void var1_1;
        this.requestMethods.addAll(Arrays.asList(var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CorsConfigBuilder allowedRequestHeaders(String ... headers) {
        void var1_1;
        this.requestHeaders.addAll(Arrays.asList(var1_1));
        return this;
    }

    public final CorsConfigBuilder allowedRequestHeaders(CharSequence ... headers) {
        CharSequence[] charSequenceArray = headers;
        int n = headers.length;
        for (int i = 0; i < n; ++i) {
            CharSequence header = charSequenceArray[i];
            this.requestHeaders.add(header.toString());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CorsConfigBuilder preflightResponseHeader(CharSequence name, Object ... values) {
        if (values.length == 1) {
            this.preflightHeaders.put(name, new ConstantValueGenerator(values[0]));
        } else {
            void var2_2;
            void var1_1;
            this.preflightResponseHeader((CharSequence)var1_1, Arrays.asList(var2_2));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> CorsConfigBuilder preflightResponseHeader(CharSequence name, Iterable<T> value) {
        void var2_2;
        void var1_1;
        this.preflightHeaders.put((CharSequence)var1_1, new ConstantValueGenerator(var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> CorsConfigBuilder preflightResponseHeader(CharSequence name, Callable<T> valueGenerator) {
        void var2_2;
        void var1_1;
        this.preflightHeaders.put((CharSequence)var1_1, (Callable<?>)var2_2);
        return this;
    }

    public final CorsConfigBuilder noPreflightResponseHeaders() {
        this.noPreflightHeaders = true;
        return this;
    }

    public final CorsConfigBuilder shortCircuit() {
        this.shortCircuit = true;
        return this;
    }

    public final CorsConfigBuilder allowPrivateNetwork() {
        this.allowPrivateNetwork = true;
        return this;
    }

    public final CorsConfig build() {
        if (this.preflightHeaders.isEmpty() && !this.noPreflightHeaders) {
            this.preflightHeaders.put((CharSequence)HttpHeaderNames.DATE, DateValueGenerator.INSTANCE);
            this.preflightHeaders.put((CharSequence)HttpHeaderNames.CONTENT_LENGTH, new ConstantValueGenerator("0"));
        }
        return new CorsConfig(this);
    }

    private static final class DateValueGenerator
    implements Callable<Date> {
        static final DateValueGenerator INSTANCE = new DateValueGenerator();

        private DateValueGenerator() {
        }

        @Override
        public final Date call() throws Exception {
            return new Date();
        }
    }

    private static final class ConstantValueGenerator
    implements Callable<Object> {
        private final Object value;

        /*
         * WARNING - void declaration
         */
        private ConstantValueGenerator(Object value) {
            void var1_1;
            this.value = ObjectUtil.checkNotNullWithIAE((Object)var1_1, (String)"value");
        }

        @Override
        public final Object call() {
            return this.value;
        }
    }
}

