/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.util.internal.StringUtil;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class CorsConfig {
    private final Set<String> origins;
    private final boolean anyOrigin;
    private final boolean enabled;
    private final Set<String> exposeHeaders;
    private final boolean allowCredentials;
    private final long maxAge;
    private final Set<HttpMethod> allowedRequestMethods;
    private final Set<String> allowedRequestHeaders;
    private final boolean allowNullOrigin;
    private final Map<CharSequence, Callable<?>> preflightHeaders;
    private final boolean shortCircuit;
    private final boolean allowPrivateNetwork;

    /*
     * WARNING - void declaration
     */
    CorsConfig(CorsConfigBuilder builder) {
        void var1_1;
        this.origins = new LinkedHashSet<String>(builder.origins);
        this.anyOrigin = builder.anyOrigin;
        this.enabled = builder.enabled;
        this.exposeHeaders = builder.exposeHeaders;
        this.allowCredentials = builder.allowCredentials;
        this.maxAge = builder.maxAge;
        this.allowedRequestMethods = builder.requestMethods;
        this.allowedRequestHeaders = builder.requestHeaders;
        this.allowNullOrigin = builder.allowNullOrigin;
        this.preflightHeaders = builder.preflightHeaders;
        this.shortCircuit = builder.shortCircuit;
        this.allowPrivateNetwork = var1_1.allowPrivateNetwork;
    }

    public final boolean isCorsSupportEnabled() {
        return this.enabled;
    }

    public final boolean isAnyOriginSupported() {
        return this.anyOrigin;
    }

    public final String origin() {
        if (this.origins.isEmpty()) {
            return "*";
        }
        return this.origins.iterator().next();
    }

    public final Set<String> origins() {
        return this.origins;
    }

    public final boolean isNullOriginAllowed() {
        return this.allowNullOrigin;
    }

    public final boolean isPrivateNetworkAllowed() {
        return this.allowPrivateNetwork;
    }

    public final Set<String> exposedHeaders() {
        return Collections.unmodifiableSet(this.exposeHeaders);
    }

    public final boolean isCredentialsAllowed() {
        return this.allowCredentials;
    }

    public final long maxAge() {
        return this.maxAge;
    }

    public final Set<HttpMethod> allowedRequestMethods() {
        return Collections.unmodifiableSet(this.allowedRequestMethods);
    }

    public final Set<String> allowedRequestHeaders() {
        return Collections.unmodifiableSet(this.allowedRequestHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public final HttpHeaders preflightResponseHeaders() {
        void var1_1;
        if (this.preflightHeaders.isEmpty()) {
            return EmptyHttpHeaders.INSTANCE;
        }
        DefaultHttpHeaders preflightHeaders = new DefaultHttpHeaders();
        for (Map.Entry<CharSequence, Callable<?>> entry : this.preflightHeaders.entrySet()) {
            void var3_3;
            Object value = CorsConfig.getValue(entry.getValue());
            if (value instanceof Iterable) {
                ((HttpHeaders)preflightHeaders).add(entry.getKey(), (Iterable)value);
                continue;
            }
            ((HttpHeaders)preflightHeaders).add((CharSequence)var3_3.getKey(), value);
        }
        return var1_1;
    }

    public final boolean isShortCircuit() {
        return this.shortCircuit;
    }

    @Deprecated
    public final boolean isShortCurcuit() {
        return this.isShortCircuit();
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T getValue(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            void var1_1;
            Callable<T> callable2;
            throw new IllegalStateException("Could not generate value for callable [" + callable2 + ']', (Throwable)var1_1);
        }
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "[enabled=" + this.enabled + ", origins=" + this.origins + ", anyOrigin=" + this.anyOrigin + ", exposedHeaders=" + this.exposeHeaders + ", isCredentialsAllowed=" + this.allowCredentials + ", maxAge=" + this.maxAge + ", allowedRequestMethods=" + this.allowedRequestMethods + ", allowedRequestHeaders=" + this.allowedRequestHeaders + ", preflightHeaders=" + this.preflightHeaders + ", isPrivateNetworkAllowed=" + this.allowPrivateNetwork + ']';
    }

    @Deprecated
    public static Builder withAnyOrigin() {
        return new Builder();
    }

    @Deprecated
    public static Builder withOrigin(String origin) {
        String string;
        if ("*".equals(origin)) {
            return new Builder();
        }
        return new Builder(string);
    }

    @Deprecated
    public static Builder withOrigins(String ... origins) {
        String[] stringArray;
        return new Builder(stringArray);
    }

    @Deprecated
    public static final class DateValueGenerator
    implements Callable<Date> {
        @Override
        public final Date call() throws Exception {
            return new Date();
        }
    }

    @Deprecated
    public static class Builder {
        private final CorsConfigBuilder builder;

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder(String ... origins) {
            void var1_1;
            this.builder = new CorsConfigBuilder((String[])var1_1);
        }

        @Deprecated
        public Builder() {
            this.builder = new CorsConfigBuilder();
        }

        @Deprecated
        public Builder allowNullOrigin() {
            this.builder.allowNullOrigin();
            return this;
        }

        @Deprecated
        public Builder disable() {
            this.builder.disable();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder exposeHeaders(String ... headers) {
            void var1_1;
            this.builder.exposeHeaders((String[])var1_1);
            return this;
        }

        @Deprecated
        public Builder allowCredentials() {
            this.builder.allowCredentials();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder maxAge(long max) {
            void var1_1;
            this.builder.maxAge((long)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder allowedRequestMethods(HttpMethod ... methods) {
            void var1_1;
            this.builder.allowedRequestMethods((HttpMethod[])var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder allowedRequestHeaders(String ... headers) {
            void var1_1;
            this.builder.allowedRequestHeaders((String[])var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder preflightResponseHeader(CharSequence name, Object ... values) {
            void var2_2;
            void var1_1;
            this.builder.preflightResponseHeader((CharSequence)var1_1, (Object[])var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public <T> Builder preflightResponseHeader(CharSequence name, Iterable<T> value) {
            void var2_2;
            void var1_1;
            this.builder.preflightResponseHeader((CharSequence)var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public <T> Builder preflightResponseHeader(String name, Callable<T> valueGenerator) {
            void var2_2;
            void var1_1;
            this.builder.preflightResponseHeader((CharSequence)var1_1, var2_2);
            return this;
        }

        @Deprecated
        public Builder noPreflightResponseHeaders() {
            this.builder.noPreflightResponseHeaders();
            return this;
        }

        @Deprecated
        public CorsConfig build() {
            return this.builder.build();
        }

        @Deprecated
        public Builder shortCurcuit() {
            this.builder.shortCircuit();
            return this;
        }
    }
}

