/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieEncoder;
import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ServerCookieEncoder
extends CookieEncoder {
    public static final ServerCookieEncoder STRICT = new ServerCookieEncoder(true);
    public static final ServerCookieEncoder LAX = new ServerCookieEncoder(false);

    /*
     * WARNING - void declaration
     */
    private ServerCookieEncoder(boolean strict) {
        super((boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(String name, String value) {
        void var2_2;
        void var1_1;
        return this.encode((Cookie)new DefaultCookie((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(Cookie cookie) {
        String name = ((Cookie)ObjectUtil.checkNotNull((Object)cookie, (String)"cookie")).name();
        String value = cookie.value() != null ? cookie.value() : "";
        this.validateCookie(name, value);
        StringBuilder buf = CookieUtil.stringBuilder();
        if (cookie.wrap()) {
            CookieUtil.addQuoted(buf, name, value);
        } else {
            void var3_3;
            CookieUtil.add(buf, name, (String)var3_3);
        }
        if (cookie.maxAge() != Long.MIN_VALUE) {
            CookieUtil.add(buf, "Max-Age", cookie.maxAge());
            Date expires = new Date(cookie.maxAge() * 1000L + System.currentTimeMillis());
            buf.append("Expires");
            buf.append('=');
            DateFormatter.append((Date)expires, (StringBuilder)buf);
            buf.append(';');
            buf.append(' ');
        }
        if (cookie.path() != null) {
            CookieUtil.add(buf, "Path", cookie.path());
        }
        if (cookie.domain() != null) {
            CookieUtil.add(buf, "Domain", cookie.domain());
        }
        if (cookie.isSecure()) {
            CookieUtil.add(buf, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(buf, "HTTPOnly");
        }
        if (cookie instanceof DefaultCookie) {
            void var2_2;
            void var1_1;
            DefaultCookie c = (DefaultCookie)var1_1;
            if (c.sameSite() != null) {
                CookieUtil.add(buf, "SameSite", c.sameSite().name());
            }
            if (var2_2.isPartitioned()) {
                CookieUtil.add(buf, "Partitioned");
            }
        }
        return CookieUtil.stripTrailingSeparator(buf);
    }

    private static List<String> dedup(List<String> encoded, Map<String, Integer> nameToLastIndex) {
        boolean[] isLastInstance = new boolean[encoded.size()];
        Iterator<Integer> iterator = nameToLastIndex.values().iterator();
        while (iterator.hasNext()) {
            int idx = iterator.next();
            isLastInstance[idx] = true;
        }
        ArrayList<String> dedupd = new ArrayList<String>(nameToLastIndex.size());
        int n = encoded.size();
        for (int i = 0; i < n; ++i) {
            if (!isLastInstance[i]) continue;
            dedupd.add(encoded.get(i));
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> encode(Cookie ... cookies) {
        void var2_2;
        if (((Cookie[])ObjectUtil.checkNotNull((Object)cookies, (String)"cookies")).length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies.length);
        HashMap<String, Integer> nameToIndex = this.strict && cookies.length > 1 ? new HashMap<String, Integer>() : null;
        boolean hasDupdName = false;
        for (int i = 0; i < cookies.length; ++i) {
            Cookie c = cookies[i];
            encoded.add(this.encode(c));
            if (nameToIndex == null) continue;
            hasDupdName |= nameToIndex.put(c.name(), i) != null;
        }
        if (hasDupdName) {
            void var3_3;
            return ServerCookieEncoder.dedup(encoded, (Map<String, Integer>)var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> encode(Collection<? extends Cookie> cookies) {
        void var2_2;
        Iterator iterator;
        if (((Collection)ObjectUtil.checkNotNull(cookies, (String)"cookies")).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> encoded = new ArrayList<String>(cookies.size());
        HashMap<String, Integer> nameToIndex = this.strict && cookies.size() > 1 ? new HashMap<String, Integer>() : null;
        int i = 0;
        boolean hasDupdName = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Cookie c = (Cookie)iterator.next();
            encoded.add(this.encode(c));
            if (nameToIndex == null) continue;
            hasDupdName |= nameToIndex.put(c.name(), i++) != null;
        }
        if (hasDupdName) {
            void var3_3;
            return ServerCookieEncoder.dedup(encoded, (Map<String, Integer>)var3_3);
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public final List<String> encode(Iterable<? extends Cookie> cookies) {
        cookiesIt = ((Iterable)ObjectUtil.checkNotNull(cookies, (String)"cookies")).iterator();
        if (!cookiesIt.hasNext()) {
            return Collections.emptyList();
        }
        encoded = new ArrayList<String>();
        firstCookie = (Cookie)cookiesIt.next();
        nameToIndex = this.strict != false && cookiesIt.hasNext() != false ? new HashMap<String, Integer>() : null;
        i = 0;
        encoded.add(this.encode(firstCookie));
        if (nameToIndex == null) ** GOTO lbl-1000
        ++i;
        if (nameToIndex.put(firstCookie.name(), 0) != null) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = hasDupdName = false;
        }
        while (cookiesIt.hasNext()) {
            c = (Cookie)cookiesIt.next();
            encoded.add(this.encode(c));
            if (nameToIndex == null) continue;
            hasDupdName |= nameToIndex.put(c.name(), i++) != null;
        }
        if (var3_4 != false) {
            return ServerCookieEncoder.dedup(encoded, nameToIndex);
        }
        return var2_2;
    }
}

