/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieDecoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class ServerCookieDecoder
extends CookieDecoder {
    private static final String RFC2965_VERSION = "$Version";
    private static final String RFC2965_PATH = "$Path";
    private static final String RFC2965_DOMAIN = "$Domain";
    private static final String RFC2965_PORT = "$Port";
    public static final ServerCookieDecoder STRICT = new ServerCookieDecoder(true);
    public static final ServerCookieDecoder LAX = new ServerCookieDecoder(false);

    /*
     * WARNING - void declaration
     */
    private ServerCookieDecoder(boolean strict) {
        super((boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Cookie> decodeAll(String header) {
        void var2_2;
        void var1_1;
        ArrayList cookies = new ArrayList();
        this.decode(cookies, (String)var1_1);
        return Collections.unmodifiableList(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final Set<Cookie> decode(String header) {
        void var2_2;
        void var1_1;
        TreeSet cookies = new TreeSet();
        this.decode(cookies, (String)var1_1);
        return var2_2;
    }

    private void decode(Collection<? super Cookie> cookies, String header) {
        int headerLen = ((String)ObjectUtil.checkNotNull((Object)header, (String)"header")).length();
        if (headerLen == 0) {
            return;
        }
        int i = 0;
        boolean rfc2965Style = false;
        if (header.regionMatches(true, 0, RFC2965_VERSION, 0, 8)) {
            i = header.indexOf(59) + 1;
            rfc2965Style = true;
        }
        while (i != headerLen) {
            DefaultCookie cookie;
            int valueBegin;
            int valueEnd;
            int nameEnd;
            int nameBegin;
            block9: {
                int n;
                char c = header.charAt(i);
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ',' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                do {
                    char curChar;
                    if ((curChar = header.charAt(i)) == ';') {
                        nameEnd = i;
                        valueEnd = -1;
                        valueBegin = -1;
                    } else {
                        if (nameEnd != 61) continue;
                        nameEnd = i++;
                        if (i == headerLen) {
                            valueEnd = 0;
                            valueBegin = 0;
                        } else {
                            valueBegin = i;
                            int semiPos = header.indexOf(59, i);
                            n = semiPos > 0 ? semiPos : headerLen;
                            valueEnd = n;
                        }
                    }
                    break block9;
                } while (++n != headerLen);
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
            }
            if (rfc2965Style && (header.regionMatches(nameBegin, RFC2965_PATH, 0, 5) || header.regionMatches(nameBegin, RFC2965_DOMAIN, 0, 7) || header.regionMatches(nameBegin, RFC2965_PORT, 0, 5)) || (cookie = this.initCookie(header, nameBegin, nameEnd, valueBegin, valueEnd)) == null) continue;
            cookies.add(cookie);
        }
    }
}

