/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.util.internal.ObjectUtil;

public class DefaultCookie
implements Cookie {
    private final String name;
    private String value;
    private boolean wrap;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private boolean secure;
    private boolean httpOnly;
    private CookieHeaderNames.SameSite sameSite;
    private boolean partitioned;

    /*
     * WARNING - void declaration
     */
    public DefaultCookie(String name, String value) {
        void var2_2;
        void var1_1;
        this.name = ObjectUtil.checkNonEmptyAfterTrim((String)var1_1, (String)"name");
        this.setValue((String)var2_2);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setValue(String value) {
        void var1_1;
        this.value = (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"value");
    }

    @Override
    public boolean wrap() {
        return this.wrap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setWrap(boolean wrap) {
        void var1_1;
        this.wrap = var1_1;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDomain(String domain) {
        void var1_1;
        this.domain = CookieUtil.validateAttributeValue("domain", (String)var1_1);
    }

    @Override
    public String path() {
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPath(String path) {
        void var1_1;
        this.path = CookieUtil.validateAttributeValue("path", (String)var1_1);
    }

    @Override
    public long maxAge() {
        return this.maxAge;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxAge(long maxAge) {
        void var1_1;
        this.maxAge = var1_1;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSecure(boolean secure) {
        void var1_1;
        this.secure = var1_1;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setHttpOnly(boolean httpOnly) {
        void var1_1;
        this.httpOnly = var1_1;
    }

    public CookieHeaderNames.SameSite sameSite() {
        return this.sameSite;
    }

    /*
     * WARNING - void declaration
     */
    public void setSameSite(CookieHeaderNames.SameSite sameSite) {
        void var1_1;
        this.sameSite = var1_1;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    /*
     * WARNING - void declaration
     */
    public void setPartitioned(boolean partitioned) {
        void var1_1;
        this.partitioned = var1_1;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie that = (Cookie)o;
        if (!this.name().equals(that.name())) {
            return false;
        }
        if (this.path() == null) {
            if (that.path() != null) {
                return false;
            }
        } else {
            if (that.path() == null) {
                return false;
            }
            if (!this.path().equals(that.path())) {
                return false;
            }
        }
        if (this.domain() == null) {
            return that.domain() == null;
        }
        return this.domain().equalsIgnoreCase(var1_1.domain());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Cookie c) {
        int n;
        int v = this.name().compareTo(c.name());
        if (v != 0) {
            return v;
        }
        if (this.path() == null) {
            if (c.path() != null) {
                return -1;
            }
        } else {
            if (c.path() == null) {
                return 1;
            }
            v = this.path().compareTo(c.path());
            if (v != 0) {
                return n;
            }
        }
        if (this.domain() == null) {
            if (c.domain() != null) {
                return -1;
            }
        } else {
            void var1_1;
            if (c.domain() == null) {
                return 1;
            }
            n = this.domain().compareToIgnoreCase(var1_1.domain());
            return n;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected String validateValue(String name, String value) {
        void var2_2;
        return CookieUtil.validateAttributeValue(name, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = CookieUtil.stringBuilder().append(this.name()).append('=').append(this.value());
        if (this.domain() != null) {
            buf.append(", domain=").append(this.domain());
        }
        if (this.path() != null) {
            buf.append(", path=").append(this.path());
        }
        if (this.maxAge() >= 0L) {
            buf.append(", maxAge=").append(this.maxAge()).append('s');
        }
        if (this.isSecure()) {
            buf.append(", secure");
        }
        if (this.isHttpOnly()) {
            buf.append(", HTTPOnly");
        }
        if (this.sameSite() != null) {
            buf.append(", SameSite=").append((Object)this.sameSite());
        }
        if (this.isPartitioned()) {
            buf.append(", Partitioned");
        }
        return var1_1.toString();
    }
}

