/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.util.internal.InternalThreadLocalMap;
import java.util.BitSet;

final class CookieUtil {
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = CookieUtil.validCookieAttributeValueOctets();

    /*
     * WARNING - void declaration
     */
    private static BitSet validCookieNameOctets() {
        void var0;
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        int[] nArray = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9};
        int[] nArray2 = nArray;
        nArray2 = nArray;
        int cfr_ignored_0 = nArray.length;
        for (int i = 0; i < 19; ++i) {
            void var3_4;
            int separator = nArray2[i];
            bits.set((int)var3_4, false);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static BitSet validCookieValueOctets() {
        void var0;
        int i;
        BitSet bits = new BitSet();
        bits.set(33);
        for (i = 35; i <= 43; ++i) {
            bits.set(i);
        }
        for (i = 45; i <= 58; ++i) {
            bits.set(i);
        }
        for (i = 60; i <= 91; ++i) {
            bits.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            bits.set(i);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static BitSet validCookieAttributeValueOctets() {
        void var0;
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        bits.set(59, false);
        return var0;
    }

    static StringBuilder stringBuilder() {
        return InternalThreadLocalMap.get().stringBuilder();
    }

    static String stripTrailingSeparatorOrNull(StringBuilder buf) {
        StringBuilder stringBuilder;
        if (buf.length() == 0) {
            return null;
        }
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    static String stripTrailingSeparator(StringBuilder buf) {
        StringBuilder stringBuilder;
        if (buf.length() > 0) {
            StringBuilder stringBuilder2 = buf;
            stringBuilder2.setLength(stringBuilder2.length() - 2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    static void add(StringBuilder sb, String name, long val) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        sb.append((String)var1_1);
        sb.append('=');
        sb.append((long)var2_2);
        sb.append(';');
        stringBuilder.append(' ');
    }

    /*
     * WARNING - void declaration
     */
    static void add(StringBuilder sb, String name, String val) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        sb.append((String)var1_1);
        sb.append('=');
        sb.append((String)var2_2);
        sb.append(';');
        stringBuilder.append(' ');
    }

    /*
     * WARNING - void declaration
     */
    static void add(StringBuilder sb, String name) {
        StringBuilder stringBuilder;
        void var1_1;
        sb.append((String)var1_1);
        sb.append(';');
        stringBuilder.append(' ');
    }

    /*
     * WARNING - void declaration
     */
    static void addQuoted(StringBuilder sb, String name, String val) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        if (val == null) {
            val = "";
        }
        sb.append((String)var1_1);
        sb.append('=');
        sb.append('\"');
        sb.append((String)var2_2);
        sb.append('\"');
        sb.append(';');
        stringBuilder.append(' ');
    }

    static int firstInvalidCookieNameOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_VALUE_OCTETS);
    }

    /*
     * WARNING - void declaration
     */
    static int firstInvalidOctet(CharSequence cs, BitSet bits) {
        for (int i = 0; i < cs.length(); ++i) {
            void var3_3;
            char c = cs.charAt(i);
            if (bits.get((int)var3_3)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    static CharSequence unwrapValue(CharSequence cs) {
        CharSequence charSequence;
        int len = cs.length();
        if (len > 0 && cs.charAt(0) == '\"') {
            if (len >= 2 && cs.charAt(len - 1) == '\"') {
                void var1_1;
                if (len == 2) {
                    return "";
                }
                return cs.subSequence(1, (int)(var1_1 - true));
            }
            return null;
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    static String validateAttributeValue(String name, String value) {
        void var1_1;
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        int i = CookieUtil.firstInvalidOctet(value, VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS);
        if (i != -1) {
            void var2_2;
            String string;
            throw new IllegalArgumentException(string + " contains the prohibited characters: " + value.charAt((int)var2_2));
        }
        return var1_1;
    }

    private CookieUtil() {
    }
}

