/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.CharBuffer;

public abstract class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final boolean strict;

    /*
     * WARNING - void declaration
     */
    protected CookieDecoder(boolean strict) {
        void var1_1;
        this.strict = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DefaultCookie initCookie(String header, int nameBegin, int nameEnd, int valueBegin, int valueEnd) {
        void var1_1;
        void var3_3;
        boolean wrap;
        int invalidOctetPos;
        if (nameBegin == -1 || nameBegin == nameEnd) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (valueBegin == -1) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
        CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
        if (unwrappedValue == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)wrappedValue);
            return null;
        }
        String name = header.substring(nameBegin, nameEnd);
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieNameOctet(name)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                String string = name;
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)string, (Object)Character.valueOf(string.charAt(invalidOctetPos)));
            }
            return null;
        }
        boolean bl = wrap = unwrappedValue.length() != valueEnd - valueBegin;
        if (this.strict && (invalidOctetPos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                void var2_2;
                CharSequence charSequence = unwrappedValue;
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)charSequence, (Object)Character.valueOf(charSequence.charAt((int)var2_2)));
            }
            return null;
        }
        DefaultCookie cookie = new DefaultCookie(name, unwrappedValue.toString());
        cookie.setWrap((boolean)var3_3);
        return var1_1;
    }
}

