/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieEncoder;
import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);
    static final Comparator<Cookie> COOKIE_COMPARATOR = new Comparator<Cookie>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(Cookie c1, Cookie c2) {
            void var1_2;
            void var2_3;
            String path1 = c1.path();
            String path2 = c2.path();
            int len1 = path1 == null ? Integer.MAX_VALUE : path1.length();
            int n = path2 == null ? Integer.MAX_VALUE : var2_3.length();
            return n - var1_2;
        }
    };

    /*
     * WARNING - void declaration
     */
    private ClientCookieEncoder(boolean strict) {
        super((boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(String name, String value) {
        void var2_2;
        void var1_1;
        return this.encode((Cookie)new DefaultCookie((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(Cookie cookie) {
        void var2_2;
        void var1_1;
        StringBuilder buf = CookieUtil.stringBuilder();
        this.encode(buf, (Cookie)ObjectUtil.checkNotNull((Object)var1_1, (String)"cookie"));
        return CookieUtil.stripTrailingSeparator((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(Cookie ... cookies) {
        void var2_2;
        void var1_1;
        if (((Cookie[])ObjectUtil.checkNotNull((Object)cookies, (String)"cookies")).length == 0) {
            return null;
        }
        StringBuilder buf = CookieUtil.stringBuilder();
        if (this.strict) {
            if (cookies.length == 1) {
                this.encode(buf, cookies[0]);
            } else {
                Cookie[] cookiesSorted = Arrays.copyOf(cookies, cookies.length);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                Cookie[] cookieArray = cookiesSorted;
                int n = cookiesSorted.length;
                for (int i = 0; i < n; ++i) {
                    Cookie c = cookieArray[i];
                    this.encode(buf, (Cookie)var1_1);
                }
            }
        } else {
            for (void c : var1_1) {
                this.encode(buf, (Cookie)c);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(Collection<? extends Cookie> cookies) {
        void var2_3;
        Iterator iterator;
        if (((Collection)ObjectUtil.checkNotNull(cookies, (String)"cookies")).isEmpty()) {
            return null;
        }
        StringBuilder buf = CookieUtil.stringBuilder();
        if (this.strict) {
            if (cookies.size() == 1) {
                this.encode(buf, cookies.iterator().next());
            } else {
                Cookie[] cookiesSorted = cookies.toArray(new Cookie[0]);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Iterator c : iterator) {
                    this.encode(buf, (Cookie)((Object)c));
                }
            }
        } else {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_5;
                Cookie c = (Cookie)iterator.next();
                this.encode(buf, (Cookie)var3_5);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull((StringBuilder)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final String encode(Iterable<? extends Cookie> cookies) {
        void var2_2;
        void var1_1;
        Iterator cookiesIt = ((Iterable)ObjectUtil.checkNotNull(cookies, (String)"cookies")).iterator();
        if (!cookiesIt.hasNext()) {
            return null;
        }
        StringBuilder buf = CookieUtil.stringBuilder();
        if (this.strict) {
            Cookie firstCookie = (Cookie)cookiesIt.next();
            if (!cookiesIt.hasNext()) {
                this.encode(buf, firstCookie);
            } else {
                void var3_3;
                ArrayList cookiesList = InternalThreadLocalMap.get().arrayList();
                cookiesList.add(var3_3);
                while (cookiesIt.hasNext()) {
                    cookiesList.add(cookiesIt.next());
                }
                Cookie[] cookiesSorted = cookiesList.toArray(new Cookie[0]);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (void c : var1_1) {
                    this.encode(buf, (Cookie)c);
                }
            }
        } else {
            while (var1_1.hasNext()) {
                this.encode(buf, (Cookie)var1_1.next());
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void encode(StringBuilder buf, Cookie c) {
        void var3_3;
        void var1_1;
        void var2_2;
        String name = c.name();
        String value = c.value() != null ? c.value() : "";
        this.validateCookie(name, value);
        if (var2_2.wrap()) {
            CookieUtil.addQuoted(buf, name, value);
            return;
        }
        CookieUtil.add((StringBuilder)var1_1, (String)var3_3, value);
    }
}

