/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieDecoder;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.ObjectUtil;
import java.util.Date;

public final class ClientCookieDecoder
extends CookieDecoder {
    public static final ClientCookieDecoder STRICT = new ClientCookieDecoder(true);
    public static final ClientCookieDecoder LAX = new ClientCookieDecoder(false);

    /*
     * WARNING - void declaration
     */
    private ClientCookieDecoder(boolean strict) {
        super((boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Cookie decode(String header) {
        char c;
        int headerLen = ((String)ObjectUtil.checkNotNull((Object)header, (String)"header")).length();
        if (headerLen == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int i = 0;
        while (i != headerLen && (c = header.charAt(i)) != ',') {
            void var6_6;
            int valueBegin;
            int valueEnd;
            int nameEnd;
            int nameBegin;
            block12: {
                int n;
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                do {
                    char curChar;
                    if ((curChar = header.charAt(i)) == ';') {
                        nameEnd = i;
                        valueEnd = -1;
                        valueBegin = -1;
                    } else {
                        if (nameEnd != 61) continue;
                        nameEnd = i++;
                        if (i == headerLen) {
                            valueEnd = 0;
                            valueBegin = 0;
                        } else {
                            valueBegin = i;
                            int semiPos = header.indexOf(59, i);
                            n = semiPos > 0 ? semiPos : headerLen;
                            valueEnd = n;
                        }
                    }
                    break block12;
                } while (++n != headerLen);
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
            }
            if (valueEnd > 0 && header.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (cookieBuilder == null) {
                DefaultCookie cookie = this.initCookie(header, nameBegin, nameEnd, valueBegin, valueEnd);
                if (cookie == null) {
                    return null;
                }
                cookieBuilder = new CookieBuilder(cookie, header);
                continue;
            }
            cookieBuilder.appendAttribute(nameBegin, (int)var6_6, valueBegin, valueEnd);
        }
        if (cookieBuilder != null) {
            void var3_3;
            return var3_3.cookie();
        }
        return null;
    }

    private static class CookieBuilder {
        private final String header;
        private final DefaultCookie cookie;
        private String domain;
        private String path;
        private long maxAge = Long.MIN_VALUE;
        private int expiresStart;
        private int expiresEnd;
        private boolean secure;
        private boolean httpOnly;
        private CookieHeaderNames.SameSite sameSite;
        private boolean partitioned;

        /*
         * WARNING - void declaration
         */
        CookieBuilder(DefaultCookie cookie, String header) {
            void var2_2;
            void var1_1;
            this.cookie = var1_1;
            this.header = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private long mergeMaxAgeAndExpires() {
            Date expiresDate;
            if (this.maxAge != Long.MIN_VALUE) {
                return this.maxAge;
            }
            if (CookieBuilder.isValueDefined(this.expiresStart, this.expiresEnd) && (expiresDate = DateFormatter.parseHttpDate((CharSequence)this.header, (int)this.expiresStart, (int)this.expiresEnd)) != null) {
                void var2_2;
                void var1_1;
                long maxAgeMillis = var1_1.getTime() - System.currentTimeMillis();
                return maxAgeMillis / 1000L + (long)(var2_2 % 1000L != 0L ? 1 : 0);
            }
            return Long.MIN_VALUE;
        }

        Cookie cookie() {
            this.cookie.setDomain(this.domain);
            this.cookie.setPath(this.path);
            this.cookie.setMaxAge(this.mergeMaxAgeAndExpires());
            this.cookie.setSecure(this.secure);
            this.cookie.setHttpOnly(this.httpOnly);
            this.cookie.setSameSite(this.sameSite);
            this.cookie.setPartitioned(this.partitioned);
            return this.cookie;
        }

        /*
         * WARNING - void declaration
         */
        void appendAttribute(int keyStart, int keyEnd, int valueStart, int valueEnd) {
            void var2_2;
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(keyStart, valueStart, valueEnd);
                return;
            }
            if (length == 6) {
                this.parse6(keyStart, valueStart, valueEnd);
                return;
            }
            if (length == 7) {
                this.parse7(keyStart, valueStart, valueEnd);
                return;
            }
            if (length == 8) {
                void var3_3;
                this.parse8(keyStart, (int)var3_3, valueEnd);
                return;
            }
            if (var2_2 == 11) {
                void var1_1;
                this.parse11((int)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void parse4(int nameStart, int valueStart, int valueEnd) {
            void var1_1;
            if (this.header.regionMatches(true, (int)var1_1, "Path", 0, 4)) {
                void var3_3;
                void var2_2;
                this.path = this.computeValue((int)var2_2, (int)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void parse6(int nameStart, int valueStart, int valueEnd) {
            void var1_1;
            if (this.header.regionMatches(true, nameStart, "Domain", 0, 5)) {
                void var3_3;
                void var2_2;
                this.domain = this.computeValue((int)var2_2, (int)var3_3);
                return;
            }
            if (this.header.regionMatches(true, (int)var1_1, "Secure", 0, 5)) {
                this.secure = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void setMaxAge(String value) {
            try {
                void var1_1;
                this.maxAge = Math.max(Long.parseLong((String)var1_1), 0L);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void parse7(int nameStart, int valueStart, int valueEnd) {
            void var1_1;
            if (this.header.regionMatches(true, nameStart, "Expires", 0, 7)) {
                this.expiresStart = valueStart;
                this.expiresEnd = valueEnd;
                return;
            }
            if (this.header.regionMatches(true, (int)var1_1, "Max-Age", 0, 7)) {
                void var3_3;
                void var2_2;
                CookieBuilder cookieBuilder = this;
                cookieBuilder.setMaxAge(cookieBuilder.computeValue((int)var2_2, (int)var3_3));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void parse8(int nameStart, int valueStart, int valueEnd) {
            void var1_1;
            if (this.header.regionMatches(true, nameStart, "HTTPOnly", 0, 8)) {
                this.httpOnly = true;
                return;
            }
            if (this.header.regionMatches(true, (int)var1_1, "SameSite", 0, 8)) {
                void var3_3;
                void var2_2;
                this.sameSite = CookieHeaderNames.SameSite.of(this.computeValue((int)var2_2, (int)var3_3));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void parse11(int nameStart) {
            void var1_1;
            if (this.header.regionMatches(true, (int)var1_1, "Partitioned", 0, 11)) {
                this.partitioned = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static boolean isValueDefined(int valueStart, int valueEnd) {
            void var1_1;
            int n;
            return valueStart != -1 && n != var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private String computeValue(int valueStart, int valueEnd) {
            if (CookieBuilder.isValueDefined(valueStart, valueEnd)) {
                void var2_2;
                void var1_1;
                return this.header.substring((int)var1_1, (int)var2_2);
            }
            return null;
        }
    }
}

