/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ReadOnlyHttpHeaders
extends HttpHeaders {
    private final CharSequence[] nameValuePairs;

    /*
     * WARNING - void declaration
     */
    public ReadOnlyHttpHeaders(boolean validateHeaders, CharSequence ... nameValuePairs) {
        void var2_2;
        void var1_1;
        if ((nameValuePairs.length & 1) != 0) {
            throw ReadOnlyHttpHeaders.newInvalidArraySizeException();
        }
        if (var1_1 != false) {
            ReadOnlyHttpHeaders.validateHeaders(nameValuePairs);
        }
        this.nameValuePairs = var2_2;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("nameValuePairs must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(CharSequence ... keyValuePairs) {
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            DefaultHttpHeadersFactory.headersFactory().getNameValidator().validateName((Object)keyValuePairs[i]);
        }
    }

    private CharSequence get0(CharSequence name) {
        int nameHash = AsciiString.hashCode((CharSequence)name);
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            CharSequence roName = this.nameValuePairs[i];
            if (AsciiString.hashCode((CharSequence)roName) != nameHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)roName, (CharSequence)name)) continue;
            return this.nameValuePairs[i + 1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String get(String name) {
        void var1_1;
        CharSequence value = this.get0(name);
        if (value == null) {
            return null;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Integer getInt(CharSequence name) {
        void var1_1;
        CharSequence value = this.get0(name);
        if (value == null) {
            return null;
        }
        return CharSequenceValueConverter.INSTANCE.convertToInt((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getInt(CharSequence name, int defaultValue) {
        void var1_1;
        CharSequence value = this.get0(name);
        if (value == null) {
            void var2_2;
            return (int)var2_2;
        }
        return CharSequenceValueConverter.INSTANCE.convertToInt((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Short getShort(CharSequence name) {
        void var1_1;
        CharSequence value = this.get0(name);
        if (value == null) {
            return null;
        }
        return CharSequenceValueConverter.INSTANCE.convertToShort((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final short getShort(CharSequence name, short defaultValue) {
        void var1_1;
        CharSequence value = this.get0(name);
        if (value == null) {
            void var2_2;
            return (short)var2_2;
        }
        return CharSequenceValueConverter.INSTANCE.convertToShort((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Long getTimeMillis(CharSequence name) {
        void var1_1;
        CharSequence value = this.get0(name);
        if (value == null) {
            return null;
        }
        return CharSequenceValueConverter.INSTANCE.convertToTimeMillis((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long getTimeMillis(CharSequence name, long defaultValue) {
        void var1_1;
        CharSequence value = this.get0(name);
        if (value == null) {
            void var2_2;
            return (long)var2_2;
        }
        return CharSequenceValueConverter.INSTANCE.convertToTimeMillis((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<String> getAll(String name) {
        void var3_3;
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptyList();
        }
        int nameHash = AsciiString.hashCode((CharSequence)name);
        ArrayList<String> values = new ArrayList<String>(4);
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            CharSequence roName = this.nameValuePairs[i];
            if (AsciiString.hashCode((CharSequence)roName) != nameHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)roName, (CharSequence)name)) continue;
            values.add(this.nameValuePairs[i + 1].toString());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Map.Entry<String, String>> entries() {
        void var1_1;
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AbstractMap.SimpleImmutableEntry<String, String>> entries = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>(((HttpHeaders)this).size());
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            entries.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.nameValuePairs[i].toString(), this.nameValuePairs[i + 1].toString()));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(String name) {
        void var1_1;
        return this.get0((CharSequence)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(String name, String value, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ((HttpHeaders)this).containsValue((CharSequence)var1_1, (CharSequence)var2_2, (boolean)var3_3);
    }

    @Override
    public final boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        int i;
        if (ignoreCase) {
            for (i = 0; i < this.nameValuePairs.length; i += 2) {
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)this.nameValuePairs[i], (CharSequence)name) || !AsciiString.contentEqualsIgnoreCase((CharSequence)this.nameValuePairs[i + 1], (CharSequence)value)) continue;
                return true;
            }
        } else {
            for (i = 0; i < this.nameValuePairs.length; i += 2) {
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)this.nameValuePairs[i], (CharSequence)name) || !AsciiString.contentEquals((CharSequence)this.nameValuePairs[i + 1], (CharSequence)value)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<String> valueStringIterator(CharSequence name) {
        void var1_1;
        return new ReadOnlyStringValueIterator((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Iterator<CharSequence> valueCharSequenceIterator(CharSequence name) {
        void var1_1;
        return new ReadOnlyValueIterator((CharSequence)var1_1);
    }

    @Override
    public final Iterator<Map.Entry<String, String>> iterator() {
        return new ReadOnlyStringIterator();
    }

    @Override
    public final Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new ReadOnlyIterator();
    }

    @Override
    public final boolean isEmpty() {
        return this.nameValuePairs.length == 0;
    }

    @Override
    public final int size() {
        return this.nameValuePairs.length >>> 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<String> names() {
        void var1_1;
        if (((HttpHeaders)this).isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>(((HttpHeaders)this).size());
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            names.add(this.nameValuePairs[i].toString());
        }
        return var1_1;
    }

    @Override
    public final HttpHeaders add(String name, Object value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders add(String name, Iterable<?> values) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders addInt(CharSequence name, int value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders addShort(CharSequence name, short value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders set(String name, Object value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders set(String name, Iterable<?> values) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders setInt(CharSequence name, int value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders setShort(CharSequence name, short value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders remove(String name) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public final HttpHeaders clear() {
        throw new UnsupportedOperationException("read only");
    }

    private final class ReadOnlyValueIterator
    implements Iterator<CharSequence> {
        private final CharSequence name;
        private final int nameHash;
        private int nextNameIndex;

        /*
         * WARNING - void declaration
         */
        ReadOnlyValueIterator(CharSequence name) {
            void var2_2;
            this.name = name;
            this.nameHash = AsciiString.hashCode((CharSequence)var2_2);
            this.nextNameIndex = this.findNextValue();
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CharSequence next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CharSequence value = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1];
            this.nextNameIndex = this.findNextValue();
            return var1_1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        /*
         * WARNING - void declaration
         */
        private int findNextValue() {
            for (int i = this.nextNameIndex; i < ReadOnlyHttpHeaders.this.nameValuePairs.length; i += 2) {
                void var2_2;
                CharSequence roName = ReadOnlyHttpHeaders.this.nameValuePairs[i];
                if (this.nameHash != AsciiString.hashCode((CharSequence)roName) || !AsciiString.contentEqualsIgnoreCase((CharSequence)this.name, (CharSequence)var2_2)) continue;
                return i;
            }
            return -1;
        }
    }

    private final class ReadOnlyStringValueIterator
    implements Iterator<String> {
        private final CharSequence name;
        private final int nameHash;
        private int nextNameIndex;

        /*
         * WARNING - void declaration
         */
        ReadOnlyStringValueIterator(CharSequence name) {
            void var2_2;
            this.name = name;
            this.nameHash = AsciiString.hashCode((CharSequence)var2_2);
            this.nextNameIndex = this.findNextValue();
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String value = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1].toString();
            this.nextNameIndex = this.findNextValue();
            return var1_1;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        /*
         * WARNING - void declaration
         */
        private int findNextValue() {
            for (int i = this.nextNameIndex; i < ReadOnlyHttpHeaders.this.nameValuePairs.length; i += 2) {
                void var2_2;
                CharSequence roName = ReadOnlyHttpHeaders.this.nameValuePairs[i];
                if (this.nameHash != AsciiString.hashCode((CharSequence)roName) || !AsciiString.contentEqualsIgnoreCase((CharSequence)this.name, (CharSequence)var2_2)) continue;
                return i;
            }
            return -1;
        }
    }

    private final class ReadOnlyStringIterator
    implements Iterator<Map.Entry<String, String>>,
    Map.Entry<String, String> {
        private String key;
        private String value;
        private int nextNameIndex;

        private ReadOnlyStringIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != ReadOnlyHttpHeaders.this.nameValuePairs.length;
        }

        @Override
        public final Map.Entry<String, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex].toString();
            this.value = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1].toString();
            this.nextNameIndex += 2;
            return this;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        @Override
        public final String getValue() {
            return this.value;
        }

        @Override
        public final String setValue(String value) {
            throw new UnsupportedOperationException("read only");
        }

        public final String toString() {
            return this.key + '=' + this.value;
        }
    }

    private final class ReadOnlyIterator
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private CharSequence key;
        private CharSequence value;
        private int nextNameIndex;

        private ReadOnlyIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.nextNameIndex != ReadOnlyHttpHeaders.this.nameValuePairs.length;
        }

        @Override
        public final Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex];
            this.value = ReadOnlyHttpHeaders.this.nameValuePairs[this.nextNameIndex + 1];
            this.nextNameIndex += 2;
            return this;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public final CharSequence getKey() {
            return this.key;
        }

        @Override
        public final CharSequence getValue() {
            return this.value;
        }

        @Override
        public final CharSequence setValue(CharSequence value) {
            throw new UnsupportedOperationException("read only");
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }
}

