/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;

public class QueryStringEncoder {
    private final Charset charset;
    private final StringBuilder uriBuilder;
    private boolean hasParams;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final char[] CHAR_MAP = "0123456789ABCDEF".toCharArray();

    /*
     * WARNING - void declaration
     */
    public QueryStringEncoder(String uri) {
        this((String)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringEncoder(String uri, Charset charset) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.uriBuilder = new StringBuilder((String)var1_1);
        this.charset = CharsetUtil.UTF_8.equals(charset) ? null : var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void addParam(String name, String value) {
        void var1_1;
        ObjectUtil.checkNotNull((Object)name, (String)"name");
        if (this.hasParams) {
            this.uriBuilder.append('&');
        } else {
            this.uriBuilder.append('?');
            this.hasParams = true;
        }
        this.encodeComponent((CharSequence)var1_1);
        if (value != null) {
            void var2_2;
            this.uriBuilder.append('=');
            this.encodeComponent((CharSequence)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeComponent(CharSequence s) {
        void var1_1;
        if (this.charset == null) {
            this.encodeUtf8Component(s);
            return;
        }
        this.encodeNonUtf8Component((CharSequence)var1_1);
    }

    public URI toUri() throws URISyntaxException {
        return new URI(this.toString());
    }

    public String toString() {
        return this.uriBuilder.toString();
    }

    private void encodeNonUtf8Component(CharSequence s) {
        char[] buf = null;
        int i = 0;
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (QueryStringEncoder.dontNeedEncoding(c)) {
                this.uriBuilder.append(c);
                ++i;
                continue;
            }
            int index = 0;
            if (buf == null) {
                buf = new char[s.length() - i];
            }
            do {
                buf[index] = c;
                ++index;
            } while (++i < s.length() && !QueryStringEncoder.dontNeedEncoding(c = s.charAt(i)));
            byte[] byArray = new String(buf, 0, index).getBytes(this.charset);
            byte[] byArray2 = byArray;
            byArray2 = byArray;
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                byte b = byArray2[j];
                this.appendEncoded(b);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void encodeUtf8Component(CharSequence s) {
        void var1_1;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (QueryStringEncoder.dontNeedEncoding(c)) continue;
            this.encodeUtf8Component(s, i, len);
            return;
        }
        this.uriBuilder.append((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeUtf8Component(CharSequence s, int encodingStart, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (encodingStart > 0) {
            this.uriBuilder.append(s, 0, encodingStart);
        }
        this.encodeUtf8ComponentSlow((CharSequence)var1_1, (int)var2_2, (int)var3_3);
    }

    private void encodeUtf8ComponentSlow(CharSequence s, int start, int len) {
        for (int i = start; i < len; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                if (QueryStringEncoder.dontNeedEncoding(c)) {
                    this.uriBuilder.append(c);
                    continue;
                }
                this.appendEncoded(c);
                continue;
            }
            if (c < '\u0800') {
                this.appendEncoded(0xC0 | c >> 6);
                this.appendEncoded(0x80 | c & 0x3F);
                continue;
            }
            if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    this.appendEncoded(63);
                    continue;
                }
                if (++i == s.length()) {
                    this.appendEncoded(63);
                    return;
                }
                this.writeUtf8Surrogate(c, s.charAt(i));
                continue;
            }
            this.appendEncoded(0xE0 | c >> 12);
            this.appendEncoded(0x80 | c >> 6 & 0x3F);
            this.appendEncoded(0x80 | c & 0x3F);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeUtf8Surrogate(char c, char c2) {
        void var1_1;
        void var2_2;
        if (!Character.isLowSurrogate(c2)) {
            this.appendEncoded(63);
            this.appendEncoded(Character.isHighSurrogate(c2) ? 63 : (int)c2);
            return;
        }
        int codePoint = Character.toCodePoint(c, (char)var2_2);
        this.appendEncoded(0xF0 | codePoint >> 18);
        this.appendEncoded(0x80 | codePoint >> 12 & 0x3F);
        this.appendEncoded(0x80 | codePoint >> 6 & 0x3F);
        this.appendEncoded(0x80 | var1_1 & 0x3F);
    }

    /*
     * WARNING - void declaration
     */
    private void appendEncoded(int b) {
        void var1_1;
        this.uriBuilder.append('%').append(QueryStringEncoder.forDigit(b >> 4)).append(QueryStringEncoder.forDigit((int)var1_1));
    }

    private static char forDigit(int digit) {
        int n;
        return CHAR_MAP[n & 0xF];
    }

    private static boolean dontNeedEncoding(char ch) {
        char c;
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '*' || c == '~';
    }
}

