/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private final boolean semicolonIsNormalChar;
    private int pathEndIdx;
    private String path;
    private Map<String, List<String>> params;

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(String uri) {
        this((String)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(String uri, boolean hasPath) {
        this((String)var1_1, HttpConstants.DEFAULT_CHARSET, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(String uri, Charset charset) {
        this((String)var1_1, (Charset)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(String uri, Charset charset, boolean hasPath) {
        this((String)var1_1, (Charset)var2_2, (boolean)var3_3, 1024);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(String uri, Charset charset, boolean hasPath, int maxParams) {
        this((String)var1_1, (Charset)var2_2, (boolean)var3_3, maxParams, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(String uri, Charset charset, boolean hasPath, int maxParams, boolean semicolonIsNormalChar) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.uri = (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"uri");
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)var2_2, (String)"charset");
        this.maxParams = ObjectUtil.checkPositive((int)maxParams, (String)"maxParams");
        this.semicolonIsNormalChar = semicolonIsNormalChar;
        this.pathEndIdx = var3_3 != false ? -1 : 0;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(URI uri) {
        this((URI)var1_1, HttpConstants.DEFAULT_CHARSET);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(URI uri, Charset charset) {
        this((URI)var1_1, (Charset)var2_2, 1024);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(URI uri, Charset charset, int maxParams) {
        this((URI)var1_1, (Charset)var2_2, (int)var3_3, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueryStringDecoder(URI uri, Charset charset, int maxParams, boolean semicolonIsNormalChar) {
        void var3_3;
        void var2_2;
        void var1_1;
        String rawQuery;
        String rawPath = uri.getRawPath();
        if (rawPath == null) {
            rawPath = "";
        }
        this.uri = (rawQuery = uri.getRawQuery()) == null ? rawPath : rawPath + '?' + (String)var1_1;
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)var2_2, (String)"charset");
        this.maxParams = ObjectUtil.checkPositive((int)var3_3, (String)"maxParams");
        this.semicolonIsNormalChar = semicolonIsNormalChar;
        this.pathEndIdx = rawPath.length();
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            this.path = QueryStringDecoder.decodeComponent(this.uri, 0, this.pathEndIdx(), this.charset, true);
        }
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = QueryStringDecoder.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams, this.semicolonIsNormalChar);
        }
        return this.params;
    }

    public String rawPath() {
        return this.uri.substring(0, this.pathEndIdx());
    }

    /*
     * WARNING - void declaration
     */
    public String rawQuery() {
        int start = this.pathEndIdx() + 1;
        if (start < this.uri.length()) {
            void var1_1;
            return this.uri.substring((int)var1_1);
        }
        return "";
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Map<String, List<String>> decodeParams(String s, int from, Charset charset, int paramsLimit, boolean semicolonIsNormalChar) {
        void var2_2;
        void var1_1;
        String string;
        void i;
        int len = s.length();
        if (from >= len) {
            return Collections.emptyMap();
        }
        if (s.charAt(from) == '?') {
            ++from;
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int nameStart = from;
        int valueStart = -1;
        block6: while (i < len) {
            switch (s.charAt((int)i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + true;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + true;
                    break;
                }
                case ';': {
                    if (semicolonIsNormalChar) break;
                }
                case '&': {
                    if (QueryStringDecoder.addParam(s, nameStart, valueStart, (int)i, params, charset) && --paramsLimit == 0) {
                        return params;
                    }
                    nameStart = i + true;
                    break;
                }
                case '#': {
                    break block6;
                }
            }
            ++i;
        }
        QueryStringDecoder.addParam(string, nameStart, valueStart, (int)var1_1, params, (Charset)var2_2);
        return params;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean addParam(String s, int nameStart, int valueStart, int valueEnd, Map<String, List<String>> params, Charset charset) {
        String string;
        void var2_4;
        void var3_5;
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = QueryStringDecoder.decodeComponent(s, nameStart, valueStart - 1, charset, false);
        String value = QueryStringDecoder.decodeComponent(s, valueStart, (int)var3_5, charset, false);
        List<String> values = params.get(name);
        if (values == null) {
            void var1_2;
            values = new ArrayList<String>(1);
            params.put((String)var1_2, values);
        }
        var2_4.add(string);
        return true;
    }

    public static String decodeComponent(String s) {
        return QueryStringDecoder.decodeComponent(s, HttpConstants.DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeComponent(String s, Charset charset) {
        void var1_1;
        String string;
        if (s == null) {
            return "";
        }
        return QueryStringDecoder.decodeComponent(s, 0, string.length(), (Charset)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeComponent(String s, int from, int toExcluded, Charset charset, boolean isPath) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i = from; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        int n = (toExcluded - firstEscaped) / 3;
        byte[] buf = PlatformDependent.allocateUninitializedArray((int)n);
        StringBuilder strBuf = new StringBuilder(len);
        strBuf.append(s, from, firstEscaped);
        for (int i = firstEscaped; i < toExcluded; ++i) {
            void var1_1;
            char c = s.charAt(i);
            if (c != '%') {
                strBuf.append(c != '+' || isPath ? c : (char)' ');
                continue;
            }
            int bufIdx = 0;
            do {
                if (i + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + s);
                }
                buf[bufIdx++] = StringUtil.decodeHexByte((CharSequence)s, (int)(i + 1));
            } while ((i += 3) < toExcluded && s.charAt(i) == '%');
            --i;
            strBuf.append(new String(buf, 0, (int)var1_1, charset));
        }
        return strBuf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static int findPathEndIndex(String uri) {
        void var1_1;
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            void var3_3;
            char c = uri.charAt(i);
            if (c != '?' && var3_3 != 35) continue;
            return i;
        }
        return (int)var1_1;
    }
}

