/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpVersion
implements Comparable<HttpVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\S+)/(\\d+)\\.(\\d+)");
    static final String HTTP_1_0_STRING = "HTTP/1.0";
    static final String HTTP_1_1_STRING = "HTTP/1.1";
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP", 1, 0, false, true);
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP", 1, 1, true, true);
    private final String protocolName;
    private final int majorVersion;
    private final int minorVersion;
    private final String text;
    private final boolean keepAliveDefault;
    private final byte[] bytes;

    public static HttpVersion valueOf(String text) {
        return HttpVersion.valueOf(text, false);
    }

    /*
     * WARNING - void declaration
     */
    static HttpVersion valueOf(String text, boolean strict) {
        void var2_2;
        ObjectUtil.checkNotNull((Object)text, (String)"text");
        if (text == HTTP_1_1_STRING) {
            return HTTP_1_1;
        }
        if (text == HTTP_1_0_STRING) {
            return HTTP_1_0;
        }
        if ((text = text.trim()).isEmpty()) {
            throw new IllegalArgumentException("text is empty (possibly HTTP/0.9)");
        }
        HttpVersion version = HttpVersion.version0(text);
        if (version == null) {
            void var1_1;
            String string;
            version = new HttpVersion(string, (boolean)var1_1, true);
        }
        return var2_2;
    }

    private static HttpVersion version0(String text) {
        String string;
        if (HTTP_1_1_STRING.equals(text)) {
            return HTTP_1_1;
        }
        if (HTTP_1_0_STRING.equals(string)) {
            return HTTP_1_0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public HttpVersion(String text, boolean keepAliveDefault) {
        this((String)var1_1, false, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    HttpVersion(String text, boolean strict, boolean keepAliveDefault) {
        void var3_4;
        text = ObjectUtil.checkNonEmptyAfterTrim((String)text, (String)"text").toUpperCase();
        if (strict) {
            if (text.length() != 8 || !text.startsWith("HTTP/") || text.charAt(6) != '.') {
                throw new IllegalArgumentException("invalid version format: " + text);
            }
            this.protocolName = "HTTP";
            this.majorVersion = HttpVersion.toDecimal(text.charAt(5));
            this.minorVersion = HttpVersion.toDecimal(text.charAt(7));
        } else {
            void var2_3;
            Matcher m = VERSION_PATTERN.matcher(text);
            if (!m.matches()) {
                void var1_1;
                throw new IllegalArgumentException("invalid version format: " + (String)var1_1);
            }
            this.protocolName = m.group(1);
            this.majorVersion = Integer.parseInt(m.group(2));
            this.minorVersion = Integer.parseInt(var2_3.group(3));
        }
        this.text = this.protocolName + '/' + this.majorVersion + '.' + this.minorVersion;
        this.keepAliveDefault = var3_4;
        this.bytes = null;
    }

    private static int toDecimal(int value) {
        int n;
        if (value < 48 || value > 57) {
            throw new IllegalArgumentException("Invalid version number, only 0-9 (0x30-0x39) allowed, but received a '" + (char)value + "' (0x" + Integer.toHexString(value) + ")");
        }
        return n - 48;
    }

    /*
     * WARNING - void declaration
     */
    public HttpVersion(String protocolName, int majorVersion, int minorVersion, boolean keepAliveDefault) {
        this((String)var1_1, (int)var2_2, (int)var3_3, keepAliveDefault, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HttpVersion(String protocolName, int majorVersion, int minorVersion, boolean keepAliveDefault, boolean bytes) {
        void var3_3;
        void var2_2;
        void var1_1;
        protocolName = ObjectUtil.checkNonEmptyAfterTrim((String)protocolName, (String)"protocolName").toUpperCase();
        for (int i = 0; i < protocolName.length(); ++i) {
            if (!Character.isISOControl(protocolName.charAt(i)) && !Character.isWhitespace(protocolName.charAt(i))) continue;
            throw new IllegalArgumentException("invalid character in protocolName");
        }
        ObjectUtil.checkPositiveOrZero((int)majorVersion, (String)"majorVersion");
        ObjectUtil.checkPositiveOrZero((int)minorVersion, (String)"minorVersion");
        this.protocolName = protocolName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.text = (String)var1_1 + '/' + (int)var2_2 + '.' + (int)var3_3;
        this.keepAliveDefault = keepAliveDefault;
        if (bytes) {
            this.bytes = this.text.getBytes(CharsetUtil.US_ASCII);
            return;
        }
        this.bytes = null;
    }

    public String protocolName() {
        return this.protocolName;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public String text() {
        return this.text;
    }

    public boolean isKeepAliveDefault() {
        return this.keepAliveDefault;
    }

    public String toString() {
        return this.text();
    }

    public int hashCode() {
        return (this.protocolName().hashCode() * 31 + this.majorVersion()) * 31 + this.minorVersion();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof HttpVersion)) {
            return false;
        }
        HttpVersion that = (HttpVersion)o;
        return this.minorVersion() == that.minorVersion() && this.majorVersion() == that.majorVersion() && this.protocolName().equals(var1_1.protocolName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(HttpVersion o) {
        void var1_1;
        int v = this.protocolName().compareTo(o.protocolName());
        if (v != 0) {
            return v;
        }
        v = this.majorVersion() - o.majorVersion();
        if (v != 0) {
            void var2_2;
            return (int)var2_2;
        }
        return this.minorVersion() - var1_1.minorVersion();
    }

    /*
     * WARNING - void declaration
     */
    void encode(ByteBuf buf) {
        void var1_1;
        if (this.bytes == null) {
            buf.writeCharSequence((CharSequence)this.text, CharsetUtil.US_ASCII);
            return;
        }
        var1_1.writeBytes(this.bytes);
    }
}

