/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS;
    private static final AsciiString SEMICOLON;
    private static final String COMMA_STRING;
    private static final long TOKEN_CHARS_HIGH;
    private static final long TOKEN_CHARS_LOW;

    private HttpUtil() {
    }

    public static boolean isOriginForm(URI uri) {
        return HttpUtil.isOriginForm(uri.toString());
    }

    public static boolean isOriginForm(String uri) {
        return uri.startsWith("/");
    }

    public static boolean isAsteriskForm(URI uri) {
        return HttpUtil.isAsteriskForm(uri.toString());
    }

    public static boolean isAsteriskForm(String uri) {
        String string;
        return "*".equals(string);
    }

    public static boolean isKeepAlive(HttpMessage message) {
        HttpMessage httpMessage;
        return !message.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true) && (message.protocolVersion().isKeepAliveDefault() || httpMessage.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true));
    }

    /*
     * WARNING - void declaration
     */
    public static void setKeepAlive(HttpMessage message, boolean keepAlive) {
        void var1_1;
        HttpMessage httpMessage;
        HttpUtil.setKeepAlive(message.headers(), httpMessage.protocolVersion(), (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void setKeepAlive(HttpHeaders h, HttpVersion httpVersion, boolean keepAlive) {
        HttpHeaders httpHeaders;
        void var2_2;
        if (httpVersion.isKeepAliveDefault()) {
            if (keepAlive) {
                h.remove((CharSequence)HttpHeaderNames.CONNECTION);
                return;
            }
            h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            return;
        }
        if (var2_2 != false) {
            h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            return;
        }
        httpHeaders.remove((CharSequence)HttpHeaderNames.CONNECTION);
    }

    /*
     * WARNING - void declaration
     */
    public static long getContentLength(HttpMessage message) {
        HttpMessage httpMessage;
        String value = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value != null) {
            void var1_1;
            return Long.parseLong((String)var1_1);
        }
        long webSocketContentLength = HttpUtil.getWebSocketContentLength(httpMessage);
        if (webSocketContentLength >= 0L) {
            void var2_2;
            return (long)var2_2;
        }
        throw new NumberFormatException("header not found: " + HttpHeaderNames.CONTENT_LENGTH);
    }

    /*
     * WARNING - void declaration
     */
    public static long getContentLength(HttpMessage message, long defaultValue) {
        void var1_1;
        HttpMessage httpMessage;
        String value = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (value != null) {
            void var3_2;
            return Long.parseLong((String)var3_2);
        }
        long webSocketContentLength = HttpUtil.getWebSocketContentLength(httpMessage);
        if (webSocketContentLength >= 0L) {
            return webSocketContentLength;
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int getContentLength(HttpMessage message, int defaultValue) {
        void var1_1;
        HttpMessage httpMessage;
        return (int)Math.min(Integer.MAX_VALUE, HttpUtil.getContentLength(httpMessage, (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static int getWebSocketContentLength(HttpMessage message) {
        void var1_1;
        HttpMessage httpMessage;
        HttpHeaders h = message.headers();
        if (message instanceof HttpRequest) {
            HttpMessage req = (HttpRequest)message;
            if (HttpMethod.GET.equals(httpMessage.method()) && h.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1) && h.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (httpMessage instanceof HttpResponse && (httpMessage = (HttpResponse)httpMessage).status().code() == 101 && h.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && var1_1.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static void setContentLength(HttpMessage message, long length) {
        void var1_1;
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)((long)var1_1));
    }

    public static boolean isContentLengthSet(HttpMessage m) {
        return m.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage message) {
        HttpMessage httpMessage;
        return HttpUtil.isExpectHeaderValid(message) && httpMessage.headers().contains((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE, true);
    }

    static boolean isUnsupportedExpectation(HttpMessage message) {
        String string;
        if (!HttpUtil.isExpectHeaderValid(message)) {
            return false;
        }
        String expectValue = message.headers().get((CharSequence)HttpHeaderNames.EXPECT);
        return expectValue != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(string);
    }

    private static boolean isExpectHeaderValid(HttpMessage message) {
        HttpMessage httpMessage;
        return message instanceof HttpRequest && httpMessage.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static void set100ContinueExpected(HttpMessage message, boolean expected) {
        HttpMessage httpMessage;
        if (expected) {
            message.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE);
            return;
        }
        httpMessage.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
    }

    public static boolean isTransferEncodingChunked(HttpMessage message) {
        return message.headers().containsValue((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void setTransferEncodingChunked(HttpMessage m, boolean chunked) {
        void var1_2;
        HttpMessage httpMessage;
        if (chunked) {
            m.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            m.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            return;
        }
        List<String> encodings = m.headers().getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (encodings.isEmpty()) {
            return;
        }
        ArrayList<String> values = new ArrayList<String>(encodings);
        Iterator valuesIt = values.iterator();
        while (valuesIt.hasNext()) {
            void var3_4;
            CharSequence value = (CharSequence)valuesIt.next();
            if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase((CharSequence)var3_4)) continue;
            valuesIt.remove();
        }
        if (values.isEmpty()) {
            m.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            return;
        }
        httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Iterable<?>)var1_2);
    }

    public static Charset getCharset(HttpMessage message) {
        return HttpUtil.getCharset(message, CharsetUtil.ISO_8859_1);
    }

    public static Charset getCharset(CharSequence contentTypeValue) {
        if (contentTypeValue != null) {
            CharSequence charSequence;
            return HttpUtil.getCharset(charSequence, CharsetUtil.ISO_8859_1);
        }
        return CharsetUtil.ISO_8859_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Charset getCharset(HttpMessage message, Charset defaultCharset) {
        void var1_1;
        String contentTypeValue = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue != null) {
            String string;
            return HttpUtil.getCharset(string, defaultCharset);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Charset getCharset(CharSequence contentTypeValue, Charset defaultCharset) {
        void var1_1;
        CharSequence charsetRaw;
        if (contentTypeValue != null && (charsetRaw = HttpUtil.getCharsetAsSequence(contentTypeValue)) != null) {
            if (charsetRaw.length() > 2 && charsetRaw.charAt(0) == '\"') {
                CharSequence charSequence = charsetRaw;
                if (charSequence.charAt(charSequence.length() - 1) == '\"') {
                    charsetRaw = charsetRaw.subSequence(1, charsetRaw.length() - 1);
                }
            }
            try {
                CharSequence charSequence;
                return Charset.forName(charSequence.toString());
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {}
        }
        return var1_1;
    }

    @Deprecated
    public static CharSequence getCharsetAsString(HttpMessage message) {
        return HttpUtil.getCharsetAsSequence(message);
    }

    public static CharSequence getCharsetAsSequence(HttpMessage message) {
        String contentTypeValue = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue != null) {
            String string;
            return HttpUtil.getCharsetAsSequence(string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence getCharsetAsSequence(CharSequence contentTypeValue) {
        ObjectUtil.checkNotNull((Object)contentTypeValue, (String)"contentTypeValue");
        int indexOfCharset = AsciiString.indexOfIgnoreCaseAscii((CharSequence)contentTypeValue, (CharSequence)CHARSET_EQUALS, (int)0);
        if (indexOfCharset == -1) {
            return null;
        }
        int indexOfEncoding = indexOfCharset + CHARSET_EQUALS.length();
        if (indexOfEncoding < contentTypeValue.length()) {
            void var1_1;
            CharSequence charSequence;
            CharSequence charsetCandidate = contentTypeValue.subSequence(indexOfEncoding, contentTypeValue.length());
            int indexOfSemicolon = AsciiString.indexOfIgnoreCaseAscii((CharSequence)charsetCandidate, (CharSequence)SEMICOLON, (int)0);
            if (indexOfSemicolon == -1) {
                return charsetCandidate;
            }
            return charSequence.subSequence(0, (int)var1_1);
        }
        return null;
    }

    public static CharSequence getMimeType(HttpMessage message) {
        String contentTypeValue = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeValue != null) {
            String string;
            return HttpUtil.getMimeType(string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence getMimeType(CharSequence contentTypeValue) {
        ObjectUtil.checkNotNull((Object)contentTypeValue, (String)"contentTypeValue");
        int indexOfSemicolon = AsciiString.indexOfIgnoreCaseAscii((CharSequence)contentTypeValue, (CharSequence)SEMICOLON, (int)0);
        if (indexOfSemicolon != -1) {
            void var1_1;
            return contentTypeValue.subSequence(0, (int)var1_1);
        }
        if (contentTypeValue.length() > 0) {
            CharSequence charSequence;
            return charSequence;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatHostnameForHttp(InetSocketAddress addr) {
        void var1_1;
        String hostString = NetUtil.getHostname((InetSocketAddress)addr);
        if (NetUtil.isValidIpV6Address((String)hostString)) {
            if (!addr.isUnresolved()) {
                InetSocketAddress inetSocketAddress;
                hostString = NetUtil.toAddressString((InetAddress)inetSocketAddress.getAddress());
            } else if (hostString.charAt(0) == '[') {
                String string = hostString;
                if (string.charAt(string.length() - 1) == ']') {
                    return hostString;
                }
            }
            return "[" + hostString + ']';
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long normalizeAndGetContentLength(List<? extends CharSequence> contentLengthFields, boolean isHttp10OrEarlier, boolean allowDuplicateContentLengths) {
        void var1_1;
        if (contentLengthFields.isEmpty()) {
            return -1L;
        }
        String firstField22 = contentLengthFields.get(0).toString();
        boolean bl = contentLengthFields.size() > 1 || firstField22.indexOf(44) >= 0;
        if (bl && var1_1 == false) {
            int n;
            if (n != 0) {
                String firstValue = null;
                for (CharSequence stringArray : contentLengthFields) {
                    String[] stringArray2;
                    String[] stringArray3 = stringArray2 = stringArray.toString().split(COMMA_STRING, -1);
                    n = stringArray2.length;
                    for (int firstField22 = 0; firstField22 < n; ++firstField22) {
                        String string = stringArray3[firstField22];
                        String trimmed = string.trim();
                        if (firstValue == null) {
                            firstValue = trimmed;
                            continue;
                        }
                        if (trimmed.equals(firstValue)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + contentLengthFields);
                    }
                }
                firstField22 = firstValue;
            } else {
                List<? extends CharSequence> list;
                throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
            }
        }
        if (firstField22.isEmpty() || !Character.isDigit(firstField22.charAt(0))) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + firstField22);
        }
        try {
            long firstValue = Long.parseLong(firstField22);
            return ObjectUtil.checkPositiveOrZero((long)firstValue, (String)"Content-Length value");
        }
        catch (NumberFormatException e) {
            void var3_6;
            throw new IllegalArgumentException("Content-Length value is not a number: " + (String)var3_6, e);
        }
    }

    static int validateToken(CharSequence token) {
        CharSequence charSequence;
        if (token instanceof AsciiString) {
            return HttpUtil.validateAsciiStringToken((AsciiString)token);
        }
        return HttpUtil.validateCharSequenceToken(charSequence);
    }

    private static int validateAsciiStringToken(AsciiString token) {
        byte[] array = token.array();
        int len = token.arrayOffset() + token.length();
        for (int i = token.arrayOffset(); i < len; ++i) {
            if (BitSet128.contains(array[i], TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i - token.arrayOffset();
        }
        return -1;
    }

    private static int validateCharSequenceToken(CharSequence token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            byte by = (byte)token.charAt(i);
            if (BitSet128.contains(by, TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        CHARSET_EQUALS = AsciiString.of((CharSequence)(HttpHeaderValues.CHARSET + "="));
        SEMICOLON = AsciiString.cached((String)";");
        COMMA_STRING = ",";
        BitSet128 tokenChars = new BitSet128().range('0', '9').range('a', 'z').range('A', 'Z').bits('-', '.', '_', '~').bits('!', '#', '$', '%', '&', '\'', '*', '+', '^', '`', '|');
        TOKEN_CHARS_HIGH = tokenChars.high();
        TOKEN_CHARS_LOW = var0.low();
    }

    private static final class BitSet128 {
        private long high;
        private long low;

        private BitSet128() {
        }

        final BitSet128 range(char fromInc, char toInc) {
            for (int bit = fromInc; bit <= toInc; ++bit) {
                if (bit < 64) {
                    this.low |= 1L << bit;
                    continue;
                }
                this.high |= 1L << bit - 64;
            }
            return this;
        }

        final BitSet128 bits(char ... bits) {
            char[] cArray = bits;
            int n = bits.length;
            for (int i = 0; i < n; ++i) {
                char bit = cArray[i];
                if (bit < '@') {
                    this.low |= 1L << bit;
                    continue;
                }
                this.high |= 1L << bit - 64;
            }
            return this;
        }

        final long high() {
            return this.high;
        }

        final long low() {
            return this.low;
        }

        /*
         * WARNING - void declaration
         */
        static boolean contains(byte bit, long high, long low) {
            byte by;
            void var1_1;
            if (bit < 0) {
                return false;
            }
            if (bit < 64) {
                void var3_2;
                return 0L != (var3_2 & 1L << bit);
            }
            return 0L != (var1_1 & 1L << by - 64);
        }
    }
}

