/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.util.AsciiString;

public enum HttpStatusClass {
    INFORMATIONAL(100, 200, "Informational"),
    SUCCESS(200, 300, "Success"),
    REDIRECTION(300, 400, "Redirection"),
    CLIENT_ERROR(400, 500, "Client Error"),
    SERVER_ERROR(500, 600, "Server Error"),
    UNKNOWN(0, 0, "Unknown Status"){
        {
            void var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(int code) {
            void var1_1;
            return code < 100 || var1_1 >= 600;
        }
    };

    private static final HttpStatusClass[] statusArray;
    private final int min;
    private final int max;
    private final AsciiString defaultReasonPhrase;

    public static HttpStatusClass valueOf(int code) {
        int n;
        if (UNKNOWN.contains(code)) {
            return UNKNOWN;
        }
        return statusArray[HttpStatusClass.fast_div100(n)];
    }

    private static int fast_div100(int dividend) {
        return (int)((long)dividend * 1374389535L >> 37);
    }

    /*
     * WARNING - void declaration
     */
    public static HttpStatusClass valueOf(CharSequence code) {
        if (code != null && code.length() == 3) {
            CharSequence charSequence;
            char c0 = code.charAt(0);
            if (HttpStatusClass.isDigit(c0) && HttpStatusClass.isDigit(code.charAt(1)) && HttpStatusClass.isDigit(charSequence.charAt(2))) {
                void var1_1;
                return HttpStatusClass.valueOf(HttpStatusClass.digit((char)var1_1) * 100);
            }
            return UNKNOWN;
        }
        return UNKNOWN;
    }

    private static int digit(char c) {
        return c - 48;
    }

    private static boolean isDigit(char c) {
        char c2;
        return c >= '0' && c2 <= '9';
    }

    /*
     * WARNING - void declaration
     */
    private HttpStatusClass(int min, int max, String defaultReasonPhrase) {
        void var3_3;
        this.min = var3_3;
        this.max = max;
        this.defaultReasonPhrase = AsciiString.cached((String)defaultReasonPhrase);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(int code) {
        void var1_1;
        return code >= this.min && var1_1 < this.max;
    }

    AsciiString defaultReasonPhrase() {
        return this.defaultReasonPhrase;
    }

    static {
        HttpStatusClass[] httpStatusClassArray = new HttpStatusClass[6];
        statusArray = httpStatusClassArray;
        httpStatusClassArray[1] = INFORMATIONAL;
        HttpStatusClass.statusArray[2] = SUCCESS;
        HttpStatusClass.statusArray[3] = REDIRECTION;
        HttpStatusClass.statusArray[4] = CLIENT_ERROR;
        HttpStatusClass.statusArray[5] = SERVER_ERROR;
    }
}

