/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private final SourceCodec sourceCodec;
    private final UpgradeCodecFactory upgradeCodecFactory;
    private final HttpHeadersFactory headersFactory;
    private final HttpHeadersFactory trailersFactory;
    private boolean handlingUpgrade;

    /*
     * WARNING - void declaration
     */
    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory) {
        this((SourceCodec)var1_1, (UpgradeCodecFactory)var2_2, 0, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int maxContentLength) {
        this((SourceCodec)var1_1, (UpgradeCodecFactory)var2_2, (int)var3_3, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int maxContentLength, boolean validateHeaders) {
        this((SourceCodec)var1_1, (UpgradeCodecFactory)var2_2, (int)var3_3, DefaultHttpHeadersFactory.headersFactory().withValidation(validateHeaders), DefaultHttpHeadersFactory.trailersFactory().withValidation(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int maxContentLength, HttpHeadersFactory headersFactory, HttpHeadersFactory trailersFactory) {
        super((int)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.sourceCodec = (SourceCodec)ObjectUtil.checkNotNull((Object)var1_1, (String)"sourceCodec");
        this.upgradeCodecFactory = (UpgradeCodecFactory)ObjectUtil.checkNotNull((Object)var2_2, (String)"upgradeCodecFactory");
        this.headersFactory = (HttpHeadersFactory)ObjectUtil.checkNotNull((Object)headersFactory, (String)"headersFactory");
        this.trailersFactory = (HttpHeadersFactory)ObjectUtil.checkNotNull((Object)trailersFactory, (String)"trailersFactory");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        void var1_1;
        FullHttpRequest fullRequest;
        if (!this.handlingUpgrade) {
            if (!(msg instanceof HttpRequest)) {
                ReferenceCountUtil.retain((Object)msg);
                ctx.fireChannelRead((Object)msg);
                return;
            }
            HttpRequest req = (HttpRequest)msg;
            if (req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE) && this.shouldHandleUpgradeRequest(req)) {
                this.handlingUpgrade = true;
            } else {
                ReferenceCountUtil.retain((Object)msg);
                ctx.fireChannelRead((Object)msg);
                return;
            }
        }
        if (msg instanceof FullHttpRequest) {
            fullRequest = (FullHttpRequest)msg;
            ReferenceCountUtil.retain((Object)msg);
            out.add(msg);
        } else {
            void var2_2;
            super.decode(ctx, (Object)var2_2, out);
            if (out.isEmpty()) {
                return;
            }
            assert (out.size() == 1);
            this.handlingUpgrade = false;
            fullRequest = (FullHttpRequest)out.get(0);
        }
        if (this.upgrade((ChannelHandlerContext)var1_1, fullRequest)) {
            void var3_3;
            var3_3.clear();
        }
    }

    protected boolean shouldHandleUpgradeRequest(HttpRequest req) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean upgrade(ChannelHandlerContext ctx, FullHttpRequest request) {
        List<CharSequence> list = HttpServerUpgradeHandler.splitHeader(request.headers().get((CharSequence)HttpHeaderNames.UPGRADE));
        int numRequestedProtocols = list.size();
        UpgradeCodec upgradeCodec = null;
        CharSequence upgradeProtocol = null;
        for (int i = 0; i < numRequestedProtocols; ++i) {
            CharSequence p = list.get(i);
            UpgradeCodec c = this.upgradeCodecFactory.newUpgradeCodec(p);
            if (c == null) continue;
            upgradeProtocol = p;
            upgradeCodec = c;
            break;
        }
        if (upgradeCodec == null) {
            return false;
        }
        List<String> connectionHeaderValues = request.headers().getAll((CharSequence)HttpHeaderNames.CONNECTION);
        if (connectionHeaderValues == null || connectionHeaderValues.isEmpty()) {
            return false;
        }
        StringBuilder concatenatedConnectionValue = new StringBuilder(connectionHeaderValues.size() * 10);
        for (CharSequence charSequence : connectionHeaderValues) {
            concatenatedConnectionValue.append(charSequence).append(',');
        }
        StringBuilder stringBuilder = concatenatedConnectionValue;
        stringBuilder.setLength(stringBuilder.length() - 1);
        Collection<CharSequence> requiredHeaders = upgradeCodec.requiredUpgradeHeaders();
        List<CharSequence> list2 = HttpServerUpgradeHandler.splitHeader(concatenatedConnectionValue);
        if (!AsciiString.containsContentEqualsIgnoreCase(list2, (CharSequence)HttpHeaderNames.UPGRADE) || !AsciiString.containsAllContentEqualsIgnoreCase(list2, requiredHeaders)) {
            return false;
        }
        for (CharSequence requiredHeader : requiredHeaders) {
            if (request.headers().contains(requiredHeader)) continue;
            return false;
        }
        FullHttpResponse fullHttpResponse = this.createUpgradeResponse(upgradeProtocol);
        if (!upgradeCodec.prepareUpgradeResponse(ctx, request, fullHttpResponse.headers())) {
            return false;
        }
        UpgradeEvent event = new UpgradeEvent(upgradeProtocol, request);
        try {
            void var1_1;
            void var2_3;
            ChannelFuture channelFuture = ctx.writeAndFlush((Object)fullHttpResponse);
            this.sourceCodec.upgradeFrom(ctx);
            upgradeCodec.upgradeTo(ctx, (FullHttpRequest)var2_3);
            ctx.pipeline().remove((ChannelHandler)this);
            var1_1.fireUserEventTriggered((Object)event.retain());
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            event.release();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private FullHttpResponse createUpgradeResponse(CharSequence upgradeProtocol) {
        void var2_2;
        void var1_1;
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, this.headersFactory, this.trailersFactory);
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static List<CharSequence> splitHeader(CharSequence header) {
        void var2_2;
        StringBuilder builder = new StringBuilder(header.length());
        ArrayList<String> protocols = new ArrayList<String>(4);
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                protocols.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            void var1_1;
            protocols.add(var1_1.toString());
        }
        return var2_2;
    }

    public static final class UpgradeEvent
    implements ReferenceCounted {
        private final CharSequence protocol;
        private final FullHttpRequest upgradeRequest;

        /*
         * WARNING - void declaration
         */
        UpgradeEvent(CharSequence protocol, FullHttpRequest upgradeRequest) {
            void var2_2;
            void var1_1;
            this.protocol = var1_1;
            this.upgradeRequest = var2_2;
        }

        public final CharSequence protocol() {
            return this.protocol;
        }

        public final FullHttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        public final int refCnt() {
            return this.upgradeRequest.refCnt();
        }

        public final UpgradeEvent retain() {
            this.upgradeRequest.retain();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final UpgradeEvent retain(int increment) {
            void var1_1;
            this.upgradeRequest.retain((int)var1_1);
            return this;
        }

        public final UpgradeEvent touch() {
            this.upgradeRequest.touch();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final UpgradeEvent touch(Object hint) {
            void var1_1;
            this.upgradeRequest.touch(var1_1);
            return this;
        }

        public final boolean release() {
            return this.upgradeRequest.release();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean release(int decrement) {
            void var1_1;
            return this.upgradeRequest.release((int)var1_1);
        }

        public final String toString() {
            return "UpgradeEvent [protocol=" + this.protocol + ", upgradeRequest=" + this.upgradeRequest + ']';
        }
    }

    public static interface UpgradeCodecFactory {
        public UpgradeCodec newUpgradeCodec(CharSequence var1);
    }

    public static interface UpgradeCodec {
        public Collection<CharSequence> requiredUpgradeHeaders();

        public boolean prepareUpgradeResponse(ChannelHandlerContext var1, FullHttpRequest var2, HttpHeaders var3);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpRequest var2);
    }

    public static interface SourceCodec {
        public void upgradeFrom(ChannelHandlerContext var1);
    }
}

