/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;

public class HttpServerKeepAliveHandler
extends ChannelDuplexHandler {
    private static final String MULTIPART_PREFIX = "multipart";
    private boolean persistentConnection = true;
    private int pendingResponses;

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (this.persistentConnection) {
                void var3_3;
                ++this.pendingResponses;
                this.persistentConnection = HttpUtil.isKeepAlive((HttpMessage)var3_3);
            }
        }
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.trackResponse(response);
            if (!HttpUtil.isKeepAlive(response) || !HttpServerKeepAliveHandler.isSelfDefinedMessageLength(response)) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                HttpUtil.setKeepAlive(response, false);
            }
        }
        if (msg instanceof LastHttpContent && !this.shouldKeepAlive()) {
            promise = promise.unvoid().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        super.write((ChannelHandlerContext)var1_1, (Object)var2_2, (ChannelPromise)var3_3);
    }

    private void trackResponse(HttpResponse response) {
        if (!HttpServerKeepAliveHandler.isInformational(response)) {
            --this.pendingResponses;
        }
    }

    private boolean shouldKeepAlive() {
        return this.pendingResponses != 0 || this.persistentConnection;
    }

    private static boolean isSelfDefinedMessageLength(HttpResponse response) {
        HttpResponse httpResponse;
        return HttpUtil.isContentLengthSet(response) || HttpUtil.isTransferEncodingChunked(response) || HttpServerKeepAliveHandler.isMultipart(response) || HttpServerKeepAliveHandler.isInformational(response) || httpResponse.status().code() == HttpResponseStatus.NO_CONTENT.code();
    }

    private static boolean isInformational(HttpResponse response) {
        return response.status().codeClass() == HttpStatusClass.INFORMATIONAL;
    }

    private static boolean isMultipart(HttpResponse response) {
        String string;
        String contentType = response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && string.regionMatches(true, 0, MULTIPART_PREFIX, 0, 9);
    }
}

