/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpStatusClass;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public final class HttpServerCodec
extends CombinedChannelDuplexHandler<HttpRequestDecoder, HttpResponseEncoder>
implements HttpServerUpgradeHandler.SourceCodec {
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();

    public HttpServerCodec() {
        this(4096, 8192, 8192);
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders, int initialBufferSize) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize).setAllowDuplicateContentLengths(allowDuplicateContentLengths));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths, boolean allowPartialChunks) {
        this(new HttpDecoderConfig().setMaxInitialLineLength((int)var1_1).setMaxHeaderSize((int)var2_2).setMaxChunkSize((int)var3_3).setValidateHeaders(validateHeaders).setInitialBufferSize(initialBufferSize).setAllowDuplicateContentLengths(allowDuplicateContentLengths).setAllowPartialChunks(allowPartialChunks));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpServerCodec(HttpDecoderConfig config) {
        void var1_1;
        this.init((ChannelInboundHandler)new HttpServerRequestDecoder((HttpDecoderConfig)var1_1), (ChannelOutboundHandler)new HttpServerResponseEncoder());
    }

    @Override
    public final void upgradeFrom(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private final class HttpServerResponseEncoder
    extends HttpResponseEncoder {
        private HttpMethod method;

        private HttpServerResponseEncoder() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void sanitizeHeadersBeforeEncode(HttpResponse msg, boolean isAlwaysEmpty) {
            void var2_2;
            void var1_1;
            if (!isAlwaysEmpty && HttpMethod.CONNECT.equals(this.method) && msg.status().codeClass() == HttpStatusClass.SUCCESS) {
                msg.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                return;
            }
            super.sanitizeHeadersBeforeEncode((HttpResponse)var1_1, (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final boolean isContentAlwaysEmpty(HttpResponse msg) {
            void var1_1;
            this.method = (HttpMethod)HttpServerCodec.this.queue.poll();
            return HttpMethod.HEAD.equals(this.method) || super.isContentAlwaysEmpty((HttpResponse)var1_1);
        }
    }

    private final class HttpServerRequestDecoder
    extends HttpRequestDecoder {
        /*
         * WARNING - void declaration
         */
        HttpServerRequestDecoder(HttpDecoderConfig config) {
            void var2_2;
            super((HttpDecoderConfig)var2_2);
        }

        @Override
        protected final void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
            int oldSize = out.size();
            super.decode(ctx, buffer, out);
            int size = out.size();
            for (int i = oldSize; i < size; ++i) {
                Object obj = out.get(i);
                if (!(obj instanceof HttpRequest)) continue;
                HttpServerCodec.this.queue.add(((HttpRequest)obj).method());
            }
        }
    }
}

